/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public abstract class TreeNode<T extends TreeNode<T>> {
    protected T parent;
    final List<T> children = new ArrayList<T>();

    public T getParent() {
        return this.parent;
    }

    protected T addChild(T child) {
        if (((TreeNode)child).parent == this) {
            return child;
        }
        if (!((TreeNode)child).children.isEmpty()) {
            T a = this.parent;
            while (a != null) {
                if (a == child) {
                    throw new IllegalArgumentException("The child is an ancestor of the current node");
                }
                a = ((TreeNode)a).parent;
            }
        }
        ((TreeNode)child).removeFromParent();
        ((TreeNode)child).parent = this;
        this.children.add(child);
        return child;
    }

    public List<T> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void sortChildren(Comparator<T> comparator) {
        this.children.sort(comparator);
    }

    void removeFromParent() {
        if (this.parent != null) {
            ((TreeNode)this.parent).children.remove(this);
            this.parent = null;
        }
    }

    public Stream<T> streamDepthFirst() {
        return Stream.of(Stream.of(this), this.getChildren().stream().flatMap(TreeNode::streamDepthFirst)).flatMap(s -> s);
    }
}

