/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.sql;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.api.service.TemplateService;
import org.ehrbase.openehr.aqlengine.AqlEhrPathPostProcessor;
import org.ehrbase.openehr.aqlengine.AqlFromEhrOptimisationPostProcessor;
import org.ehrbase.openehr.aqlengine.asl.AqlSqlLayer;
import org.ehrbase.openehr.aqlengine.asl.AslCleanupPostProcessor;
import org.ehrbase.openehr.aqlengine.asl.AslGraph;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathCohesionAnalysis;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathInfo;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.select.SelectWrapper;
import org.ehrbase.openehr.aqlengine.sql.AqlSqlQueryBuilder;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.ehrbase.openehr.util.TestConfig;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.SelectQuery;
import org.jooq.impl.DefaultDSLContext;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

class AqlSqlQueryBuilderTest {
    private final KnowledgeCacheService mockKnowledgeCacheService = (KnowledgeCacheService)Mockito.mock((Object[])new KnowledgeCacheService[0]);

    AqlSqlQueryBuilderTest() {
    }

    private AqlSqlQueryBuilder aqlSqlQueryBuilder() {
        TemplateService templateService = (TemplateService)Mockito.mock((Object[])new TemplateService[0]);
        Mockito.when((Object)templateService.findAllTemplateIds()).thenReturn(Map.of(UUID.randomUUID(), "template1.v1", UUID.randomUUID(), "template2.v3"));
        return new AqlSqlQueryBuilder(TestConfig.aqlConfigurationProperties(), (DSLContext)new DefaultDSLContext(SQLDialect.POSTGRES), templateService, Optional.empty());
    }

    @BeforeEach
    void setUp() {
        Mockito.reset((Object[])new KnowledgeCacheService[]{this.mockKnowledgeCacheService});
        Mockito.when((Object)this.mockKnowledgeCacheService.findUuidByTemplateId(ArgumentMatchers.anyString())).thenReturn(Optional.of(UUID.randomUUID()));
    }

    @Disabled
    @Test
    void printSqlQuery() {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)"    SELECT c/feeder_audit/original_content FROM COMPOSITION c\n");
        System.out.println("/*");
        System.out.println(aqlQuery.render());
        System.out.println("*/");
        new AqlEhrPathPostProcessor().afterParseAql(aqlQuery, null, null);
        new AqlFromEhrOptimisationPostProcessor().afterParseAql(aqlQuery, null, null);
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery);
        AqlSqlLayer aqlSqlLayer = new AqlSqlLayer(this.mockKnowledgeCacheService, () -> "node");
        AslRootQuery aslQuery = aqlSqlLayer.buildAslRootQuery(queryWrapper);
        new AslCleanupPostProcessor().afterBuildAsl(aslQuery, aqlQuery, queryWrapper, null);
        System.out.println("/*");
        System.out.println(AslGraph.createAslGraph(aslQuery));
        System.out.println("*/");
        System.out.println();
        AqlSqlQueryBuilder sqlQueryBuilder = this.aqlSqlQueryBuilder();
        SelectQuery sqlQuery = sqlQueryBuilder.buildSqlQuery(aslQuery);
        System.out.println(sqlQuery);
    }

    @ParameterizedTest
    @ValueSource(strings={"SELECT o/data/events/data/items/value/magnitude\nFROM OBSERVATION o [openEHR-EHR-OBSERVATION.conformance_observation.v0]\nWHERE o/data[at0001]/events[at0002]/data[at0003]/items[at0008]/value = 82.0\n", "SELECT e/ehr_id/value, cv0/commit_audit/time_committed/value, c0\nFROM EHR e\nCONTAINS FOLDER f0[name/value = '1439656']\nCONTAINS VERSION cv0[LATEST_VERSION]\nCONTAINS COMPOSITION c0\n"})
    void canBuildSqlQuery(String aql) {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)aql);
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery);
        AqlSqlLayer aqlSqlLayer = new AqlSqlLayer(this.mockKnowledgeCacheService, () -> "node");
        AslRootQuery aslQuery = aqlSqlLayer.buildAslRootQuery(queryWrapper);
        AqlSqlQueryBuilder sqlQueryBuilder = this.aqlSqlQueryBuilder();
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> sqlQueryBuilder.buildSqlQuery(aslQuery));
    }

    @Test
    void queryOnData() {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)"SELECT\nc/content,\nc/content[at0001],\nc/content[at0002],\nc/uid/value,\nc/context/other_context[at0004]/items[at0014]/value\nFROM EHR e CONTAINS COMPOSITION c\nWHERE e/ehr_id/value = 'e6fad8ba-fb4f-46a2-bf82-66edb43f142f'\n");
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.buildSqlQuery(queryWrapper));
    }

    @Test
    void queryOnFolder() {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)"SELECT\nf/uid/value\nFROM EHR\nCONTAINS FOLDER f\n");
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery);
        Assertions.assertThat((Map)queryWrapper.pathInfos()).hasSize(1);
        ((ObjectAssert)Assertions.assertThat((List)queryWrapper.selects()).singleElement()).satisfies(new ThrowingConsumer[]{select -> {
            Assertions.assertThat((Comparable)select.type()).isEqualTo((Object)SelectWrapper.SelectType.PATH);
            Assertions.assertThat((Optional)select.getSelectPath()).hasValueSatisfying(path -> Assertions.assertThat((String)path).isEqualTo("f/uid/value"));
            Assertions.assertThat((Object)select.root()).satisfies(new ThrowingConsumer[]{root -> {
                Assertions.assertThat((String)root.getRmType()).isEqualTo("FOLDER");
                Assertions.assertThat((String)root.alias()).isEqualTo("f");
            }});
        }});
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.buildSqlQuery(queryWrapper));
    }

    @Test
    void queryOnFolderWithComposition() {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)"    SELECT\n      c/uid/value\n    FROM FOLDER CONTAINS COMPOSITION c\n");
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery);
        Assertions.assertThat((Map)queryWrapper.pathInfos()).hasSize(1);
        ((ObjectAssert)Assertions.assertThat((List)queryWrapper.selects()).singleElement()).satisfies(new ThrowingConsumer[]{select -> {
            Assertions.assertThat((Comparable)select.type()).isEqualTo((Object)SelectWrapper.SelectType.PATH);
            Assertions.assertThat((Optional)select.getSelectPath()).hasValueSatisfying(path -> Assertions.assertThat((String)path).isEqualTo("c/uid/value"));
            Assertions.assertThat((Object)select.root()).satisfies(new ThrowingConsumer[]{root -> {
                Assertions.assertThat((String)root.getRmType()).isEqualTo("COMPOSITION");
                Assertions.assertThat((String)root.alias()).isEqualTo("c");
            }});
        }});
        SelectQuery<Record> selectQuery = this.buildSqlQuery(queryWrapper);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)selectQuery.toString()).contains(new CharSequence[]{"\"sF_0sq\".\"fi_uuids\" as \"sF_0_item_id_value\""})).contains(new CharSequence[]{"and \"descendant\".\"num\" between \"base\".\"num\" and \"base\".\"num_cap\""})).contains(new CharSequence[]{"on \"sCO_c_0\".\"sCO_c_0_vo_id\" = \"sF_0\".\"sF_0_item_id_value\""});
    }

    @Test
    void clusterWithDataMultiplicitySelectSingle() {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)"SELECT\n    cluster/items[at0001]/value/data\nFROM COMPOSITION CONTAINS CLUSTER cluster[openEHR-EHR-CLUSTER.media_file.v1]\n");
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery);
        Assertions.assertThat((Map)queryWrapper.pathInfos()).hasSize(1);
        PathInfo pathInfo = queryWrapper.pathInfos().entrySet().stream().findFirst().map(Map.Entry::getValue).orElseThrow();
        PathCohesionAnalysis.PathCohesionTreeNode cohesionTreeRoot = pathInfo.getCohesionTreeRoot();
        Assertions.assertThat((boolean)pathInfo.isMultipleValued(cohesionTreeRoot)).isFalse();
        SelectQuery<Record> selectQuery = this.buildSqlQuery(queryWrapper);
        Assertions.assertThat((String)selectQuery.toString()).doesNotContain(new CharSequence[]{"select jsonb_array_elements("});
    }

    @ParameterizedTest(name="{index} {0}")
    @MethodSource
    void aslGraphRegression(String name, String aql, String aslGraph) {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)aql);
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery);
        AqlSqlLayer aqlSqlLayer = new AqlSqlLayer(this.mockKnowledgeCacheService, () -> "node");
        AslRootQuery aslQuery = aqlSqlLayer.buildAslRootQuery(queryWrapper);
        Assertions.assertThat((String)AslGraph.createAslGraph(aslQuery)).isEqualToIgnoringWhitespace((CharSequence)aslGraph);
    }

    public static Stream<Arguments> aslGraphRegression() throws IOException {
        PathMatchingResourcePatternResolver res = new PathMatchingResourcePatternResolver(AqlSqlQueryBuilderTest.class.getClassLoader());
        Resource[] resources = res.getResources("classpath*:/org/ehrbase/openehr/aqlengine/testdata/aslGraphRegression-*.txt");
        return Arrays.stream(resources).map(r -> {
            try {
                String filename = r.getFilename();
                String testName = filename.substring(filename.indexOf(45) + 1, filename.length() - 4);
                String[] parts = r.getContentAsString(StandardCharsets.UTF_8).split("\\R+##.+\\R+");
                return Arguments.of((Object[])new Object[]{testName, parts[1].trim(), parts.length < 3 ? "" : parts[2].trim()});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private SelectQuery<Record> buildSqlQuery(AqlQueryWrapper queryWrapper) {
        AqlSqlLayer aqlSqlLayer = new AqlSqlLayer(this.mockKnowledgeCacheService, () -> "node");
        AslRootQuery aslQuery = aqlSqlLayer.buildAslRootQuery(queryWrapper);
        AqlSqlQueryBuilder sqlQueryBuilder = this.aqlSqlQueryBuilder();
        return sqlQueryBuilder.buildSqlQuery(aslQuery);
    }
}

