/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.testdata;

import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.ehrbase.openehr.aqlengine.testdata.TemplateSupport;
import org.ehrbase.openehr.sdk.client.openehrclient.OpenEhrClientConfig;
import org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient.DefaultRestClient;
import org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient.DefaultRestCompositionEndpoint;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.CanonicalJson;

public class CompositionSupport {
    private final CanonicalJson json = new CanonicalJson();
    private final Function<UUID, DefaultRestCompositionEndpoint> endpoint = uuid -> new DefaultRestCompositionEndpoint(new DefaultRestClient(cfg), uuid);
    private final TemplateSupport templateSupport;
    private static final String COMPOSITION;

    public CompositionSupport(OpenEhrClientConfig cfg) {
        this.templateSupport = new TemplateSupport(cfg);
    }

    public ObjectVersionId create(UUID ehrId) {
        Composition composition = (Composition)this.json.unmarshal(COMPOSITION, Composition.class);
        this.templateSupport.ensureTemplateExistence(composition);
        return this.endpoint.apply(ehrId).mergeRaw(composition);
    }

    static {
        try {
            URL url = CompositionSupport.class.getResource("composition.json");
            COMPOSITION = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

