/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.dto.AqlQueryRequest;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.openehr.aqlengine.asl.AslPostProcessor;
import org.ehrbase.openehr.aqlengine.asl.AslUtils;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslDescendantCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslPathChildCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslProvidesJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslAggregatingField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslConstantField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslFolderItemIdVirtualField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslOrderByField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslRmPathField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslSubqueryField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslAuditDetailsJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslDelegatingJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslFolderItemJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslPathFilterJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslEncapsulatingQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslFilteringQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslPathDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRmObjectDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.jooq.Field;
import org.springframework.stereotype.Component;

@Component
public class AslCleanupPostProcessor
implements AslPostProcessor {
    @Override
    public void afterBuildAsl(AslRootQuery aslRootQuery, AqlQuery aqlQuery, AqlQueryWrapper aqlQueryWrapper, AqlQueryRequest aqlQueryRequest) {
        UsedFields usedFields = new UsedFields();
        AslCleanupPostProcessor.findUsedFields(aslRootQuery, usedFields);
        usedFields.forEachQuery(AslCleanupPostProcessor::cleanupSelect);
    }

    private static void findUsedFields(AslQuery q, UsedFields usedFields) {
        AslQuery aslQuery = q;
        Objects.requireNonNull(aslQuery);
        AslQuery aslQuery2 = aslQuery;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslPathDataQuery.class, AslRootQuery.class, AslEncapsulatingQuery.class, AslFilteringQuery.class, AslStructureQuery.class, AslRmObjectDataQuery.class}, (Object)aslQuery2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AslPathDataQuery pdq = (AslPathDataQuery)aslQuery2;
                usedFields.addFieldName(pdq.getBase(), AslStructureColumn.DATA.getFieldName());
                break;
            }
            case 1: {
                AslRootQuery rq = (AslRootQuery)aslQuery2;
                AslCleanupPostProcessor.concatStreams(rq.getSelect().stream(), rq.getChildren().stream().map(Pair::getRight).filter(Objects::nonNull).map(AslJoin::getOn).flatMap(Collection::stream).flatMap(AslCleanupPostProcessor::streamJoinConditionFields), AslUtils.streamConditionFields(rq.getCondition()), rq.getStructureConditions().stream().flatMap(AslUtils::streamConditionFields), rq.getOrderByFields().stream().map(AslOrderByField::field), rq.getGroupByFields().stream(), rq.getGroupByDvOrderedMagnitudeFields().stream()).forEach(f -> usedFields.addFieldNames(AslCleanupPostProcessor.determineOwner(f), (AslField)f));
                rq.getChildren().forEach(cq -> AslCleanupPostProcessor.findUsedFields((AslQuery)cq.getLeft(), usedFields));
                break;
            }
            case 2: {
                AslEncapsulatingQuery eq = (AslEncapsulatingQuery)aslQuery2;
                AslCleanupPostProcessor.concatStreams(eq.getChildren().stream().map(Pair::getRight).filter(Objects::nonNull).map(AslJoin::getOn).flatMap(Collection::stream).flatMap(AslCleanupPostProcessor::streamJoinConditionFields), AslUtils.streamConditionFields(eq.getCondition()), eq.getStructureConditions().stream().flatMap(AslUtils::streamConditionFields)).forEach(f -> usedFields.addFieldNames(AslCleanupPostProcessor.determineOwner(f), (AslField)f));
                eq.getChildren().stream().map(Pair::getLeft).forEach(cq -> AslCleanupPostProcessor.findUsedFields(cq, usedFields));
                break;
            }
            case 3: {
                AslFilteringQuery fq = (AslFilteringQuery)aslQuery2;
                usedFields.addFieldNames(fq.getSourceField().getOwner(), fq.getSourceField());
                break;
            }
            case 4: {
                AslStructureQuery sq = (AslStructureQuery)aslQuery2;
                usedFields.addFieldNames((AslQuery)sq, List.of(AslStructureColumn.VO_ID.getFieldName(), "id"));
                sq.joinConditionsForFiltering().values().stream().flatMap(Collection::stream).flatMap(AslCleanupPostProcessor::streamJoinConditionFields).forEach(f -> usedFields.addFieldNames(AslCleanupPostProcessor.determineOwner(f), (AslField)f));
                break;
            }
            case 5: {
                AslRmObjectDataQuery rodq = (AslRmObjectDataQuery)aslQuery2;
                throw new IllegalArgumentException("unexpected AslRmObjectDataQuery");
            }
        }
    }

    @SafeVarargs
    private static <T> Stream<T> concatStreams(Stream<T> ... streams) {
        return Arrays.stream(streams).flatMap(s -> s);
    }

    private static AslQuery determineOwner(AslField f) {
        AslField aslField = f;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslSubqueryField.class, AslAggregatingField.class}, (Object)aslField, n)) {
            case -1 -> null;
            case 0 -> {
                AslSubqueryField sf = (AslSubqueryField)aslField;
                yield ((AslDataQuery)sf.getBaseQuery()).getBase();
            }
            case 1 -> {
                AslAggregatingField af = (AslAggregatingField)aslField;
                yield AslCleanupPostProcessor.determineOwner(af.getBaseField());
            }
            default -> f.getOwner();
        };
    }

    private static Stream<AslField> streamJoinConditionFields(AslJoinCondition joinCondition) {
        AslJoinCondition aslJoinCondition = joinCondition;
        Objects.requireNonNull(aslJoinCondition);
        AslJoinCondition aslJoinCondition2 = aslJoinCondition;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslPathFilterJoinCondition.class, AslAuditDetailsJoinCondition.class, AslDelegatingJoinCondition.class, AslFolderItemJoinCondition.class}, (Object)aslJoinCondition2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslPathFilterJoinCondition pfjc = (AslPathFilterJoinCondition)aslJoinCondition2;
                yield AslUtils.streamConditionFields(pfjc.getCondition());
            }
            case 1 -> {
                AslAuditDetailsJoinCondition adjc = (AslAuditDetailsJoinCondition)aslJoinCondition2;
                yield Stream.of(AslStructureColumn.AUDIT_ID.fieldWithOwner(adjc.getLeftOwner()), new AslColumnField(UUID.class, Tables.AUDIT_DETAILS.ID.getName(), false).withOwner(adjc.getRightOwner()));
            }
            case 2 -> {
                AslDelegatingJoinCondition adjc = (AslDelegatingJoinCondition)aslJoinCondition2;
                AslProvidesJoinCondition v2 = adjc.getDelegate();
                Objects.requireNonNull(v2);
                AslProvidesJoinCondition var9_6 = v2;
                int var10_8 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslDescendantCondition.class, AslFieldJoinCondition.class, AslPathChildCondition.class}, (Object)var9_6, var10_8)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        AslDescendantCondition djc = (AslDescendantCondition)var9_6;
                        yield Stream.of(new AslColumnField(UUID.class, Tables.EHR_.ID.getName(), false).withOwner(djc.getLeftOwner()), AslStructureColumn.EHR_ID.fieldWithOwner(djc.getLeftOwner()), AslStructureColumn.EHR_ID.fieldWithOwner(djc.getRightOwner()), AslStructureColumn.VO_ID.fieldWithOwner(djc.getLeftOwner()), AslStructureColumn.VO_ID.fieldWithOwner(djc.getRightOwner()), AslStructureColumn.NUM.fieldWithOwner(djc.getLeftOwner()), AslStructureColumn.NUM_CAP.fieldWithOwner(djc.getLeftOwner()), AslStructureColumn.NUM.fieldWithOwner(djc.getRightOwner()), AslStructureColumn.EHR_FOLDER_IDX.fieldWithOwner(djc.getLeftOwner()), AslStructureColumn.EHR_FOLDER_IDX.fieldWithOwner(djc.getRightOwner()));
                    }
                    case 1: {
                        AslFieldJoinCondition fjc = (AslFieldJoinCondition)var9_6;
                        yield Stream.of(fjc.getLeftField(), fjc.getRightField());
                    }
                    case 2: 
                }
                AslPathChildCondition pcjc = (AslPathChildCondition)var9_6;
                yield Stream.of(AslStructureColumn.EHR_ID.fieldWithOwner(pcjc.getLeftOwner()), AslStructureColumn.EHR_ID.fieldWithOwner(pcjc.getRightOwner()), AslStructureColumn.VO_ID.fieldWithOwner(pcjc.getLeftOwner()), AslStructureColumn.VO_ID.fieldWithOwner(pcjc.getRightOwner()), AslStructureColumn.NUM.fieldWithOwner(pcjc.getLeftOwner()), AslStructureColumn.PARENT_NUM.fieldWithOwner(pcjc.getRightOwner()), AslStructureColumn.EHR_FOLDER_IDX.fieldWithOwner(pcjc.getLeftOwner()), AslStructureColumn.EHR_FOLDER_IDX.fieldWithOwner(pcjc.getRightOwner()));
            }
            case 3 -> {
                AslFolderItemJoinCondition fijc = (AslFolderItemJoinCondition)aslJoinCondition2;
                yield Stream.of(AslStructureColumn.VO_ID.fieldWithOwner(fijc.getRightOwner()), new AslFolderItemIdVirtualField(AslField.FieldSource.withOwner(fijc.getLeftOwner())));
            }
        };
    }

    private static Stream<String> streamFieldNames(AslField field) {
        AslField aslField = field;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslColumnField.class, AslRmPathField.class, AslConstantField.class, AslAggregatingField.class, AslComplexExtractedColumnField.class, AslSubqueryField.class, AslFolderItemIdVirtualField.class}, (Object)aslField, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslColumnField cf = (AslColumnField)aslField;
                yield Stream.of(cf.getColumnName());
            }
            case 1 -> {
                AslRmPathField pf = (AslRmPathField)aslField;
                yield Stream.of(pf.getSrcField().getColumnName());
            }
            case 2 -> {
                AslConstantField __ = (AslConstantField)aslField;
                yield Stream.empty();
            }
            case 3 -> {
                AslAggregatingField af = (AslAggregatingField)aslField;
                yield AslCleanupPostProcessor.streamFieldNames(af.getBaseField());
            }
            case 4 -> {
                AslComplexExtractedColumnField ecf = (AslComplexExtractedColumnField)aslField;
                yield ecf.getExtractedColumn().getColumns().stream();
            }
            case 5 -> {
                AslSubqueryField sqf = (AslSubqueryField)aslField;
                yield AslCleanupPostProcessor.concatStreams(AslUtils.getTargetType(((AslDataQuery)sqf.getBaseQuery()).getBase()).getPkeyFields().stream().map(Field::getName), sqf.getFilterConditions().stream().flatMap(AslUtils::streamConditionFields).flatMap(AslCleanupPostProcessor::streamFieldNames), Stream.of(AslStructureColumn.NUM.getFieldName()), Stream.of(AslStructureColumn.NUM_CAP.getFieldName()));
            }
            case 6 -> {
                AslFolderItemIdVirtualField f = (AslFolderItemIdVirtualField)aslField;
                yield Stream.of(f.getFieldName());
            }
            case -1 -> Stream.empty();
        };
    }

    private static void cleanupSelect(AslQuery q, Set<String> usedFieldNames) {
        if (q instanceof AslStructureQuery) {
            AslStructureQuery sq = (AslStructureQuery)q;
            sq.getSelect().removeIf(f -> {
                AslColumnField cf;
                return f instanceof AslColumnField && !usedFieldNames.contains((cf = (AslColumnField)f).getColumnName());
            });
        }
    }

    public int getOrder() {
        return 0;
    }

    private static final class UsedFields {
        Map<AslQuery, Set<String>> usedFields = new HashMap<AslQuery, Set<String>>();

        private UsedFields() {
        }

        public void forEachQuery(BiConsumer<AslQuery, Set<String>> queryConsumer) {
            this.usedFields.forEach(queryConsumer);
        }

        public void addFieldNames(AslQuery base, AslField field) {
            this.usedFields.compute(base, (k, v) -> {
                Set result = v != null ? v : new HashSet();
                AslCleanupPostProcessor.streamFieldNames(field).forEach(result::add);
                return result;
            });
        }

        public void addFieldNames(AslQuery base, Collection<String> names) {
            this.usedFields.compute(base, (k, v) -> {
                Set result = v != null ? v : new HashSet();
                result.addAll(names);
                return result;
            });
        }

        public void addFieldName(AslQuery base, String name) {
            this.usedFields.compute(base, (k, v) -> {
                Set result = v != null ? v : new HashSet();
                result.add(name);
                return result;
            });
        }
    }
}

