/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine;

import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.dto.AqlQueryRequest;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.openehr.aqlengine.AqlLimitPostProcessor;
import org.ehrbase.openehr.aqlengine.TestAqlQueryContext;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class AqlLimitPostProcessorTest {
    AqlLimitPostProcessorTest() {
    }

    @ParameterizedTest
    @CsvSource(textBlock="    5||10||REJECT||||Query contains a LIMIT clause, fetch and offset parameters must not be used (with fetch precedence REJECT)\n    5|20||40|REJECT||||Query parameter for offset provided, but no fetch parameter\n    5|20||40|MIN_FETCH||||Query parameter for offset provided, but no fetch parameter\n    5|||30|REJECT||||Query parameter for offset provided, but no fetch parameter\n    |||42|REJECT||||Query parameter for offset provided, but no fetch parameter\n    20||||REJECT||19||Query LIMIT 20 exceeds maximum limit 19\n    20||||MIN_FETCH||19||Query LIMIT 20 exceeds maximum limit 19\n    ||20||REJECT|||19|Fetch parameter 20 exceeds maximum fetch 19\n    ||20||MIN_FETCH|||19|Fetch parameter 20 exceeds maximum fetch 19\n    20|5|30||MIN_FETCH||||Query contains a OFFSET clause, fetch parameter must not be used (with fetch precedence MIN_FETCH)\n", delimiterString="|")
    void queryOffsetLimitRejected(String aqlLimit, String aqlOffset, String paramLimit, String paramOffset, AqlLimitPostProcessor.FetchPrecedence fetchPrecedence, String defaultLimit, String maxLimit, String maxFetch, String message) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runQueryTest(aqlLimit, aqlOffset, paramLimit, paramOffset, fetchPrecedence, defaultLimit, maxLimit, maxFetch)).isInstanceOf(UnprocessableEntityException.class)).hasMessage(message);
    }

    @ParameterizedTest
    @CsvSource(textBlock="    ||||REJECT|||\n    5||||REJECT|||\n    5|15|||REJECT|||\n    ||20||REJECT|||\n    ||20|25|REJECT|||\n    ||||REJECT|20|10|10\n    20|30|||REJECT|20|20|20\n    ||20|50|REJECT|20|20|20\n    30||20|50|MIN_FETCH|30|30|20\n    10||20|50|MIN_FETCH|30|30|20\n", delimiterString="|")
    void queryOffsetLimitAccepted(String aqlLimit, String aqlOffset, String paramLimit, String paramOffset, AqlLimitPostProcessor.FetchPrecedence fetchPrecedence, String defaultLimit, String maxLimit, String maxFetch) {
        this.runQueryTest(aqlLimit, aqlOffset, paramLimit, paramOffset, fetchPrecedence, defaultLimit, maxLimit, maxFetch);
    }

    private void runQueryTest(String aqlLimit, String aqlOffset, String paramLimit, String paramOffset, AqlLimitPostProcessor.FetchPrecedence fetchPrecedence, String defaultLimit, String maxLimit, String maxFetch) {
        String query = "SELECT s FROM EHR_STATUS s %s %s".formatted(AqlLimitPostProcessorTest.parseLong(aqlLimit).map(s -> "LIMIT " + s).orElse(""), AqlLimitPostProcessorTest.parseLong(aqlOffset).map(s -> "OFFSET " + s).orElse(""));
        new AqlLimitPostProcessor((Long)AqlLimitPostProcessorTest.parseLong(defaultLimit).orElse(null), (Long)AqlLimitPostProcessorTest.parseLong(maxLimit).orElse(null), (Long)AqlLimitPostProcessorTest.parseLong(maxFetch).orElse(null), fetchPrecedence).afterParseAql(AqlQuery.parse((String)query), new AqlQueryRequest(query, Map.of(), (Long)AqlLimitPostProcessorTest.parseLong(paramLimit).orElse(null), (Long)Optional.ofNullable(paramOffset).filter(s -> !s.isEmpty()).map(Long::parseLong).orElse(null)), (AqlQueryContext)new TestAqlQueryContext());
    }

    private static Optional<Long> parseLong(String longStr) {
        return Optional.ofNullable(longStr).filter(StringUtils::isNotEmpty).map(Long::parseLong);
    }
}

