/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.pathanalysis;

import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.ehrbase.openehr.aqlengine.pathanalysis.FoundationType;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathAnalysis;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class FoundationTypeTest {
    FoundationTypeTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"STRING", "LONG", "TEMPORAL"})
    void hasFoundationType(String name) {
        Assertions.assertThat((Comparable)FoundationType.valueOf((String)name)).isNotNull();
    }

    @Test
    void foundationTypesComplete() {
        LinkedList<RMTypeInfo> remainingTypes = new LinkedList<RMTypeInfo>();
        remainingTypes.add(PathAnalysis.RM_INFOS.getTypeInfo("COMPOSITION"));
        HashSet<RMTypeInfo> seen = new HashSet<RMTypeInfo>();
        seen.add((RMTypeInfo)remainingTypes.peek());
        HashSet typeNames = new HashSet();
        while (!remainingTypes.isEmpty()) {
            RMTypeInfo typeInfo = (RMTypeInfo)remainingTypes.poll();
            typeInfo.getDirectDescendantClasses().stream().filter(seen::add).forEach(remainingTypes::add);
            if (Modifier.isAbstract(typeInfo.getJavaClass().getModifiers())) continue;
            typeInfo.getAttributes().values().stream().filter(ti -> !ti.isComputed()).map(ai -> {
                String typeName = ai.getTypeNameInCollection();
                RMTypeInfo ti = PathAnalysis.RM_INFOS.getTypeInfo(typeName);
                if (ti == null) {
                    typeNames.add(typeName);
                }
                return typeName;
            }).map(arg_0 -> ((ArchieRMInfoLookup)PathAnalysis.RM_INFOS).getTypeInfo(arg_0)).filter(Objects::nonNull).filter(seen::add).forEach(remainingTypes::add);
        }
        Assertions.assertThat(Arrays.stream(FoundationType.values()).map(Enum::name)).containsExactlyInAnyOrderElementsOf(typeNames);
    }
}

