/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.sql.postprocessor;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.openehr.aqlengine.ChangeTypeUtils;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.sql.postprocessor.ExtractedColumnResultPostprocessor;
import org.ehrbase.openehr.sdk.util.OpenEHRDateTimeSerializationUtils;
import org.jooq.Record;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;

class ExtractedColumnResultPostprocessorTest {
    private final KnowledgeCacheService knowledgeCacheService = (KnowledgeCacheService)Mockito.mock(KnowledgeCacheService.class);
    private final Record dbRecord = (Record)Mockito.mock(Record.class);

    ExtractedColumnResultPostprocessorTest() {
    }

    private ExtractedColumnResultPostprocessor processor(AslExtractedColumn extractedColumn) {
        return new ExtractedColumnResultPostprocessor(extractedColumn, this.knowledgeCacheService, "test-node");
    }

    @BeforeEach
    void setUp() {
        Mockito.reset((Object[])new Object[]{this.knowledgeCacheService, this.dbRecord});
    }

    @Test
    void nullSafe() {
        Assertions.assertThat((Object)this.processor(AslExtractedColumn.VO_ID).postProcessColumn(null)).isNull();
    }

    @Test
    void templateId() {
        UUID uuid = UUID.fromString("93e01a9a-041e-4bf6-89c2-e63f8a74a4d5");
        ((KnowledgeCacheService)Mockito.doReturn(Optional.of("test-template")).when((Object)this.knowledgeCacheService)).findTemplateIdByUuid(uuid);
        Assertions.assertThat((Object)this.processor(AslExtractedColumn.TEMPLATE_ID).postProcessColumn((Object)uuid)).isEqualTo((Object)"test-template");
    }

    @Test
    void ehrSystemId() {
        Assertions.assertThat((Object)this.processor(AslExtractedColumn.EHR_SYSTEM_ID_DV).postProcessColumn((Object)"e290acd1-0fa4-4eb0-97c6-e884e6ea74f3")).isEqualTo((Object)new HierObjectId("e290acd1-0fa4-4eb0-97c6-e884e6ea74f3"));
    }

    @Test
    void rootConcept() {
        Assertions.assertThat((Object)this.processor(AslExtractedColumn.ROOT_CONCEPT).postProcessColumn((Object)"root_concept")).isEqualTo((Object)"openEHR-EHR-COMPOSITIONroot_concept");
    }

    @Test
    void archetypeNodeId() {
        ((Record)Mockito.doReturn((Object)".entityConcept").when((Object)this.dbRecord)).get(0);
        ((Record)Mockito.doReturn((Object)"HX").when((Object)this.dbRecord)).get(1);
        Assertions.assertThat((Object)this.processor(AslExtractedColumn.ARCHETYPE_NODE_ID).postProcessColumn((Object)this.dbRecord)).isEqualTo((Object)"openEHR-EHR-HIER_OBJECT_ID.entityConcept");
    }

    @Test
    void vo_id() {
        ((Record)Mockito.doReturn((Object)"c0817101-94fd-48e5-b4f9-cb8f0556923a").when((Object)this.dbRecord)).get(0);
        ((Record)Mockito.doReturn((Object)"42").when((Object)this.dbRecord)).get(1);
        Assertions.assertThat((Object)this.processor(AslExtractedColumn.VO_ID).postProcessColumn((Object)this.dbRecord)).isEqualTo((Object)"c0817101-94fd-48e5-b4f9-cb8f0556923a::test-node::42");
    }

    @Test
    void auditDetailsDescription() {
        Assertions.assertThat((Object)this.processor(AslExtractedColumn.AD_DESCRIPTION_DV).postProcessColumn((Object)"lorem ipsum")).isEqualTo((Object)new DvText("lorem ipsum"));
    }

    @Test
    void auditDetailsChangeType() {
        ContributionChangeType changeType = ContributionChangeType.creation;
        Assertions.assertThat((Object)this.processor(AslExtractedColumn.AD_CHANGE_TYPE_DV).postProcessColumn((Object)changeType)).isEqualTo((Object)new DvCodedText(changeType.getLiteral().toLowerCase(), new CodePhrase(new TerminologyId("openehr"), ChangeTypeUtils.getCodeByJooqChangeType((ContributionChangeType)changeType), changeType.getLiteral().toLowerCase())));
    }

    @Test
    void auditDetailsChangeTypeCode() {
        Assertions.assertThat((Object)this.processor(AslExtractedColumn.AD_CHANGE_TYPE_CODE_STRING).postProcessColumn((Object)ContributionChangeType.deleted)).isEqualTo((Object)"523");
    }

    @ParameterizedTest
    @EnumSource(value=AslExtractedColumn.class, mode=EnumSource.Mode.INCLUDE, names={"AD_CHANGE_TYPE_VALUE", "AD_CHANGE_TYPE_PREFERRED_TERM"})
    void auditDetailsChangeTypeValue(AslExtractedColumn aslExtractedColumn) {
        Assertions.assertThat((Object)this.processor(aslExtractedColumn).postProcessColumn((Object)ContributionChangeType.amendment)).isEqualTo((Object)"amendment");
    }

    @ParameterizedTest
    @EnumSource(value=AslExtractedColumn.class, mode=EnumSource.Mode.INCLUDE, names={"OV_TIME_COMMITTED_DV", "EHR_TIME_CREATED_DV"})
    void dateTime(AslExtractedColumn aslExtractedColumn) {
        OffsetDateTime now = OffsetDateTime.now();
        Assertions.assertThat((Object)this.processor(aslExtractedColumn).postProcessColumn((Object)now)).isEqualTo((Object)new DvDateTime((TemporalAccessor)now));
    }

    @ParameterizedTest
    @EnumSource(value=AslExtractedColumn.class, mode=EnumSource.Mode.INCLUDE, names={"OV_TIME_COMMITTED", "EHR_TIME_CREATED"})
    void time(AslExtractedColumn aslExtractedColumn) {
        OffsetDateTime now = OffsetDateTime.now();
        Assertions.assertThat((Object)this.processor(aslExtractedColumn).postProcessColumn((Object)now)).isEqualTo((Object)OpenEHRDateTimeSerializationUtils.formatDateTime((TemporalAccessor)now));
    }

    @ParameterizedTest
    @EnumSource(value=AslExtractedColumn.class, mode=EnumSource.Mode.EXCLUDE, names={"TEMPLATE_ID", "EHR_SYSTEM_ID_DV", "ROOT_CONCEPT", "ARCHETYPE_NODE_ID", "VO_ID", "AD_DESCRIPTION_DV", "AD_CHANGE_TYPE_DV", "AD_CHANGE_TYPE_CODE_STRING", "AD_CHANGE_TYPE_VALUE", "AD_CHANGE_TYPE_PREFERRED_TERM", "OV_TIME_COMMITTED_DV", "EHR_TIME_CREATED_DV", "OV_TIME_COMMITTED", "EHR_TIME_CREATED"})
    void string(AslExtractedColumn aslExtractedColumn) {
        String testValue = "test_value";
        Assertions.assertThat((Object)this.processor(aslExtractedColumn).postProcessColumn((Object)testValue)).isSameAs((Object)testValue);
    }
}

