/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.testdata;

import com.nedap.archie.rm.ehr.EhrStatus;
import java.util.UUID;
import org.ehrbase.openehr.sdk.client.openehrclient.OpenEhrClientConfig;
import org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient.DefaultRestClient;
import org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient.DefaultRestEhrEndpoint;
import org.ehrbase.openehr.sdk.serialisation.jsonencoding.CanonicalJson;

public class EhrSupport {
    private static final String PARTY_REF_ID = "_REF_ID_";
    private static final String EHR_NS = "_EHR_NS_";
    private static final String EHR_TEMPLATE = "{\n  \"_type\": \"EHR_STATUS\",\n  \"archetype_node_id\": \"openEHR-EHR-EHR_STATUS.generic.v1\",\n  \"name\": {\n    \"value\": \"EHR Status\"\n  },\n  \"subject\": {\n    \"external_ref\": {\n      \"_type\": \"PARTY_REF\",\n      \"id\": {\n        \"_type\": \"GENERIC_ID\",\n        \"value\": \"_REF_ID_\",\n        \"scheme\": \"id_scheme\"\n      },\n      \"namespace\": \"_EHR_NS_\",\n      \"type\": \"PERSON\"\n    }\n  },\n  \"is_modifiable\": true,\n  \"is_queryable\": true\n}\n";
    private final CanonicalJson json = new CanonicalJson();
    private final DefaultRestEhrEndpoint endpoint;

    public EhrSupport(OpenEhrClientConfig cfg) {
        this.endpoint = new DefaultRestEhrEndpoint(new DefaultRestClient(cfg));
    }

    public UUID create(UUID partyRefId, String partyRefNs) {
        String ehr = EHR_TEMPLATE.replace(PARTY_REF_ID, partyRefId.toString()).replace(EHR_NS, partyRefNs);
        EhrStatus ehrStatus = (EhrStatus)this.json.unmarshal(ehr, EhrStatus.class);
        return this.endpoint.createEhr(ehrStatus);
    }
}

