/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.testdata;

import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.ehrbase.openehr.sdk.client.openehrclient.OpenEhrClientConfig;
import org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient.DefaultRestClient;

public class FolderSupport {
    private static final String FOLDER_ID = "_FOLDER_ID_";
    private static final String FOLDER_NAME = "_FOLDER_NAME_";
    private static final String SUB_FOLDER = "_SUB_FOLDER_";
    private static final String FOLDER_ITEM = "_FOLDER_ITEM_";
    private static final String FOLDER_TEMPLATE = "{\n  \"_type\": \"FOLDER\",\n  \"uid\": {\n    \"_type\": \"HIER_OBJECT_ID\",\n    \"value\": \"_FOLDER_ID_\"\n  },\n  \"name\": {\n    \"_type\": \"DV_TEXT\",\n    \"value\": \"_FOLDER_NAME_\"\n  },\n  \"archetype_node_id\": \"openEHR-EHR-FOLDER.generic.v1\",\n  \"folders\": [\n    _SUB_FOLDER_\n  ],\n  \"items\": [\n    _FOLDER_ITEM_\n  ]\n}\n";
    public static final String EHR_PATH = "rest/openehr/v1/ehr/";
    public static final String DIR_PATH = "/directory";
    private final OpenEhrClientConfig cfg;

    public static String render(UUID folderUUID, String folderName, String subFolder, String items) {
        return FOLDER_TEMPLATE.replace(FOLDER_ID, folderUUID.toString()).replace(FOLDER_NAME, folderName).replace(SUB_FOLDER, subFolder).replace(FOLDER_ITEM, items);
    }

    public FolderSupport(OpenEhrClientConfig cfg) {
        this.cfg = cfg;
    }

    public UUID create(UUID ehrId, String folder) {
        var restClient = new DefaultRestClient(this, this.cfg){

            ObjectVersionId doHttpPost(URI uri, String body) {
                HttpResponse response = this.internalPost(uri, null, body, ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON.getMimeType());
                Header eTag = response.getFirstHeader("ETag");
                return new ObjectVersionId(StringUtils.unwrap((String)StringUtils.removeStart((String)eTag.getValue(), (String)"W/"), (char)'\"'));
            }
        };
        return UUID.fromString(restClient.doHttpPost(this.cfg.getBaseUri().resolve(EHR_PATH + ehrId.toString() + DIR_PATH), folder).getObjectId().getValue());
    }
}

