/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.dto.AqlQueryRequest;
import org.ehrbase.openehr.aqlengine.asl.AslPostProcessor;
import org.ehrbase.openehr.aqlengine.asl.AslUtils;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldFieldQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslProvidesJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslAggregatingField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslFolderItemIdVirtualField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslOrderByField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslSubqueryField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslDelegatingJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslFolderItemJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslPathFilterJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslEncapsulatingQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslFilteringQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslPathDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRmObjectDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.springframework.stereotype.Component;

@Component
public class AslCleanupPostProcessor
implements AslPostProcessor {
    @Override
    public void afterBuildAsl(AslRootQuery aslRootQuery, AqlQuery aqlQuery, AqlQueryWrapper aqlQueryWrapper, AqlQueryRequest aqlQueryRequest) {
        UsedFields usedFields = new UsedFields();
        AslCleanupPostProcessor.findUsedFields(aslRootQuery, usedFields);
        usedFields.forEachQuery(AslCleanupPostProcessor::cleanupSelect);
    }

    private static void findUsedFields(AslQuery q, UsedFields usedFields) {
        AslQuery aslQuery = q;
        Objects.requireNonNull(aslQuery);
        AslQuery aslQuery2 = aslQuery;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslPathDataQuery.class, AslRootQuery.class, AslEncapsulatingQuery.class, AslFilteringQuery.class, AslStructureQuery.class, AslRmObjectDataQuery.class}, (Object)aslQuery2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AslPathDataQuery pdq = (AslPathDataQuery)aslQuery2;
                usedFields.addFieldName(pdq.getBase(), AslStructureColumn.DATA.getFieldName());
                break;
            }
            case 1: {
                AslRootQuery rq = (AslRootQuery)aslQuery2;
                AslUtils.concatStreams(rq.getSelect().stream(), rq.getChildren().stream().map(Pair::getRight).filter(Objects::nonNull).map(AslJoin::getOn).flatMap(Collection::stream).flatMap(AslCleanupPostProcessor::streamJoinConditionFields), AslUtils.streamConditionFields(rq.getCondition()), rq.getStructureConditions().stream().flatMap(AslUtils::streamConditionFields), rq.getOrderByFields().stream().map(AslOrderByField::field), rq.getGroupByFields().stream(), rq.getGroupByDvOrderedMagnitudeFields().stream()).forEach(f -> usedFields.addFieldNames(AslCleanupPostProcessor.determineOwner(f), (AslField)f));
                rq.getChildren().forEach(cq -> AslCleanupPostProcessor.findUsedFields((AslQuery)cq.getLeft(), usedFields));
                break;
            }
            case 2: {
                AslEncapsulatingQuery eq = (AslEncapsulatingQuery)aslQuery2;
                AslUtils.concatStreams(eq.getChildren().stream().map(Pair::getRight).filter(Objects::nonNull).map(AslJoin::getOn).flatMap(Collection::stream).flatMap(AslCleanupPostProcessor::streamJoinConditionFields), AslUtils.streamConditionFields(eq.getCondition()), eq.getStructureConditions().stream().flatMap(AslUtils::streamConditionFields)).forEach(f -> usedFields.addFieldNames(AslCleanupPostProcessor.determineOwner(f), (AslField)f));
                eq.getChildren().stream().map(Pair::getLeft).forEach(cq -> AslCleanupPostProcessor.findUsedFields(cq, usedFields));
                break;
            }
            case 3: {
                AslFilteringQuery fq = (AslFilteringQuery)aslQuery2;
                usedFields.addFieldNames(fq.getSourceField().getOwner(), fq.getSourceField());
                break;
            }
            case 4: {
                AslStructureQuery sq = (AslStructureQuery)aslQuery2;
                usedFields.addFieldNames((AslQuery)sq, List.of(AslStructureColumn.VO_ID.getFieldName(), "id"));
                sq.joinConditionsForFiltering().values().stream().flatMap(Collection::stream).flatMap(AslCleanupPostProcessor::streamJoinConditionFields).forEach(f -> usedFields.addFieldNames(AslCleanupPostProcessor.determineOwner(f), (AslField)f));
                break;
            }
            case 5: {
                AslRmObjectDataQuery rodq = (AslRmObjectDataQuery)aslQuery2;
                throw new IllegalArgumentException("unexpected AslRmObjectDataQuery");
            }
        }
    }

    private static AslQuery determineOwner(AslField f) {
        AslField aslField = f;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslSubqueryField.class, AslAggregatingField.class}, (Object)aslField, n)) {
            case -1 -> null;
            case 0 -> {
                AslSubqueryField sf = (AslSubqueryField)aslField;
                yield ((AslDataQuery)sf.getBaseQuery()).getBase();
            }
            case 1 -> {
                AslAggregatingField af = (AslAggregatingField)aslField;
                yield AslCleanupPostProcessor.determineOwner(af.getBaseField());
            }
            default -> f.getOwner();
        };
    }

    private static Stream<AslField> streamJoinConditionFields(AslJoinCondition joinCondition) {
        AslJoinCondition aslJoinCondition = joinCondition;
        Objects.requireNonNull(aslJoinCondition);
        AslJoinCondition aslJoinCondition2 = aslJoinCondition;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslPathFilterJoinCondition.class, AslDelegatingJoinCondition.class, AslFolderItemJoinCondition.class}, (Object)aslJoinCondition2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslPathFilterJoinCondition pfjc = (AslPathFilterJoinCondition)aslJoinCondition2;
                yield AslUtils.streamConditionFields(pfjc.getCondition());
            }
            case 1 -> {
                AslDelegatingJoinCondition adjc = (AslDelegatingJoinCondition)aslJoinCondition2;
                AslProvidesJoinCondition v2 = adjc.getDelegate();
                Objects.requireNonNull(v2);
                AslProvidesJoinCondition var6_5 = v2;
                int var7_7 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslFieldFieldQueryCondition.class}, (Object)var6_5, var7_7)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: 
                }
                AslFieldFieldQueryCondition fjc = (AslFieldFieldQueryCondition)var6_5;
                yield Stream.of(fjc.getLeftField(), fjc.getRightField());
            }
            case 2 -> {
                AslFolderItemJoinCondition fijc = (AslFolderItemJoinCondition)aslJoinCondition2;
                yield Stream.of(AslStructureColumn.VO_ID.fieldWithOwner(fijc.getRightOwner()), new AslFolderItemIdVirtualField(AslField.FieldSource.withOwner(fijc.getLeftOwner())));
            }
        };
    }

    private static void cleanupSelect(AslQuery q, Set<String> usedFieldNames) {
        if (q instanceof AslStructureQuery) {
            AslStructureQuery sq = (AslStructureQuery)q;
            sq.getSelect().removeIf(f -> {
                AslColumnField cf;
                return f instanceof AslColumnField && !usedFieldNames.contains((cf = (AslColumnField)f).getColumnName());
            });
        }
    }

    public int getOrder() {
        return 0;
    }

    private static final class UsedFields {
        Map<AslQuery, Set<String>> usedFields = new HashMap<AslQuery, Set<String>>();

        private UsedFields() {
        }

        public void forEachQuery(BiConsumer<AslQuery, Set<String>> queryConsumer) {
            this.usedFields.forEach(queryConsumer);
        }

        public void addFieldNames(AslQuery base, AslField field) {
            this.usedFields.compute(base, (k, v) -> {
                Set result = v != null ? v : new HashSet();
                AslUtils.streamFieldNames(field).forEach(result::add);
                return result;
            });
        }

        public void addFieldNames(AslQuery base, Collection<String> names) {
            this.usedFields.compute(base, (k, v) -> {
                Set result = v != null ? v : new HashSet();
                result.addAll(names);
                return result;
            });
        }

        public void addFieldName(AslQuery base, String name) {
            this.usedFields.compute(base, (k, v) -> {
                Set result = v != null ? v : new HashSet();
                result.add(name);
                return result;
            });
        }
    }
}

