/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.featurecheck;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.ehrbase.api.exception.AqlFeatureNotImplementedException;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.featurecheck.ClauseType;
import org.ehrbase.openehr.aqlengine.featurecheck.FeatureCheck;
import org.ehrbase.openehr.aqlengine.featurecheck.FeatureCheckUtils;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.orderby.OrderByExpression;
import org.ehrbase.openehr.sdk.aql.dto.select.SelectExpression;
import org.ehrbase.openehr.sdk.aql.render.AqlRenderer;

final class OrderByCheck
implements FeatureCheck {
    private final SystemService systemService;

    public OrderByCheck(SystemService systemService) {
        this.systemService = systemService;
    }

    @Override
    public void ensureSupported(AqlQuery aqlQuery) {
        Optional.of(aqlQuery).map(AqlQuery::getOrderBy).stream().flatMap(Collection::stream).map(OrderByExpression::getStatement).forEach(ip -> this.ensureOrderByStatementSupported(aqlQuery, (IdentifiedPath)ip));
    }

    private void ensureOrderByStatementSupported(AqlQuery aqlQuery, IdentifiedPath ip) {
        if (aqlQuery.getSelect().getStatement().stream().map(SelectExpression::getColumnExpression).filter(IdentifiedPath.class::isInstance).map(IdentifiedPath.class::cast).noneMatch(selected -> FeatureCheckUtils.startsWith(selected, ip))) {
            throw new AqlFeatureNotImplementedException("ORDER BY: Path: %s%s/%s is not present in SELECT statement".formatted(ip.getRoot().getIdentifier(), ip.getRootPredicate() == null ? "" : AqlRenderer.renderPredicate((List)ip.getRootPredicate()), ip.getPath().render()));
        }
        FeatureCheckUtils.PathDetails pathWithType = FeatureCheckUtils.findSupportedIdentifiedPath(ip, false, ClauseType.ORDER_BY, this.systemService.getSystemId());
        if (EnumSet.of(AslExtractedColumn.OV_TIME_COMMITTED, AslExtractedColumn.AD_SYSTEM_ID, AslExtractedColumn.AD_CHANGE_TYPE_TERMINOLOGY_ID_VALUE).contains((Object)pathWithType.extractedColumn())) {
            throw new AqlFeatureNotImplementedException("ORDER BY: Path: %s on VERSION".formatted(ip.getPath().render()));
        }
    }
}

