/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.pathanalysis;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ehrbase.openehr.aqlengine.pathanalysis.FoundationTypeCategory;

public enum FoundationType {
    BOOLEAN(FoundationTypeCategory.BOOLEAN),
    BYTE(FoundationTypeCategory.BYTEA),
    DOUBLE(FoundationTypeCategory.NUMERIC),
    INTEGER(FoundationTypeCategory.NUMERIC),
    LONG(FoundationTypeCategory.NUMERIC),
    STRING(FoundationTypeCategory.TEXT),
    URI(FoundationTypeCategory.TEXT),
    TEMPORAL(FoundationTypeCategory.TEXT),
    TEMPORAL_ACCESSOR(FoundationTypeCategory.TEXT),
    TEMPORAL_AMOUNT(FoundationTypeCategory.TEXT),
    CHAR(FoundationTypeCategory.TEXT),
    OBJECT(FoundationTypeCategory.ANY);

    private static final Map<String, FoundationType> BY_TYPE_NAME;
    public final FoundationTypeCategory category;

    private FoundationType(FoundationTypeCategory category) {
        this.category = category;
    }

    public static Optional<FoundationType> byTypeName(String typeName) {
        return Optional.ofNullable(BY_TYPE_NAME.get(typeName));
    }

    static {
        BY_TYPE_NAME = new HashMap<String, FoundationType>();
        for (FoundationType value : FoundationType.values()) {
            BY_TYPE_NAME.put(value.name(), value);
        }
    }
}

