/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.sql;

import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.ehrbase.jooq.pg.util.AdditionalSQLFunctions;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslDvOrderedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslRmPathField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslVirtualField;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.dbformat.RmAttributeAlias;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.QueryPart;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.impl.DSL;

final class FieldUtils {
    private FieldUtils() {
    }

    public static <T> Field<T> field(Table<?> sqlProvider, AslQuery aslProvider, AslQuery owner, String fieldName, Class<T> type, boolean aliased) {
        return FieldUtils.field(sqlProvider, FieldUtils.findFieldByOwnerAndName(aslProvider, owner, fieldName), type, aliased);
    }

    private static AslColumnField findFieldByOwnerAndName(AslQuery src, AslQuery owner, String columnName) {
        Iterator fieldsIt = src.getSelect().stream().filter(AslColumnField.class::isInstance).map(AslColumnField.class::cast).filter(f -> owner == f.getOwner()).filter(f -> f.getColumnName().equals(columnName)).iterator();
        if (!fieldsIt.hasNext()) {
            throw new IllegalArgumentException("field with columnName %s not present".formatted(columnName));
        }
        AslColumnField field = (AslColumnField)fieldsIt.next();
        if (fieldsIt.hasNext()) {
            throw new IllegalArgumentException("found multiple fields with columnName %s".formatted(columnName));
        }
        return field;
    }

    public static Field<?> field(Table<?> table, AslVirtualField aslField, String fieldName, boolean aliased) {
        return table.field(aliased ? aslField.aliasedName(fieldName) : fieldName);
    }

    public static <T> Field<T> field(Table<?> table, AslVirtualField aslField, String fieldName, Class<T> type, boolean aliased) {
        return table.field(aliased ? aslField.aliasedName(fieldName) : fieldName, type);
    }

    public static Field<?> field(Table<?> table, AslColumnField aslField, boolean aliased) {
        return table.field(aslField.getName(aliased));
    }

    public static <T> Field<T> field(Table<?> table, AslColumnField aslField, Class<T> type, boolean aliased) {
        return table.field(aslField.getName(aliased), type);
    }

    public static <T> Field<T> aliasedField(Table<?> target, AslDataQuery aslData, TableField<?, T> fieldTemplate) {
        return FieldUtils.field(target, aslData.getBase(), aslData.getBase(), fieldTemplate.getName(), fieldTemplate.getType(), true);
    }

    public static <T> Field<T> aliasedField(Table<?> target, AslDataQuery aslData, String fieldName, Class<T> fieldType) {
        return FieldUtils.field(target, aslData.getBase(), aslData.getBase(), fieldName, fieldType, true);
    }

    public static Field<?> virtualAliasedField(Table<?> target, Field<?> field, AslVirtualField column, String columnName) {
        return DSL.field((String)"{0}.{1}", (QueryPart[])new QueryPart[]{target, field}).as(column.aliasedName(columnName));
    }

    static Field<JSONB> buildJsonbPathField(List<AqlObjectPath.PathNode> pathNodes, boolean multipleValued, Field<JSONB> jsonbField) {
        Iterator attributeIt = pathNodes.stream().map(AqlObjectPath.PathNode::getAttribute).map(RmAttributeAlias::getAlias).iterator();
        Field field = jsonbField;
        while (attributeIt.hasNext()) {
            field = DSL.jsonbGetAttribute((Field)field, (Field)DSL.inline((String)((String)attributeIt.next())));
        }
        if (multipleValued) {
            field = AdditionalSQLFunctions.jsonb_array_elements(field);
        }
        return field;
    }

    public static Field<JSONB> buidDvOrderedField(boolean useAliases, AslField field, Table<?> srcTable) {
        AslField aslField = field;
        Objects.requireNonNull(aslField);
        AslField aslField2 = aslField;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslRmPathField.class, AslDvOrderedColumnField.class}, (Object)aslField2, n)) {
            case 0 -> {
                AslRmPathField arpf = (AslRmPathField)aslField2;
                Field<JSONB> srcField = FieldUtils.field(srcTable, arpf.getSrcField(), JSONB.class, true);
                yield FieldUtils.buildJsonbPathField(arpf.getPathInJson(), false, srcField);
            }
            case 1 -> {
                AslDvOrderedColumnField cf = (AslDvOrderedColumnField)aslField2;
                yield FieldUtils.field(srcTable, cf, JSONB.class, useAliases);
            }
            default -> throw new IllegalStateException("Unexpected field: " + String.valueOf(field));
        };
    }

    public static Field<?> buildRmPathField(AslRmPathField field, Table<?> src) {
        Field<JSONB> srcField = FieldUtils.field(Objects.requireNonNull(src), field.getSrcField(), JSONB.class, true);
        Field<JSONB> ret = FieldUtils.buildJsonbPathField(field.getPathInJson(), false, srcField);
        if (field.getType() == String.class) {
            return DSL.jsonbGetElementAsText(ret, (Field)DSL.inline((int)0));
        }
        return ret;
    }
}

