/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl.model.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslDvOrderedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslPathFilterJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;

public final class AslPathDataQuery
extends AslDataQuery {
    public static final String DATA_COLUMN_NAME = "data";
    private final List<AqlObjectPath.PathNode> dataPath;
    private final AslColumnField dataField;
    private final boolean multipleValued;
    private final Set<String> dvOrderedTypes;

    public AslPathDataQuery(String alias, AslQuery base, AslQuery baseProvider, List<AqlObjectPath.PathNode> dataPath, boolean multipleValued, Set<String> dvOrderedTypes, Class<?> fieldType) {
        super(alias, base, baseProvider);
        this.dvOrderedTypes = Collections.unmodifiableSet(dvOrderedTypes);
        if (!(base instanceof AslStructureQuery) && !(base instanceof AslPathDataQuery)) {
            throw new IllegalArgumentException("%s is not a valid base for AslPathDataQuery".formatted(base.getClass()));
        }
        this.dataPath = dataPath;
        AslField.FieldSource fieldSource = AslField.FieldSource.withOwner(this);
        this.dataField = CollectionUtils.isEmpty(dvOrderedTypes) ? new AslColumnField(fieldType, DATA_COLUMN_NAME, fieldSource, false) : new AslDvOrderedColumnField(DATA_COLUMN_NAME, fieldSource, dvOrderedTypes);
        this.multipleValued = multipleValued;
    }

    public AslColumnField getDataField() {
        return this.dataField;
    }

    @Override
    public Map<IdentifiedPath, List<AslPathFilterJoinCondition>> joinConditionsForFiltering() {
        return Collections.emptyMap();
    }

    @Override
    public List<AslField> getSelect() {
        return List.of(this.dataField);
    }

    public List<AqlObjectPath.PathNode> getPathNodes(AslColumnField field) {
        if (field != this.dataField) {
            throw new IllegalArgumentException("field is not part of this AslPathDataQuery");
        }
        return this.dataPath;
    }

    public boolean isMultipleValued() {
        return this.multipleValued;
    }

    public Set<String> getDvOrderedTypes() {
        return this.dvOrderedTypes;
    }
}

