/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine;

import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.ehrbase.openehr.aqlengine.AqlFromEhrOptimisationPostProcessor;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class AqlFromEhrOptimisationPostProcessorTest {
    AqlFromEhrOptimisationPostProcessorTest() {
    }

    @ParameterizedTest
    @CsvSource(textBlock="SELECT e FROM EHR e |\nSELECT e/ehr_id/value FROM EHR e CONTAINS COMPOSITION c |\nSELECT c FROM EHR e[ehr_id/value = '5dd64358-76b4-4ffe-8d05-554406d9d023'] CONTAINS COMPOSITION c |\nSELECT s_el FROM EHR e CONTAINS (COMPOSITION c AND EHR_STATUS CONTAINS ELEMENT s_el) |\nSELECT c/uid/value FROM EHR e CONTAINS COMPOSITION c WHERE e/ehr_id/value = '5dd64358-76b4-4ffe-8d05-554406d9d023' |\nSELECT c FROM EHR e CONTAINS COMPOSITION c WHERE c/uid/value = '5dd64358-76b4-4ffe-8d05-554406d9d023' | SELECT c FROM COMPOSITION c WHERE c/uid/value = '5dd64358-76b4-4ffe-8d05-554406d9d023'\n", delimiterString="|")
    void removeRedundantFromEhr(String originalAql, String optimizedAql) {
        AqlQuery query = AqlQueryParser.parse((String)originalAql);
        AqlFromEhrOptimisationPostProcessor cut = new AqlFromEhrOptimisationPostProcessor();
        cut.afterParseAql(query, null, null);
        String expected = AqlQueryParser.parse((String)(StringUtils.isBlank((CharSequence)optimizedAql) ? originalAql : optimizedAql)).render();
        Assertions.assertThat((String)query.render()).isEqualTo(expected);
    }
}

