/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.Assertions;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.api.service.TemplateService;
import org.ehrbase.openehr.aqlengine.AqlEhrPathPostProcessor;
import org.ehrbase.openehr.aqlengine.AqlFromEhrOptimisationPostProcessor;
import org.ehrbase.openehr.aqlengine.AqlQueryParsingPostProcessor;
import org.ehrbase.openehr.aqlengine.asl.AqlSqlLayer;
import org.ehrbase.openehr.aqlengine.asl.AslCleanupPostProcessor;
import org.ehrbase.openehr.aqlengine.asl.AslGraph;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.aqlengine.sql.AqlSqlQueryBuilder;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.ehrbase.openehr.util.TestConfig;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DefaultDSLContext;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class AslCleanupPostProcessorTest {
    private final KnowledgeCacheService mockKnowledgeCacheService = (KnowledgeCacheService)Mockito.mock((Object[])new KnowledgeCacheService[0]);
    private final AqlSqlQueryBuilder sqlBuilder = new AqlSqlQueryBuilder(TestConfig.aqlConfigurationProperties(), (DSLContext)new DefaultDSLContext(SQLDialect.POSTGRES), (TemplateService)Mockito.mock((Object[])new TemplateService[0]), Optional.empty());

    AslCleanupPostProcessorTest() {
    }

    @Disabled
    @ParameterizedTest
    @ValueSource(strings={"SELECT c/uid/value FROM COMPOSITION c"})
    void showAsl(String aqlStr) {
        AslResult result = this.parseAql(aqlStr);
        String originalAslGraph = AslGraph.createAslGraph(result.aslQuery());
        new AslCleanupPostProcessor().afterBuildAsl(result.aslQuery(), result.aqlQuery(), result.queryWrapper(), null);
        String modifiedAslGraph = AslGraph.createAslGraph(result.aslQuery());
        System.out.println(modifiedAslGraph);
        Assertions.assertThat((String)modifiedAslGraph).isNotEqualTo((Object)originalAslGraph);
    }

    @Test
    void simpleCleanupRegression() {
        AslResult result = this.parseAql("    SELECT c/uid/value FROM COMPOSITION c\n");
        new AslCleanupPostProcessor().afterBuildAsl(result.aslQuery(), result.aqlQuery(), result.queryWrapper(), null);
        String modifiedAslGraph = AslGraph.createAslGraph(result.aslQuery());
        Assertions.assertThat((String)modifiedAslGraph).isEqualToIgnoringWhitespace((CharSequence)"AslRootQuery\n  SELECT\n    sCO_c_0.?? -- COMPLEX VO_ID uid/value\n  FROM\n    sCO_c_0: StructureQuery\n      SELECT\n        sCO_c_0.sCO_c_0_vo_id\n        sCO_c_0.sCO_c_0_sys_version\n      FROM COMPOSITION\n");
    }

    @Test
    @Disabled
    void nestedSingleNodePathSubqueryCleanup() {
        AslResult result = this.parseAql("    SELECT c/feeder_audit/original_content FROM COMPOSITION c\n");
        new AslCleanupPostProcessor().afterBuildAsl(result.aslQuery(), result.aqlQuery(), result.queryWrapper(), null);
        String modifiedAslGraph = AslGraph.createAslGraph(result.aslQuery());
        Assertions.assertThat((String)modifiedAslGraph).isEqualToIgnoringWhitespace((CharSequence)"AslRootQuery\n  SELECT\n    p_feeder_audit__0.p_feeder_audit__0_data -> original_content\n  FROM\n    sCO_c_0: StructureQuery\n      SELECT\n        sCO_c_0.sCO_c_0_vo_id\n        sCO_c_0.sCO_c_0_num\n        sCO_c_0.sCO_c_0_ehr_id\n      FROM COMPOSITION\n\n    p_feeder_audit__0: StructureQuery\n        SELECT\n          p_feeder_audit__0.p_feeder_audit__0_vo_id\n          p_feeder_audit__0.p_feeder_audit__0_parent_num\n          p_feeder_audit__0.p_feeder_audit__0_data\n        FROM COMPOSITION\n        STRUCTURE CONDITIONS\n          p_feeder_audit__0.p_feeder_audit__0_entity_attribute EQ [f]\n        LEFT_OUTER_JOIN sCO_c_0 -> p_feeder_audit__0\n          on\n            DelegatingJoinCondition ->\n                PathChildCondition COMPOSITION sCO_c_0 -> COMPOSITION p_feeder_audit__0\n");
    }

    @Test
    void cleanupRegression() {
        AslResult result = this.parseAql("    SELECT c/uid/value,\n        o/data[at0001]/events[at0002]/data[at0003, 'name1']/items[at0004]/value/magnitude,\n        o/data[at0001]/events[at0002]/data[at0003]/items[at0004]/value/magnitude,\n        el/value/units\n    FROM EHR[ehr_id/value='860f5c5b-f121-41bb-ad66-7ac6c285526c']\n    CONTAINS EHR_STATUS s\n    AND COMPOSITION c\n     CONTAINS OBSERVATION o[openEHR-EHR-OBSERVATION.test.v0]\n        CONTAINS ELEMENT el[at0120]\n    WHERE el/name/value='Result'\n    AND el/value/value=1.3\n    ORDER BY o/name/value\n\n\n");
        new AslCleanupPostProcessor().afterBuildAsl(result.aslQuery(), result.aqlQuery(), result.queryWrapper(), null);
        String modifiedAslGraph = AslGraph.createAslGraph(result.aslQuery());
        Assertions.assertThat((String)modifiedAslGraph).isEqualToIgnoringWhitespace((CharSequence)"AslRootQuery\n  SELECT\n    sCO_c_0.?? -- COMPLEX VO_ID uid/value\n    p_items__0_f_0.p_items__0_f_0_data\n    p_items__0_f_1.p_items__0_f_1_data\n    sE_el_0.sE_el_0_data -> value -> units\n  FROM\n    sEHR_0: StructureQuery\n      SELECT\n        sEHR_0.sEHR_0_id /* ehr_id/value */\n      WHERE\n        sEHR_0.sEHR_0_id /* ehr_id/value */ EQ [860f5c5b-f121-41bb-ad66-7ac6c285526c]\n      FROM EHR\n    sES_s_0: StructureQuery\n      SELECT\n        sES_s_0.sES_s_0_vo_id\n        sES_s_0.sES_s_0_ehr_id\n      FROM EHR_STATUS\n      JOIN sEHR_0 -> sES_s_0\n        on\n          DelegatingJoinCondition ->\n              sEHR_0.sEHR_0_id /* ehr_id/value */ EQ sES_s_0.sES_s_0_ehr_id\n\n    sCO_c_0: StructureQuery\n      SELECT\n        sCO_c_0.sCO_c_0_vo_id\n        sCO_c_0.sCO_c_0_ehr_id\n        sCO_c_0.sCO_c_0_sys_version\n      FROM COMPOSITION\n      JOIN sEHR_0 -> sCO_c_0\n        on\n          DelegatingJoinCondition ->\n              sEHR_0.sEHR_0_id /* ehr_id/value */ EQ sCO_c_0.sCO_c_0_ehr_id\n\n    sOB_o_0: StructureQuery\n      SELECT\n        sOB_o_0.sOB_o_0_vo_id\n        sOB_o_0.sOB_o_0_num\n        sOB_o_0.sOB_o_0_num_cap\n        sOB_o_0.sOB_o_0_entity_name /* name/value */\n      WHERE\n        sOB_o_0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=OB, concept=.test.v0]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sOB_o_0.sOB_o_0_rm_entity IN [OB]\n      JOIN sCO_c_0 -> sOB_o_0\n        on\n          DelegatingJoinCondition ->\n              sCO_c_0.sCO_c_0_vo_id EQ sOB_o_0.sOB_o_0_vo_id\n\n    sE_el_0: StructureQuery\n      SELECT\n        sE_el_0.sE_el_0_vo_id\n        sE_el_0.sE_el_0_num\n        sE_el_0.sE_el_0_entity_name /* name/value */\n        sE_el_0.sE_el_0_data\n      WHERE\n        sE_el_0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0120]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sE_el_0.sE_el_0_rm_entity IN [E]\n      JOIN sOB_o_0 -> sE_el_0\n        on\n          DelegatingJoinCondition ->\n              sOB_o_0.sOB_o_0_vo_id EQ sE_el_0.sE_el_0_vo_id\n\n          DelegatingJoinCondition ->\n              sOB_o_0.sOB_o_0_num LT sE_el_0.sE_el_0_num\n\n          DelegatingJoinCondition ->\n              sOB_o_0.sOB_o_0_num_cap GT_EQ sE_el_0.sE_el_0_num\n\n    p_eq_0: EncapsulatingQuery\n      SELECT\n        p_data__0.p_data__0_vo_id\n        p_data__0.p_data__0_num\n        p_data__0.p_data__0_parent_num\n        p_events__0.p_events__0_vo_id\n        p_events__0.p_events__0_num\n        p_events__0.p_events__0_parent_num\n        p_data__1.p_data__1_vo_id\n        p_data__1.p_data__1_num\n        p_data__1.p_data__1_parent_num\n        p_data__1.p_data__1_entity_concept\n        p_data__1.p_data__1_entity_name /* name/value */\n        p_data__1.p_data__1_rm_entity\n        p_items__0.p_items__0_vo_id\n        p_items__0.p_items__0_parent_num\n        p_items__0.p_items__0_data\n        FROM\n          p_data__0: StructureQuery\n              SELECT\n                p_data__0.p_data__0_vo_id\n                p_data__0.p_data__0_num\n                p_data__0.p_data__0_parent_num\n              WHERE\n                p_data__0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0001]]\n              FROM COMPOSITION\n              STRUCTURE CONDITIONS\n                p_data__0.p_data__0_entity_attribute EQ [d]\n\n          p_events__0: StructureQuery\n              SELECT\n                p_events__0.p_events__0_vo_id\n                p_events__0.p_events__0_num\n                p_events__0.p_events__0_parent_num\n              WHERE\n                p_events__0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0002]]\n              FROM COMPOSITION\n              STRUCTURE CONDITIONS\n                p_events__0.p_events__0_entity_attribute EQ [e]\n              JOIN p_data__0 -> p_events__0\n                on\n                  DelegatingJoinCondition ->\n                      p_data__0.p_data__0_vo_id EQ p_events__0.p_events__0_vo_id\n\n                  DelegatingJoinCondition ->\n                      p_data__0.p_data__0_num EQ p_events__0.p_events__0_parent_num\n\n\n          p_data__1: StructureQuery\n              SELECT\n                p_data__1.p_data__1_vo_id\n                p_data__1.p_data__1_num\n                p_data__1.p_data__1_parent_num\n                p_data__1.p_data__1_entity_concept\n                p_data__1.p_data__1_entity_name /* name/value */\n                p_data__1.p_data__1_rm_entity\n              WHERE\n                p_data__1.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0003]]\n              FROM COMPOSITION\n              STRUCTURE CONDITIONS\n                p_data__1.p_data__1_entity_attribute EQ [d]\n              JOIN p_events__0 -> p_data__1\n                on\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_vo_id EQ p_data__1.p_data__1_vo_id\n\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_num EQ p_data__1.p_data__1_parent_num\n\n\n          p_items__0: StructureQuery\n              SELECT\n                p_items__0.p_items__0_vo_id\n                p_items__0.p_items__0_parent_num\n                p_items__0.p_items__0_data\n              WHERE\n                p_items__0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0004]]\n              FROM COMPOSITION\n              STRUCTURE CONDITIONS\n                p_items__0.p_items__0_entity_attribute EQ [i]\n              JOIN p_data__1 -> p_items__0\n                on\n                  PathFilterJoinCondition p_data__1 ->\n                      OR\n                        AND\n                          p_data__1.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0003]]\n                          p_data__1.p_data__1_entity_name /* name/value */ EQ [name1]\n                        p_data__1.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0003]]\n\n                  DelegatingJoinCondition ->\n                      p_data__1.p_data__1_vo_id EQ p_items__0.p_items__0_vo_id\n\n                  DelegatingJoinCondition ->\n                      p_data__1.p_data__1_num EQ p_items__0.p_items__0_parent_num\n\n\n      LEFT_OUTER_JOIN sOB_o_0 -> p_eq_0\n        on\n          DelegatingJoinCondition ->\n              sOB_o_0.sOB_o_0_vo_id EQ p_data__0.p_data__0_vo_id\n\n          DelegatingJoinCondition ->\n              sOB_o_0.sOB_o_0_num EQ p_data__0.p_data__0_parent_num\n\n    p_items__0_f_0: FilteringQuery\n      SELECT\n        p_items__0_f_0.p_items__0_f_0_data\n      LEFT_OUTER_JOIN p_eq_0 -> p_items__0_f_0\n        on\n          PathFilterJoinCondition p_data__1 ->\n              AND\n                p_eq_0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0003]]\n                p_eq_0.p_data__1_entity_name /* name/value */ EQ [name1]\n\n    p_items__0_f_1: FilteringQuery\n      SELECT\n        p_items__0_f_1.p_items__0_f_1_data\n      LEFT_OUTER_JOIN p_eq_0 -> p_items__0_f_1\n        on\n          PathFilterJoinCondition p_data__1 ->\n              p_eq_0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0003]]\n\n  WHERE\n    AND\n      sE_el_0.sE_el_0_entity_name /* name/value */ EQ [Result]\n      sE_el_0.sE_el_0_data -> value -> value EQ [1.3]\n  ORDER BY\nsOB_o_0.sOB_o_0_entity_name /* name/value */ ASC\n");
    }

    @ParameterizedTest
    @ValueSource(strings={"SELECT c/uid/value FROM COMPOSITION c"})
    void changedAsl(String aqlStr) {
        AslResult result = this.parseAql(aqlStr);
        String originalAslGraph = AslGraph.createAslGraph(result.aslQuery());
        new AslCleanupPostProcessor().afterBuildAsl(result.aslQuery(), result.aqlQuery(), result.queryWrapper(), null);
        String modifiedAslGraph = AslGraph.createAslGraph(result.aslQuery());
        Assertions.assertThat((String)modifiedAslGraph).isNotEqualTo((Object)originalAslGraph);
        Assertions.assertThatNoException().isThrownBy(() -> this.sqlBuilder.buildSqlQuery(result.aslQuery()));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource
    @Disabled
    void aslGraphRegression(String aql, String aslGraph) {
        AslResult result = this.parseAql(aql);
        new AslCleanupPostProcessor().afterBuildAsl(result.aslQuery(), result.aqlQuery(), result.queryWrapper(), null);
        String modifiedAslGraph = AslGraph.createAslGraph(result.aslQuery());
        Assertions.assertThat((String)modifiedAslGraph).isEqualToIgnoringWhitespace((CharSequence)aslGraph);
    }

    private AslResult parseAql(String aqlStr) {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)aqlStr);
        for (AqlQueryParsingPostProcessor processor : new AqlQueryParsingPostProcessor[]{new AqlEhrPathPostProcessor(), new AqlFromEhrOptimisationPostProcessor()}) {
            processor.afterParseAql(aqlQuery, null, null);
        }
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery);
        AqlSqlLayer aqlSqlLayer = new AqlSqlLayer(this.mockKnowledgeCacheService, () -> "node");
        AslRootQuery aslQuery = aqlSqlLayer.buildAslRootQuery(queryWrapper);
        return new AslResult(aqlQuery, queryWrapper, aslQuery);
    }

    private static Stream<Arguments> aslGraphRegression() {
        Stream<Arguments> stream;
        block12: {
            InputStream is = AslCleanupPostProcessor.class.getClassLoader().getResourceAsStream("aslCleanupProcessor/test_data.txt");
            try {
                Stream.Builder sb = Stream.builder();
                StringBuilder currentAqlQuery = new StringBuilder();
                StringBuilder currentAslGraph = new StringBuilder();
                Runnable nextQuery = () -> {
                    if (!currentAqlQuery.isEmpty()) {
                        sb.accept(Pair.of((Object)currentAqlQuery.toString().trim(), (Object)currentAslGraph.toString().trim()));
                        currentAqlQuery.setLength(0);
                        currentAslGraph.setLength(0);
                    }
                };
                boolean inAqlQuery = false;
                for (String l : IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8)) {
                    if (l.startsWith("#")) {
                        nextQuery.run();
                        currentAqlQuery.append(l.substring(1));
                        inAqlQuery = true;
                        continue;
                    }
                    if (l.startsWith("AslRootQuery")) {
                        inAqlQuery = false;
                        currentAslGraph.append(l).append("\n");
                        continue;
                    }
                    if (inAqlQuery) {
                        currentAqlQuery.append(l).append("\n");
                        continue;
                    }
                    currentAslGraph.append(l).append("\n");
                }
                nextQuery.run();
                stream = sb.build().map(t -> Arguments.of((Object[])new Object[]{t.getLeft(), t.getRight()}));
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return stream;
    }

    private record AslResult(AqlQuery aqlQuery, AqlQueryWrapper queryWrapper, AslRootQuery aslQuery) {
    }
}

