/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine;

import org.apache.commons.lang3.ObjectUtils;
import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.dto.AqlQueryRequest;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.openehr.aqlengine.AqlQueryParsingPostProcessor;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AqlLimitPostProcessor
implements AqlQueryParsingPostProcessor {
    private final Long defaultLimit;
    private final Long maxLimit;
    private final Long maxFetch;
    private final FetchPrecedence fetchPrecedence;

    public AqlLimitPostProcessor(@Value(value="${ehrbase.rest.aql.default-limit:}") Long defaultLimit, @Value(value="${ehrbase.rest.aql.max-limit:}") Long maxLimit, @Value(value="${ehrbase.rest.aql.max-fetch:}") Long maxFetch, @Value(value="${ehrbase.rest.aql.fetch-precedence:REJECT}") FetchPrecedence fetchPrecedence) {
        this.defaultLimit = defaultLimit;
        this.maxLimit = maxLimit;
        this.maxFetch = maxFetch;
        this.fetchPrecedence = fetchPrecedence;
    }

    public int getOrder() {
        return -3000;
    }

    @Override
    public void afterParseAql(AqlQuery aqlQuery, AqlQueryRequest request, AqlQueryContext ctx) {
        if (this.defaultLimit != null) {
            ctx.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.DEFAULT_LIMIT, (Object)this.defaultLimit);
        }
        if (this.maxLimit != null) {
            ctx.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.MAX_LIMIT, (Object)this.maxLimit);
        }
        if (this.maxFetch != null) {
            ctx.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.MAX_FETCH, (Object)this.maxFetch);
        }
        Long fetchParam = request.fetch();
        Long offsetParam = request.offset();
        Long queryLimit = aqlQuery.getLimit();
        Long queryOffset = aqlQuery.getOffset();
        if (queryLimit != null && this.maxLimit != null && queryLimit > this.maxLimit) {
            throw new UnprocessableEntityException("Query LIMIT %d exceeds maximum limit %d".formatted(queryLimit, this.maxLimit));
        }
        if (fetchParam != null && this.maxFetch != null && fetchParam > this.maxFetch) {
            throw new UnprocessableEntityException("Fetch parameter %d exceeds maximum fetch %d".formatted(fetchParam, this.maxFetch));
        }
        Long limit = AqlLimitPostProcessor.applyFetchPrecedence(this.fetchPrecedence, queryLimit, queryOffset, fetchParam, offsetParam);
        aqlQuery.setLimit((Long)ObjectUtils.firstNonNull((Object[])new Long[]{limit, this.defaultLimit}));
        aqlQuery.setOffset((Long)ObjectUtils.firstNonNull((Object[])new Long[]{offsetParam, queryOffset}));
    }

    private static Long applyFetchPrecedence(FetchPrecedence fetchPrecedence, Long queryLimit, Long queryOffset, Long fetchParam, Long offsetParam) {
        if (fetchParam == null) {
            if (offsetParam != null) {
                throw new UnprocessableEntityException("Query parameter for offset provided, but no fetch parameter");
            }
            return queryLimit;
        }
        if (queryLimit == null) {
            assert (queryOffset == null);
            return fetchParam;
        }
        switch (fetchPrecedence.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                throw new UnprocessableEntityException("Query contains a LIMIT clause, fetch and offset parameters must not be used (with fetch precedence %s)".formatted(new Object[]{fetchPrecedence}));
            }
            case 1: 
        }
        if (queryOffset != null) {
            throw new UnprocessableEntityException("Query contains a OFFSET clause, fetch parameter must not be used (with fetch precedence %s)".formatted(new Object[]{fetchPrecedence}));
        }
        return Math.min(queryLimit, fetchParam);
    }

    public static enum FetchPrecedence {
        REJECT,
        MIN_FETCH;

    }
}

