/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.Assertions;
import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.openehr.aqlengine.TestAqlQueryContext;
import org.ehrbase.openehr.aqlengine.asl.AqlSqlLayer;
import org.ehrbase.openehr.aqlengine.asl.AslCleanupPostProcessor;
import org.ehrbase.openehr.aqlengine.asl.AslGraph;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslRmPathField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslSubqueryField;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslEncapsulatingQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class AqlSqlLayerTest {
    private final KnowledgeCacheService mockKnowledgeCacheService = (KnowledgeCacheService)Mockito.mock((Object[])new KnowledgeCacheService[0]);

    @BeforeEach
    void setUp() {
        Mockito.reset((Object[])new KnowledgeCacheService[]{this.mockKnowledgeCacheService});
        Mockito.when((Object)this.mockKnowledgeCacheService.findUuidByTemplateId(ArgumentMatchers.anyString())).thenReturn(Optional.of(UUID.randomUUID()));
    }

    @Disabled
    @Test
    void printAslGraph() {
        AslRootQuery aslQuery = this.buildSqlQuery("SELECT\nc/feeder_audit,\nc/uid/value,\nc/context/other_context[at0004]/items[at0014]/value\nFROM EHR e CONTAINS COMPOSITION c\nWHERE e/ehr_id/value = 'e6fad8ba-fb4f-46a2-bf82-66edb43f142f'\n", false);
        System.out.println(AslGraph.createAslGraph(aslQuery));
    }

    @Test
    void testDataQueryPlacedLast() {
        AslRootQuery aslQuery = this.buildSqlQuery("    SELECT\n    c/content,\n    c/content[at0001],\n    c[openEHR-EHR-COMPOSITION.test.v0]/content[at0002],\n    c/uid/value,\n    c/context/other_context[at0004]/items[at0014]/value\n    FROM EHR e CONTAINS COMPOSITION c\n    WHERE e/ehr_id/value = 'e6fad8ba-fb4f-46a2-bf82-66edb43f142f'\n", false);
        List<AslQuery> queries = aslQuery.getChildren().stream().map(Pair::getLeft).toList();
        Assertions.assertThat(queries).hasSize(4);
        Assertions.assertThat((Object)queries.get(0)).isInstanceOf(AslStructureQuery.class);
        Assertions.assertThat((Object)queries.get(1)).isInstanceOf(AslStructureQuery.class);
        Assertions.assertThat((Object)queries.get(2)).isInstanceOf(AslEncapsulatingQuery.class);
        Assertions.assertThat((Object)queries.get(3)).isInstanceOf(AslEncapsulatingQuery.class);
        AslField contentField1 = (AslField)aslQuery.getSelect().get(0);
        AslField contentField2 = (AslField)aslQuery.getSelect().get(1);
        AslField contentField3 = (AslField)aslQuery.getSelect().get(2);
        Assertions.assertThat((Object)contentField1).isInstanceOf(AslSubqueryField.class);
        Assertions.assertThat((List)((AslSubqueryField)contentField1).getFilterConditions()).isEmpty();
        Assertions.assertThat((Object)contentField2).isInstanceOf(AslSubqueryField.class);
        Assertions.assertThat((List)((AslSubqueryField)contentField2).getFilterConditions()).hasSize(1);
        Assertions.assertThat((Object)contentField3).isInstanceOf(AslSubqueryField.class);
        Assertions.assertThat((List)((AslSubqueryField)contentField3).getFilterConditions()).hasSize(2);
        Assertions.assertThat((Object)((AslField)aslQuery.getSelect().getLast())).isInstanceOf(AslRmPathField.class);
    }

    @Test
    void clusterDataSingleSelection() {
        AslRootQuery aslQuery = this.buildSqlQuery("SELECT\n    cluster/items[at0001]/value/data\nFROM COMPOSITION CONTAINS CLUSTER cluster[openEHR-EHR-CLUSTER.media_file.v1]\n", false);
        List<AslQuery> queries = aslQuery.getChildren().stream().map(Pair::getLeft).toList();
        Assertions.assertThat(queries).hasSize(3);
        Assertions.assertThat((Object)queries.get(0)).isInstanceOf(AslStructureQuery.class);
        Assertions.assertThat((Object)queries.get(1)).isInstanceOf(AslStructureQuery.class);
        Assertions.assertThat((Object)queries.get(2)).isInstanceOf(AslEncapsulatingQuery.class);
        Assertions.assertThat((Object)((AslField)aslQuery.getSelect().getFirst())).isInstanceOf(AslRmPathField.class);
    }

    @Test
    void testPathNodeSkipping() {
        AslRootQuery aslQuery = this.buildSqlQuery("SELECT\n    o/data[at0001]/events[at0002]/data[at0003]/items[at0004]/items[openEHR-EHR-CLUSTER.cl.v0]/items[at0005]/items[at0006]/value,\n    o/data[at0001]/events[at0002]/data[at0003]/items[at0004]/items[openEHR-EHR-CLUSTER.cl.v0]/items[at0005]/items[at0009]/value,\n    o/data[at0001]/events[at0002]/state[at0006]/items[at0008]/value,\n    o/data[at0001]/events[at0002]/state[at0006]/items[at0007]/value\nFROM OBSERVATION o[openEHR-EHR-OBSERVATION.ooo.v1]\n", true);
        String expected = "AslRootQuery\n  SELECT\n    p_eq_0.p_items__2_data -> value\n    p_eq_0.p_items__3_data -> value\n    p_eq_0.p_items__4_data -> value\n    p_eq_0.p_items__5_data -> value\n  FROM\n    sOB_o_0: StructureQuery\n      SELECT\n        sOB_o_0.sOB_o_0_vo_id\n        sOB_o_0.sOB_o_0_num\n      WHERE\n        sOB_o_0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=OB, concept=.ooo.v1]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sOB_o_0.sOB_o_0_rm_entity IN [OB]\n    p_eq_0: EncapsulatingQuery\n      SELECT\n        p_events__0.p_events__0_vo_id\n        p_events__0.p_events__0_num\n        p_events__0.p_events__0_num_cap\n        p_events__0.p_events__0_citem_num\n        p_eq_1.p_items__0_vo_id\n        p_eq_1.p_items__0_num\n        p_eq_1.p_items__0_citem_num\n        p_eq_1.p_items__1_vo_id\n        p_eq_1.p_items__1_num\n        p_eq_1.p_items__1_parent_num\n        p_eq_1.p_items__2_vo_id\n        p_eq_1.p_items__2_parent_num\n        p_eq_1.p_items__2_citem_num\n        p_eq_1.p_items__2_data\n        p_eq_1.p_items__3_vo_id\n        p_eq_1.p_items__3_parent_num\n        p_eq_1.p_items__3_citem_num\n        p_eq_1.p_items__3_data\n        p_eq_2.p_items__4_vo_id\n        p_eq_2.p_items__4_num\n        p_eq_2.p_items__4_parent_num\n        p_eq_2.p_items__4_citem_num\n        p_eq_2.p_items__4_data\n        p_eq_3.p_items__5_vo_id\n        p_eq_3.p_items__5_num\n        p_eq_3.p_items__5_parent_num\n        p_eq_3.p_items__5_citem_num\n        p_eq_3.p_items__5_data\n      WHERE\n        OR\n          NOT_NULL p_items__0.p_items__0_vo_id\n          NOT_NULL p_items__4.p_items__4_vo_id\n          NOT_NULL p_items__5.p_items__5_vo_id\n        FROM\n          p_events__0: StructureQuery\n              SELECT\n                p_events__0.p_events__0_vo_id\n                p_events__0.p_events__0_num\n                p_events__0.p_events__0_num_cap\n                p_events__0.p_events__0_citem_num\n              WHERE\n                p_events__0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0002]]\n              FROM COMPOSITION\n              STRUCTURE CONDITIONS\n                p_events__0.p_events__0_entity_attribute EQ [e]\n\n          p_eq_1: EncapsulatingQuery\n              SELECT\n                p_items__0.p_items__0_vo_id\n                p_items__0.p_items__0_num\n                p_items__0.p_items__0_citem_num\n                p_items__1.p_items__1_vo_id\n                p_items__1.p_items__1_num\n                p_items__1.p_items__1_parent_num\n                p_items__2.p_items__2_vo_id\n                p_items__2.p_items__2_parent_num\n                p_items__2.p_items__2_citem_num\n                p_items__2.p_items__2_data\n                p_items__3.p_items__3_vo_id\n                p_items__3.p_items__3_parent_num\n                p_items__3.p_items__3_citem_num\n                p_items__3.p_items__3_data\n                FROM\n                  p_items__0: StructureQuery\n                      SELECT\n                        p_items__0.p_items__0_vo_id\n                        p_items__0.p_items__0_num\n                        p_items__0.p_items__0_citem_num\n                      WHERE\n                        p_items__0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0004]]\n                      FROM COMPOSITION\n                      STRUCTURE CONDITIONS\n                        p_items__0.p_items__0_entity_attribute EQ [i]\n\n                  p_items__1: StructureQuery\n                      SELECT\n                        p_items__1.p_items__1_vo_id\n                        p_items__1.p_items__1_num\n                        p_items__1.p_items__1_parent_num\n                      WHERE\n                        p_items__1.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=CL, concept=.cl.v0]]\n                      FROM COMPOSITION\n                      STRUCTURE CONDITIONS\n                        p_items__1.p_items__1_entity_attribute EQ [i]\n                      JOIN p_items__0 -> p_items__1\n                        on\n                          DelegatingJoinCondition ->\n                              p_items__0.p_items__0_vo_id EQ p_items__1.p_items__1_vo_id\n\n                          DelegatingJoinCondition ->\n                              p_items__0.p_items__0_num EQ p_items__1.p_items__1_parent_num\n\n\n                  p_items__2: StructureQuery\n                      SELECT\n                        p_items__2.p_items__2_vo_id\n                        p_items__2.p_items__2_parent_num\n                        p_items__2.p_items__2_citem_num\n                        p_items__2.p_items__2_data\n                      WHERE\n                        p_items__2.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0006]]\n                      FROM COMPOSITION\n                      STRUCTURE CONDITIONS\n                        p_items__2.p_items__2_entity_attribute EQ [i]\n                      JOIN p_items__1 -> p_items__2\n                        on\n                          DelegatingJoinCondition ->\n                              p_items__1.p_items__1_vo_id EQ p_items__2.p_items__2_vo_id\n\n                          DelegatingJoinCondition ->\n                              p_items__1.p_items__1_num EQ p_items__2.p_items__2_citem_num\n\n\n                  p_items__3: StructureQuery\n                      SELECT\n                        p_items__3.p_items__3_vo_id\n                        p_items__3.p_items__3_parent_num\n                        p_items__3.p_items__3_citem_num\n                        p_items__3.p_items__3_data\n                      WHERE\n                        p_items__3.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0009]]\n                      FROM COMPOSITION\n                      STRUCTURE CONDITIONS\n                        p_items__3.p_items__3_entity_attribute EQ [i]\n                      JOIN p_items__1 -> p_items__3\n                        on\n                          DelegatingJoinCondition ->\n                              p_items__1.p_items__1_vo_id EQ p_items__3.p_items__3_vo_id\n\n                          DelegatingJoinCondition ->\n                              p_items__1.p_items__1_num EQ p_items__3.p_items__3_citem_num\n\n                          DelegatingJoinCondition ->\n                              COALESCE(p_items__3.p_items__3_parent_num EQ p_items__2.p_items__2_parent_num, true)\n\n\n              LEFT_OUTER_JOIN p_events__0 -> p_eq_1\n                on\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_vo_id EQ p_items__0.p_items__0_vo_id\n\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_citem_num EQ p_items__0.p_items__0_citem_num\n\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_num LT p_items__0.p_items__0_num\n\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_num_cap GT_EQ p_items__0.p_items__0_num\n\n\n          p_eq_2: EncapsulatingQuery\n              SELECT\n                p_items__4.p_items__4_vo_id\n                p_items__4.p_items__4_num\n                p_items__4.p_items__4_parent_num\n                p_items__4.p_items__4_citem_num\n                p_items__4.p_items__4_data\n                FROM\n                  p_items__4: StructureQuery\n                      SELECT\n                        p_items__4.p_items__4_vo_id\n                        p_items__4.p_items__4_num\n                        p_items__4.p_items__4_parent_num\n                        p_items__4.p_items__4_citem_num\n                        p_items__4.p_items__4_data\n                      WHERE\n                        p_items__4.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0008]]\n                      FROM COMPOSITION\n                      STRUCTURE CONDITIONS\n                        p_items__4.p_items__4_entity_attribute EQ [i]\n\n              LEFT_OUTER_JOIN p_events__0 -> p_eq_2\n                on\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_vo_id EQ p_items__4.p_items__4_vo_id\n\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_citem_num EQ p_items__4.p_items__4_citem_num\n\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_num LT p_items__4.p_items__4_num\n\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_num_cap GT_EQ p_items__4.p_items__4_num\n\n\n          p_eq_3: EncapsulatingQuery\n              SELECT\n                p_items__5.p_items__5_vo_id\n                p_items__5.p_items__5_num\n                p_items__5.p_items__5_parent_num\n                p_items__5.p_items__5_citem_num\n                p_items__5.p_items__5_data\n                FROM\n                  p_items__5: StructureQuery\n                      SELECT\n                        p_items__5.p_items__5_vo_id\n                        p_items__5.p_items__5_num\n                        p_items__5.p_items__5_parent_num\n                        p_items__5.p_items__5_citem_num\n                        p_items__5.p_items__5_data\n                      WHERE\n                        p_items__5.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0007]]\n                      FROM COMPOSITION\n                      STRUCTURE CONDITIONS\n                        p_items__5.p_items__5_entity_attribute EQ [i]\n\n              LEFT_OUTER_JOIN p_events__0 -> p_eq_3\n                on\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_vo_id EQ p_items__5.p_items__5_vo_id\n\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_citem_num EQ p_items__5.p_items__5_citem_num\n\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_num LT p_items__5.p_items__5_num\n\n                  DelegatingJoinCondition ->\n                      p_events__0.p_events__0_num_cap GT_EQ p_items__5.p_items__5_num\n\n                  DelegatingJoinCondition ->\n                      COALESCE(p_items__5.p_items__5_parent_num EQ p_items__4.p_items__4_parent_num, true)\n\n      LEFT_OUTER_JOIN sOB_o_0 -> p_eq_0\n        on\n          DelegatingJoinCondition ->\n              sOB_o_0.sOB_o_0_vo_id EQ p_events__0.p_events__0_vo_id\n\n          DelegatingJoinCondition ->\n              sOB_o_0.sOB_o_0_num EQ p_events__0.p_events__0_citem_num\n";
        Assertions.assertThat((String)AslGraph.createAslGraph(aslQuery)).isEqualToIgnoringNewLines((CharSequence)expected);
    }

    @Test
    void testSimpleNodePredicateContainment() {
        AslRootQuery aslQuery = this.buildSqlQuery("SELECT\n    e/ehr_id/value\nFROM EHR e CONTAINS OBSERVATION [openEHR-EHR-OBSERVATION.o1o1o1.v1] CONTAINS CLUSTER[at0001] CONTAINS ELEMENT[at0002]\n", false);
        String expected = "AslRootQuery\n  SELECT\n    sEHR_e_0.sEHR_e_0_id /* ehr_id/value */\n  FROM\n    sEHR_e_0: StructureQuery\n      SELECT\n        sEHR_e_0.sEHR_e_0_id /* ehr_id/value */\n      FROM EHR\n    sOB_0: StructureQuery\n      SELECT\n        sOB_0.sOB_0_vo_id\n        sOB_0.sOB_0_num\n        sOB_0.sOB_0_ehr_id\n      WHERE\n        sOB_0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=OB, concept=.o1o1o1.v1]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sOB_0.sOB_0_rm_entity IN [OB]\n      JOIN sEHR_e_0 -> sOB_0\n        on\n          DelegatingJoinCondition ->\n              sEHR_e_0.sEHR_e_0_id /* ehr_id/value */ EQ sOB_0.sOB_0_ehr_id\n\n    sCL_0: StructureQuery\n      SELECT\n        sCL_0.sCL_0_vo_id\n        sCL_0.sCL_0_num\n        sCL_0.sCL_0_num_cap\n        sCL_0.sCL_0_citem_num\n      WHERE\n        sCL_0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0001]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sCL_0.sCL_0_rm_entity IN [CL]\n      JOIN sOB_0 -> sCL_0\n        on\n          DelegatingJoinCondition ->\n              sOB_0.sOB_0_vo_id EQ sCL_0.sCL_0_vo_id\n\n          DelegatingJoinCondition ->\n              sOB_0.sOB_0_num EQ sCL_0.sCL_0_citem_num\n\n    sE_0: StructureQuery\n      SELECT\n        sE_0.sE_0_vo_id\n        sE_0.sE_0_num\n        sE_0.sE_0_citem_num\n      WHERE\n        sE_0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0002]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sE_0.sE_0_rm_entity IN [E]\n      JOIN sCL_0 -> sE_0\n        on\n          DelegatingJoinCondition ->\n              sCL_0.sCL_0_vo_id EQ sE_0.sE_0_vo_id\n\n          DelegatingJoinCondition ->\n              sCL_0.sCL_0_citem_num EQ sE_0.sE_0_citem_num\n\n          DelegatingJoinCondition ->\n              sCL_0.sCL_0_num LT sE_0.sE_0_num\n\n          DelegatingJoinCondition ->\n              sCL_0.sCL_0_num_cap GT_EQ sE_0.sE_0_num\n";
        Assertions.assertThat((String)AslGraph.createAslGraph(aslQuery)).isEqualToIgnoringNewLines((CharSequence)expected);
    }

    @Test
    void testNodePredicateContainment() {
        AslRootQuery aslQuery = this.buildSqlQuery("SELECT\n    e/ehr_id/value\nFROM EHR e CONTAINS\n(\n    (OBSERVATION [openEHR-EHR-OBSERVATION.o1o1o1.v1] CONTAINS CLUSTER[at0001] CONTAINS ELEMENT[at0002])\n    AND\n    (\n        OBSERVATION [openEHR-EHR-OBSERVATION.o2o2o2.v1] CONTAINS\n        (\n            (CLUSTER[at0001] CONTAINS ELEMENT[at0002])\n            OR(\n                ELEMENT[at0003]\n                AND\n                (CLUSTER[at0001] CONTAINS ELEMENT[at0002])\n                AND\n                (CLUSTER[openEHR-EHR-CLUSTER.cl.v1] CONTAINS ELEMENT[at0002])\n            )\n        )\n    )\n)\n", false);
        String expected = "AslRootQuery\n  SELECT\n    sEHR_e_0.sEHR_e_0_id /* ehr_id/value */\n  FROM\n    sEHR_e_0: StructureQuery\n      SELECT\n        sEHR_e_0.sEHR_e_0_id /* ehr_id/value */\n      FROM EHR\n    sOB_0: StructureQuery\n      SELECT\n        sOB_0.sOB_0_vo_id\n        sOB_0.sOB_0_num\n        sOB_0.sOB_0_ehr_id\n      WHERE\n        sOB_0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=OB, concept=.o1o1o1.v1]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sOB_0.sOB_0_rm_entity IN [OB]\n      JOIN sEHR_e_0 -> sOB_0\n        on\n          DelegatingJoinCondition ->\n              sEHR_e_0.sEHR_e_0_id /* ehr_id/value */ EQ sOB_0.sOB_0_ehr_id\n\n    sCL_0: StructureQuery\n      SELECT\n        sCL_0.sCL_0_vo_id\n        sCL_0.sCL_0_num\n        sCL_0.sCL_0_num_cap\n        sCL_0.sCL_0_citem_num\n      WHERE\n        sCL_0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0001]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sCL_0.sCL_0_rm_entity IN [CL]\n      JOIN sOB_0 -> sCL_0\n        on\n          DelegatingJoinCondition ->\n              sOB_0.sOB_0_vo_id EQ sCL_0.sCL_0_vo_id\n\n          DelegatingJoinCondition ->\n              sOB_0.sOB_0_num EQ sCL_0.sCL_0_citem_num\n\n    sE_0: StructureQuery\n      SELECT\n        sE_0.sE_0_vo_id\n        sE_0.sE_0_num\n        sE_0.sE_0_citem_num\n      WHERE\n        sE_0.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0002]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sE_0.sE_0_rm_entity IN [E]\n      JOIN sCL_0 -> sE_0\n        on\n          DelegatingJoinCondition ->\n              sCL_0.sCL_0_vo_id EQ sE_0.sE_0_vo_id\n\n          DelegatingJoinCondition ->\n              sCL_0.sCL_0_citem_num EQ sE_0.sE_0_citem_num\n\n          DelegatingJoinCondition ->\n              sCL_0.sCL_0_num LT sE_0.sE_0_num\n\n          DelegatingJoinCondition ->\n              sCL_0.sCL_0_num_cap GT_EQ sE_0.sE_0_num\n\n    sOB_1: StructureQuery\n      SELECT\n        sOB_1.sOB_1_vo_id\n        sOB_1.sOB_1_num\n        sOB_1.sOB_1_num_cap\n        sOB_1.sOB_1_ehr_id\n      WHERE\n        sOB_1.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=OB, concept=.o2o2o2.v1]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sOB_1.sOB_1_rm_entity IN [OB]\n      JOIN sEHR_e_0 -> sOB_1\n        on\n          DelegatingJoinCondition ->\n              sEHR_e_0.sEHR_e_0_id /* ehr_id/value */ EQ sOB_1.sOB_1_ehr_id\n\n    or_sq_0: EncapsulatingQuery\n      SELECT\n        sCL_1.sCL_1_vo_id\n        sCL_1.sCL_1_num\n        sCL_1.sCL_1_num_cap\n        sCL_1.sCL_1_citem_num\n        sE_1.sE_1_vo_id\n        sE_1.sE_1_num\n        sE_1.sE_1_citem_num\n        FROM\n          sCL_1: StructureQuery\n              SELECT\n                sCL_1.sCL_1_vo_id\n                sCL_1.sCL_1_num\n                sCL_1.sCL_1_num_cap\n                sCL_1.sCL_1_citem_num\n              WHERE\n                sCL_1.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0001]]\n              FROM COMPOSITION\n              STRUCTURE CONDITIONS\n                sCL_1.sCL_1_rm_entity IN [CL]\n\n          sE_1: StructureQuery\n              SELECT\n                sE_1.sE_1_vo_id\n                sE_1.sE_1_num\n                sE_1.sE_1_citem_num\n              WHERE\n                sE_1.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0002]]\n              FROM COMPOSITION\n              STRUCTURE CONDITIONS\n                sE_1.sE_1_rm_entity IN [E]\n              JOIN sCL_1 -> sE_1\n                on\n                  DelegatingJoinCondition ->\n                      sCL_1.sCL_1_vo_id EQ sE_1.sE_1_vo_id\n\n                  DelegatingJoinCondition ->\n                      sCL_1.sCL_1_citem_num EQ sE_1.sE_1_citem_num\n\n                  DelegatingJoinCondition ->\n                      sCL_1.sCL_1_num LT sE_1.sE_1_num\n\n                  DelegatingJoinCondition ->\n                      sCL_1.sCL_1_num_cap GT_EQ sE_1.sE_1_num\n\n\n      LEFT_OUTER_JOIN sOB_1 -> or_sq_0\n        on\n          DelegatingJoinCondition ->\n              sOB_1.sOB_1_vo_id EQ sCL_1.sCL_1_vo_id\n\n          DelegatingJoinCondition ->\n              sOB_1.sOB_1_num EQ sCL_1.sCL_1_citem_num\n\n    sE_2: StructureQuery\n      SELECT\n        sE_2.sE_2_vo_id\n        sE_2.sE_2_citem_num\n      WHERE\n        sE_2.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0003]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sE_2.sE_2_rm_entity IN [E]\n      LEFT_OUTER_JOIN sOB_1 -> sE_2\n        on\n          DelegatingJoinCondition ->\n              sOB_1.sOB_1_vo_id EQ sE_2.sE_2_vo_id\n\n          DelegatingJoinCondition ->\n              sOB_1.sOB_1_num EQ sE_2.sE_2_citem_num\n\n    sCL_2: StructureQuery\n      SELECT\n        sCL_2.sCL_2_vo_id\n        sCL_2.sCL_2_num\n        sCL_2.sCL_2_num_cap\n        sCL_2.sCL_2_citem_num\n      WHERE\n        sCL_2.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0001]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sCL_2.sCL_2_rm_entity IN [CL]\n      LEFT_OUTER_JOIN sOB_1 -> sCL_2\n        on\n          DelegatingJoinCondition ->\n              sOB_1.sOB_1_vo_id EQ sCL_2.sCL_2_vo_id\n\n          DelegatingJoinCondition ->\n              sOB_1.sOB_1_num EQ sCL_2.sCL_2_citem_num\n\n    sE_3: StructureQuery\n      SELECT\n        sE_3.sE_3_vo_id\n        sE_3.sE_3_num\n        sE_3.sE_3_citem_num\n      WHERE\n        sE_3.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0002]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sE_3.sE_3_rm_entity IN [E]\n      LEFT_OUTER_JOIN sCL_2 -> sE_3\n        on\n          DelegatingJoinCondition ->\n              sCL_2.sCL_2_vo_id EQ sE_3.sE_3_vo_id\n\n          DelegatingJoinCondition ->\n              sCL_2.sCL_2_citem_num EQ sE_3.sE_3_citem_num\n\n          DelegatingJoinCondition ->\n              sCL_2.sCL_2_num LT sE_3.sE_3_num\n\n          DelegatingJoinCondition ->\n              sCL_2.sCL_2_num_cap GT_EQ sE_3.sE_3_num\n\n    sCL_3: StructureQuery\n      SELECT\n        sCL_3.sCL_3_vo_id\n        sCL_3.sCL_3_num\n      WHERE\n        sCL_3.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=CL, concept=.cl.v1]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sCL_3.sCL_3_rm_entity IN [CL]\n      LEFT_OUTER_JOIN sOB_1 -> sCL_3\n        on\n          DelegatingJoinCondition ->\n              sOB_1.sOB_1_vo_id EQ sCL_3.sCL_3_vo_id\n\n          DelegatingJoinCondition ->\n              sOB_1.sOB_1_num LT sCL_3.sCL_3_num\n\n          DelegatingJoinCondition ->\n              sOB_1.sOB_1_num_cap GT_EQ sCL_3.sCL_3_num\n\n    sE_4: StructureQuery\n      SELECT\n        sE_4.sE_4_vo_id\n        sE_4.sE_4_citem_num\n      WHERE\n        sE_4.?? -- COMPLEX ARCHETYPE_NODE_ID archetype_node_id EQ [AslRmTypeAndConcept[aliasedRmType=null, concept=at0002]]\n      FROM COMPOSITION\n      STRUCTURE CONDITIONS\n        sE_4.sE_4_rm_entity IN [E]\n      LEFT_OUTER_JOIN sCL_3 -> sE_4\n        on\n          DelegatingJoinCondition ->\n              sCL_3.sCL_3_vo_id EQ sE_4.sE_4_vo_id\n\n          DelegatingJoinCondition ->\n              sCL_3.sCL_3_num EQ sE_4.sE_4_citem_num\n\n  WHERE\n    OR\n      NOT_NULL sCL_1.sCL_1_vo_id\n      AND\n        NOT_NULL sE_2.sE_2_vo_id\n        AND\n          NOT_NULL sCL_2.sCL_2_vo_id\n          NOT_NULL sE_3.sE_3_vo_id\n        AND\n          NOT_NULL sCL_3.sCL_3_vo_id\n          NOT_NULL sE_4.sE_4_vo_id\n";
        Assertions.assertThat((String)AslGraph.createAslGraph(aslQuery)).isEqualToIgnoringNewLines((CharSequence)expected);
    }

    private AslRootQuery buildSqlQuery(String query, boolean pathSkipping) {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)query);
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery, (boolean)pathSkipping);
        AqlSqlLayer aqlSqlLayer = new AqlSqlLayer(this.mockKnowledgeCacheService, () -> "node", (AqlQueryContext)new TestAqlQueryContext());
        AslRootQuery aslRootQuery = aqlSqlLayer.buildAslRootQuery(queryWrapper);
        new AslCleanupPostProcessor().afterBuildAsl(aslRootQuery, aqlQuery, queryWrapper, null);
        return aslRootQuery;
    }
}

