/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.CompData;
import org.ehrbase.jooq.pg.tables.Ehr;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.ContainsWrapper;
import org.ehrbase.openehr.dbformat.AncestorStructureRmType;
import org.ehrbase.openehr.dbformat.StructureRmType;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPathUtil;
import org.jooq.Field;

public enum AslExtractedColumn {
    NAME_VALUE(AqlObjectPathUtil.NAME_VALUE, (Field<?>)CompData.COMP_DATA.ENTITY_NAME, String.class, false, (String[])Stream.concat(Arrays.stream(StructureRmType.values()), Arrays.stream(AncestorStructureRmType.values())).map(Enum::name).toArray(String[]::new)),
    VO_ID(AqlObjectPath.parse((String)"uid/value"), List.of(CompData.COMP_DATA.VO_ID, Tables.COMP_VERSION.SYS_VERSION), String.class, true, StructureRmType.COMPOSITION.name(), StructureRmType.EHR_STATUS.name(), "ORIGINAL_VERSION"),
    ROOT_CONCEPT(AqlObjectPathUtil.ARCHETYPE_NODE_ID, (Field<?>)Tables.COMP_VERSION.ROOT_CONCEPT, String.class, true, StructureRmType.COMPOSITION.name()),
    ARCHETYPE_NODE_ID(AqlObjectPathUtil.ARCHETYPE_NODE_ID, List.of(CompData.COMP_DATA.RM_ENTITY, CompData.COMP_DATA.ENTITY_CONCEPT), String.class, false, (String[])Stream.concat(Arrays.stream(StructureRmType.values()), Arrays.stream(AncestorStructureRmType.values())).filter(v -> !v.equals(StructureRmType.COMPOSITION)).map(Enum::name).toArray(String[]::new)),
    TEMPLATE_ID(AqlObjectPath.parse((String)"archetype_details/template_id/value"), (Field<?>)Tables.COMP_VERSION.TEMPLATE_ID, String.class, true, StructureRmType.COMPOSITION.name()),
    EHR_ID(AqlObjectPath.parse((String)"ehr_id/value"), (Field<?>)Ehr.EHR_.ID, UUID.class, false, "EHR"),
    EHR_SYSTEM_ID(AqlObjectPath.parse((String)"system_id/value"), Collections.emptyList(), String.class, false, "EHR"),
    EHR_SYSTEM_ID_DV(AqlObjectPath.parse((String)"system_id"), Collections.emptyList(), String.class, false, "EHR"),
    EHR_TIME_CREATED_DV(AqlObjectPath.parse((String)"time_created"), (Field<?>)Tables.EHR_.CREATION_DATE, String.class, false, "EHR"),
    EHR_TIME_CREATED(AqlObjectPath.parse((String)"time_created/value"), (Field<?>)Tables.EHR_.CREATION_DATE, String.class, false, "EHR"),
    OV_CONTRIBUTION_ID(AqlObjectPath.parse((String)"contribution/id/value"), (Field<?>)Tables.COMP_VERSION.CONTRIBUTION_ID, String.class, true, "ORIGINAL_VERSION"),
    OV_TIME_COMMITTED_DV(AqlObjectPath.parse((String)"commit_audit/time_committed"), (Field<?>)Tables.COMP_VERSION.SYS_PERIOD_LOWER, String.class, true, "ORIGINAL_VERSION"),
    OV_TIME_COMMITTED(AqlObjectPath.parse((String)"commit_audit/time_committed/value"), (Field<?>)Tables.COMP_VERSION.SYS_PERIOD_LOWER, String.class, true, "ORIGINAL_VERSION"),
    AD_SYSTEM_ID(AqlObjectPath.parse((String)"system_id"), Collections.emptyList(), String.class, true, "AUDIT_DETAILS"),
    AD_DESCRIPTION_DV(AqlObjectPath.parse((String)"description"), (Field<?>)Tables.AUDIT_DETAILS.DESCRIPTION, String.class, true, "AUDIT_DETAILS"),
    AD_DESCRIPTION_VALUE(AqlObjectPath.parse((String)"description/value"), (Field<?>)Tables.AUDIT_DETAILS.DESCRIPTION, String.class, true, "AUDIT_DETAILS"),
    AD_CHANGE_TYPE_DV(AqlObjectPath.parse((String)"change_type"), (Field<?>)Tables.AUDIT_DETAILS.CHANGE_TYPE, String.class, true, "AUDIT_DETAILS"),
    AD_CHANGE_TYPE_VALUE(AqlObjectPath.parse((String)"change_type/value"), (Field<?>)Tables.AUDIT_DETAILS.CHANGE_TYPE, String.class, true, "AUDIT_DETAILS"),
    AD_CHANGE_TYPE_CODE_STRING(AqlObjectPath.parse((String)"change_type/defining_code/code_string"), (Field<?>)Tables.AUDIT_DETAILS.CHANGE_TYPE, String.class, true, "AUDIT_DETAILS"),
    AD_CHANGE_TYPE_PREFERRED_TERM(AqlObjectPath.parse((String)"change_type/defining_code/preferred_term"), (Field<?>)Tables.AUDIT_DETAILS.CHANGE_TYPE, String.class, true, "AUDIT_DETAILS"),
    AD_CHANGE_TYPE_TERMINOLOGY_ID_VALUE(AqlObjectPath.parse((String)"change_type/defining_code/terminology_id/value"), Collections.emptyList(), String.class, true, "AUDIT_DETAILS");

    private final AqlObjectPath path;
    private final List<String> columns;
    private final Class<?> columnType;
    private final Set<String> allowedRmTypes;
    private final boolean requiresVersionTable;

    private <T> AslExtractedColumn(AqlObjectPath path, Field<?> column, Class<T> columnType, boolean requiresVersionTable, String ... allowedRmTypes) {
        this(path, List.of(column), columnType, requiresVersionTable, allowedRmTypes);
    }

    private <T> AslExtractedColumn(AqlObjectPath path, List<Field> columns, Class<T> columnType, boolean requiresVersionTable, String ... allowedRmTypes) {
        this.path = Objects.requireNonNull(path).frozen();
        this.columnType = Objects.requireNonNull(columnType);
        this.columns = Optional.ofNullable(columns).map(l -> l.stream().map(Field::getName).toList()).orElse(null);
        this.requiresVersionTable = requiresVersionTable;
        this.allowedRmTypes = Set.of(allowedRmTypes);
    }

    public AqlObjectPath getPath() {
        return this.path;
    }

    public Set<String> getAllowedRmTypes() {
        return this.allowedRmTypes;
    }

    public boolean requiresVersionTable() {
        return this.requiresVersionTable;
    }

    public static Optional<AslExtractedColumn> find(ContainsWrapper contains, AqlObjectPath toMatch) {
        return AslExtractedColumn.find(contains.getRmType(), toMatch);
    }

    public static Optional<AslExtractedColumn> find(String containmentType, AqlObjectPath toMatch) {
        return Arrays.stream(AslExtractedColumn.values()).filter(ep -> ep.matches(containmentType, toMatch)).findFirst();
    }

    public static Optional<AslExtractedColumn> find(String containmentType, AqlObjectPath toMatch, int skip) {
        List pathNodes = Optional.ofNullable(toMatch).map(AqlObjectPath::getPathNodes).stream().flatMap(Collection::stream).skip(skip).toList();
        return AslExtractedColumn.find(containmentType, new AqlObjectPath(pathNodes));
    }

    public boolean matches(String containmentType, AqlObjectPath toMatch) {
        return this.allowedRmTypes.contains(containmentType) && Objects.equals(toMatch, this.path);
    }

    public Class<?> getColumnType() {
        return this.columnType;
    }

    public List<String> getColumns() {
        return this.columns;
    }
}

