/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl.model;

import org.ehrbase.openehr.dbformat.RmTypeAlias;

public record AslRmTypeAndConcept(String aliasedRmType, String concept) {
    public static final String ARCHETYPE_PREFIX = "openEHR-EHR-";

    public static AslRmTypeAndConcept fromArchetypeNodeId(String archetypeNodeId) {
        if (archetypeNodeId == null) {
            return null;
        }
        if (archetypeNodeId.startsWith(ARCHETYPE_PREFIX)) {
            int pos = archetypeNodeId.indexOf(46, ARCHETYPE_PREFIX.length());
            if (pos < 0) {
                throw new IllegalArgumentException("Archetype id is not valid: " + archetypeNodeId);
            }
            String alias = (String)RmTypeAlias.optionalAlias((String)archetypeNodeId.substring(ARCHETYPE_PREFIX.length(), pos)).orElseThrow(() -> new IllegalArgumentException("Archetype id for unsupported/unknown RM type: " + archetypeNodeId));
            String concept = archetypeNodeId.substring(pos);
            return new AslRmTypeAndConcept(alias, concept);
        }
        if (archetypeNodeId.startsWith("at") || archetypeNodeId.startsWith("id")) {
            return new AslRmTypeAndConcept(null, archetypeNodeId);
        }
        throw new IllegalArgumentException("Invalid archetype_node_id: %s".formatted(archetypeNodeId));
    }

    public static String toEntityConcept(String archetypeNodeId) {
        if (archetypeNodeId == null) {
            return null;
        }
        return AslRmTypeAndConcept.fromArchetypeNodeId((String)archetypeNodeId).concept;
    }
}

