/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.featurecheck;

import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.dto.AqlQueryRequest;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.openehr.aqlengine.AqlConfigurationProperties;
import org.ehrbase.openehr.aqlengine.AqlQueryParsingPostProcessor;
import org.ehrbase.openehr.aqlengine.featurecheck.FeatureCheck;
import org.ehrbase.openehr.aqlengine.featurecheck.FromCheck;
import org.ehrbase.openehr.aqlengine.featurecheck.OrderByCheck;
import org.ehrbase.openehr.aqlengine.featurecheck.SelectCheck;
import org.ehrbase.openehr.aqlengine.featurecheck.WhereCheck;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.springframework.stereotype.Component;

@Component
public final class AqlQueryFeatureCheck
implements AqlQueryParsingPostProcessor {
    private final FeatureCheck[] featureChecks;

    public AqlQueryFeatureCheck(SystemService systemService, AqlConfigurationProperties aqlConfigurationProperties, AqlQueryContext aqlQueryContext) {
        this.featureChecks = new FeatureCheck[]{new FromCheck(systemService, aqlConfigurationProperties, aqlQueryContext), new SelectCheck(systemService), new WhereCheck(systemService), new OrderByCheck(systemService)};
    }

    void ensureQuerySupported(AqlQuery aqlQuery) {
        for (FeatureCheck featureCheck : this.featureChecks) {
            featureCheck.ensureSupported(aqlQuery);
        }
    }

    public int getOrder() {
        return 0;
    }

    @Override
    public void afterParseAql(AqlQuery aqlQuery, AqlQueryRequest request, AqlQueryContext ctx) {
        this.ensureQuerySupported(aqlQuery);
    }
}

