/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.querywrapper.select.SelectWrapper;
import org.ehrbase.openehr.aqlengine.repository.PreparedQuery;
import org.ehrbase.openehr.aqlengine.sql.AqlSqlQueryBuilder;
import org.ehrbase.openehr.aqlengine.sql.postprocessor.AqlSqlResultPostprocessor;
import org.ehrbase.openehr.aqlengine.sql.postprocessor.DefaultResultPostprocessor;
import org.ehrbase.openehr.aqlengine.sql.postprocessor.ExtractedColumnResultPostprocessor;
import org.ehrbase.openehr.sdk.aql.dto.operand.AggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.jooq.Record;
import org.jooq.SelectQuery;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class AqlQueryRepository {
    private static final AqlSqlResultPostprocessor NOOP_POSTPROCESSOR = v -> v;
    private final SystemService systemService;
    private final KnowledgeCacheService knowledgeCache;
    private final AqlSqlQueryBuilder queryBuilder;

    public AqlQueryRepository(SystemService systemService, KnowledgeCacheService knowledgeCache, AqlSqlQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        this.systemService = systemService;
        this.knowledgeCache = knowledgeCache;
    }

    public PreparedQuery prepareQuery(AslRootQuery aslQuery, List<SelectWrapper> selects) {
        SelectQuery<Record> selectQuery = this.queryBuilder.buildSqlQuery(aslQuery);
        AqlSqlResultPostprocessor[] postProcessors = selects.isEmpty() ? new AqlSqlResultPostprocessor[]{NOOP_POSTPROCESSOR} : (AqlSqlResultPostprocessor[])selects.stream().map(this::getPostProcessor).toArray(AqlSqlResultPostprocessor[]::new);
        return new PreparedQuery(selectQuery, postProcessors);
    }

    @Transactional(readOnly=true)
    public List<List<Object>> executeQuery(PreparedQuery preparedQuery) {
        try (Stream stream = preparedQuery.selectQuery.stream();){
            List<List<Object>> list = stream.map(r -> AqlQueryRepository.postProcessDbRecord(r, preparedQuery.postProcessors)).toList();
            return list;
        }
    }

    @Transactional(readOnly=true)
    public String explainQuery(boolean analyze, PreparedQuery preparedQuery) {
        return this.queryBuilder.explain(analyze, preparedQuery.selectQuery).formatJSON();
    }

    private AqlSqlResultPostprocessor getPostProcessor(SelectWrapper select) {
        if (select.type() == SelectWrapper.SelectType.AGGREGATE_FUNCTION && EnumSet.of(AggregateFunction.AggregateFunctionName.COUNT, AggregateFunction.AggregateFunctionName.SUM, AggregateFunction.AggregateFunctionName.AVG).contains(select.getAggregateFunctionName())) {
            return NOOP_POSTPROCESSOR;
        }
        Optional<AqlObjectPath> selectPath = select.getIdentifiedPath().map(IdentifiedPath::getPath);
        List nodes = selectPath.map(AqlObjectPath::getPathNodes).orElseGet(Collections::emptyList);
        return AslExtractedColumn.find(select.root(), (AqlObjectPath)selectPath.orElse(null)).or(() -> Optional.of(AslExtractedColumn.ARCHETYPE_NODE_ID).filter(e -> selectPath.filter(p -> p.endsWith(e.getPath())).isPresent())).or(() -> AslExtractedColumn.find("AUDIT_DETAILS", new AqlObjectPath(nodes.stream().skip(1L).toList())).filter(e -> "ORIGINAL_VERSION".equals(select.root().getRmType())).filter(e -> nodes.stream().limit(1L).map(AqlObjectPath.PathNode::getAttribute).allMatch("commit_audit"::equals))).map(ec -> new ExtractedColumnResultPostprocessor((AslExtractedColumn)((Object)ec), this.knowledgeCache, this.systemService.getSystemId())).orElseGet(DefaultResultPostprocessor::new);
    }

    private static List<Object> postProcessDbRecord(Record r, AqlSqlResultPostprocessor[] postProcessors) {
        ArrayList<Object> resultRow = new ArrayList<Object>(r.size());
        for (int i = 0; i < r.size(); ++i) {
            resultRow.add(postProcessors[i].postProcessColumn(r.get(i)));
        }
        return resultRow;
    }
}

