/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.pathanalysis;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathCohesionAnalysis;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathInfo;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.ContainsWrapper;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.ehrbase.openehr.util.TreeNode;
import org.ehrbase.openehr.util.TreeUtils;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

class PathInfoTest {
    PathInfoTest() {
    }

    @ParameterizedTest(name="{index} {0}")
    @MethodSource
    void pathSkipping(String name, String aql, String cohesionTrees) {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)aql);
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery, (boolean)true);
        String actualTrees = queryWrapper.pathInfos().entrySet().stream().map(e -> ((ContainsWrapper)e.getKey()).alias() + ": " + PathInfoTest.renderTree(((PathInfo)e.getValue()).getCohesionTreeRoot(), ((PathInfo)e.getValue()).getJoinConditionTypes())).collect(Collectors.joining("\n"));
        Assertions.assertThat((String)actualTrees).isEqualToNormalizingNewlines((CharSequence)cohesionTrees);
    }

    public static Stream<Arguments> pathSkipping() throws IOException {
        PathMatchingResourcePatternResolver res = new PathMatchingResourcePatternResolver(PathInfoTest.class.getClassLoader());
        Resource r = res.getResource("classpath:/org/ehrbase/openehr/aqlengine/testdata/pathskipping.txt");
        return Arrays.stream(r.getContentAsString(StandardCharsets.UTF_8).split("\\R+#+\\R+")).skip(1L).map(tc -> {
            String[] split = tc.split(">>>");
            return Arguments.of((Object[])new Object[]{split[0], split[1], split[2].trim().replaceAll("^\\s*\\R", "")});
        });
    }

    private static String renderTree(PathCohesionAnalysis.PathCohesionTreeNode node, Map<PathCohesionAnalysis.PathCohesionTreeNode, Set<PathInfo.PathJoinConditionType>> joinTypeMap) {
        return TreeUtils.renderTree((TreeNode)node, Comparator.comparing(n -> new AqlObjectPath(new AqlObjectPath.PathNode[]{n.getAttribute()}).render()), n -> new AqlObjectPath(new AqlObjectPath.PathNode[]{n.getAttribute()}).render() + ": " + String.valueOf(joinTypeMap.get(n)));
    }
}

