/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.testdata;

import java.net.URI;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.java.quickcheck.generator.PrimitiveGenerators;
import org.ehrbase.openehr.aqlengine.testdata.CompositionSupport;
import org.ehrbase.openehr.aqlengine.testdata.EhrSupport;
import org.ehrbase.openehr.aqlengine.testdata.FolderSupport;
import org.ehrbase.openehr.aqlengine.testdata.ItemSupport;
import org.ehrbase.openehr.sdk.client.openehrclient.OpenEhrClientConfig;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled
class CreateFolderDataTest {
    private static final String RESULT = "Created EHR[%s] With Root-Folder[%s]";
    private static final String FOLDER_ITEMS = "Creating %ds Items For Folder[%s]";
    private static final String NO_ITEMS = "";
    private static final String NO_FOLDER = "";

    CreateFolderDataTest() {
    }

    @Test
    void generateTestData() {
        String ehrId = new TestDataGenerator().create().createEhr().createRootFolder().createEncounterFolder(1).createSubEncounterFolder(CreateFolderDataTest.anyNumberLessThan(10)).createItemsperSubEncounterFolder(CreateFolderDataTest.anyNumberLessThan(50));
        System.out.println("Ehr[%s] Created".formatted(ehrId));
    }

    private static int anyNumberLessThan(int num) {
        return (Integer)PrimitiveGenerators.integers((int)1, (int)num).next();
    }

    private String createFolder(String name, final String subFolder, final String items) {
        FolderSpec folderSpec = new FolderSpec(this, name, UUID.randomUUID()){

            @Override
            String build() {
                return FolderSupport.render(UUID.randomUUID(), this.name, subFolder, items);
            }
        };
        return folderSpec.build();
    }

    private String createItems(CompositionSupport compositionSupport, final UUID ehrId, int numItems) {
        return IntStream.range(0, numItems).mapToObj(i2 -> {
            ItemSpec item = new ItemSpec(this, compositionSupport, "localNS"){

                @Override
                String build() {
                    return ItemSupport.create(this.compositionSupport.create(ehrId).getRoot().getValue(), this.ns);
                }
            };
            return item.build();
        }).collect(Collectors.joining(","));
    }

    public class TestDataGenerator {
        private final OpenEhrClientConfig cfg = new OpenEhrClientConfig(URI.create("http://localhost:8080/ehrbase/"));
        private final CompositionSupport compositionSupport = new CompositionSupport(this.cfg);
        private final FolderSupport folderSupport = new FolderSupport(this.cfg);
        private final EhrSupport ehrSupport = new EhrSupport(this.cfg);

        CreateEhr<CreateFolder<CreateEncounterFolder<CreateSubEncounterFolder<CreateItemsPerSubEncounterFolder<String>>>>> create() {
            return () -> () -> numEncFolder -> numSubEncFolder -> numItems -> {
                EhrSpec ehrSpec = new EhrSpec(this.ehrSupport){

                    @Override
                    String build() {
                        UUID ehrId = this.ehrSupport.create(UUID.randomUUID(), "namespace_8480722");
                        String allEncounterFolder = IntStream.range(0, CreateFolderDataTest.anyNumberLessThan(numEncFolder)).mapToObj(i -> {
                            String allSubFolder = IntStream.range(0, CreateFolderDataTest.anyNumberLessThan(numSubEncFolder)).mapToObj(i1 -> {
                                int itemNum = CreateFolderDataTest.anyNumberLessThan(numItems);
                                System.out.println(CreateFolderDataTest.FOLDER_ITEMS.formatted(itemNum, "subEncounterFolder" + i1));
                                return CreateFolderDataTest.this.createFolder("subEncounterFolder" + i1, "", CreateFolderDataTest.this.createItems(TestDataGenerator.this.compositionSupport, ehrId, itemNum));
                            }).collect(Collectors.joining(","));
                            return CreateFolderDataTest.this.createFolder("encounter" + i, allSubFolder, "");
                        }).collect(Collectors.joining(","));
                        UUID folderUUID = TestDataGenerator.this.folderSupport.create(ehrId, CreateFolderDataTest.this.createFolder("rootFolder", allEncounterFolder, ""));
                        System.out.println(CreateFolderDataTest.RESULT.formatted(ehrId, folderUUID));
                        return ehrId.toString();
                    }
                };
                return ehrSpec.build();
            };
        }
    }

    static interface CreateEhr<T> {
        public T createEhr();
    }

    static interface CreateFolder<T> {
        public T createRootFolder();
    }

    static interface CreateEncounterFolder<T> {
        public T createEncounterFolder(int var1);
    }

    static interface CreateSubEncounterFolder<T> {
        public T createSubEncounterFolder(int var1);
    }

    static interface CreateItemsPerSubEncounterFolder<T> {
        public T createItemsperSubEncounterFolder(int var1);
    }

    static abstract class FolderSpec {
        final String name;
        final UUID uuid;

        public FolderSpec(String name, UUID uuid) {
            this.name = name;
            this.uuid = uuid;
        }

        abstract String build();
    }

    static abstract class ItemSpec {
        final CompositionSupport compositionSupport;
        final String ns;

        public ItemSpec(CompositionSupport compositionSupport, String ns) {
            this.compositionSupport = compositionSupport;
            this.ns = ns;
        }

        abstract String build();
    }

    static abstract class EhrSpec {
        final EhrSupport ehrSupport;

        public EhrSpec(EhrSupport ehrSupport) {
            this.ehrSupport = ehrSupport;
        }

        abstract String build();
    }
}

