/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.testdata;

import com.nedap.archie.rm.composition.Composition;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.xmlbeans.XmlException;
import org.ehrbase.openehr.sdk.client.openehrclient.OpenEhrClientConfig;
import org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient.DefaultRestClient;
import org.ehrbase.openehr.sdk.client.openehrclient.defaultrestclient.DefaultRestTemplateEndpoint;
import org.ehrbase.openehr.sdk.test_data.operationaltemplate.OperationalTemplateTestData;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.templateprovider.TemplateProvider;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;

public class TemplateSupport {
    private final Supplier<DefaultRestTemplateEndpoint> endpoint = () -> new DefaultRestTemplateEndpoint(new DefaultRestClient(cfg, new TemplateProvider(this){

        public Optional<OPERATIONALTEMPLATE> find(String templateId) {
            try {
                OPERATIONALTEMPLATE template = TemplateDocument.Factory.parse((InputStream)OperationalTemplateTestData.findByTemplateId((String)templateId).getStream()).getTemplate();
                return Optional.of(template);
            }
            catch (IOException | XmlException e) {
                throw new RuntimeException(e);
            }
        }

        public Optional<WebTemplate> buildIntrospect(String templateId) {
            return super.buildIntrospect(templateId);
        }
    }));

    public TemplateSupport(OpenEhrClientConfig cfg) {
    }

    public void ensureTemplateExistence(Composition composition) {
        String templateId = composition.getArchetypeDetails().getTemplateId().getValue();
        this.endpoint.get().ensureExistence(templateId);
    }
}

