/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvDate;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDuration;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvTime;
import java.lang.constant.Constable;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.openehr.aqlengine.ChangeTypeUtils;
import org.ehrbase.openehr.aqlengine.asl.AslFromCreator;
import org.ehrbase.openehr.aqlengine.asl.AslPathCreator;
import org.ehrbase.openehr.aqlengine.asl.AslUtils;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.AslRmTypeAndConcept;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslDvOrderedValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFalseQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotNullQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslTrueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslAggregatingField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslDvOrderedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslRmPathField;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.select.SelectWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.ComparisonOperatorConditionWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.ConditionWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.LogicalOperatorConditionWrapper;
import org.ehrbase.openehr.dbformat.StructureRmType;
import org.ehrbase.openehr.sdk.aql.dto.operand.AggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.DoublePrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.LongPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.TemporalPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.orderby.OrderByExpression;
import org.ehrbase.openehr.sdk.util.OpenEHRDateTimeSerializationUtils;
import org.jooq.SortOrder;
import org.springframework.stereotype.Component;

@Component
public class AqlSqlLayer {
    private static final Set<String> NUMERIC_DV_ORDERED_TYPES = Set.of("DV_ORDINAL", "DV_SCALE", "DV_PROPORTION", "DV_COUNT", "DV_QUANTITY");
    private final KnowledgeCacheService knowledgeCache;
    private final SystemService systemService;
    private final AqlQueryContext aqlQueryContext;

    public AqlSqlLayer(KnowledgeCacheService knowledgeCache, SystemService systemService, AqlQueryContext aqlQueryContext) {
        this.knowledgeCache = knowledgeCache;
        this.systemService = systemService;
        this.aqlQueryContext = aqlQueryContext;
    }

    public AslRootQuery buildAslRootQuery(AqlQueryWrapper query) {
        AslUtils.AliasProvider aliasProvider = new AslUtils.AliasProvider();
        AslRootQuery aslQuery = new AslRootQuery();
        AslFromCreator.ContainsToOwnerProvider containsToStructureSubquery = new AslFromCreator(aliasProvider, this.knowledgeCache, this.aqlQueryContext.isArchetypeLocalNodePredicates()).addFromClause(aslQuery, query);
        AslPathCreator.PathToField pathToField = new AslPathCreator(aliasProvider, this.knowledgeCache, this.systemService.getSystemId()).addPathQueries(query, containsToStructureSubquery, aslQuery);
        if (query.nonPrimitiveSelects().findAny().isEmpty()) {
            AqlSqlLayer.addSyntheticSelect(query, containsToStructureSubquery, aslQuery);
        } else {
            boolean usesAggregateFunction = AqlSqlLayer.addSelect(query, pathToField, aslQuery);
            AqlSqlLayer.addOrderBy(query, pathToField, aslQuery, usesAggregateFunction);
        }
        Optional.of(query).map(AqlQueryWrapper::where).flatMap(w -> this.buildWhereCondition((ConditionWrapper)w, pathToField)).ifPresent(aslQuery::addConditionAnd);
        aslQuery.setLimit(query.limit());
        aslQuery.setOffset(query.offset());
        return aslQuery;
    }

    private static void addOrderBy(AqlQueryWrapper query, AslPathCreator.PathToField pathToField, AslRootQuery rootQuery, boolean usesAggregateFunction) {
        CollectionUtils.emptyIfNull(query.orderBy()).forEach(o -> rootQuery.addOrderBy(pathToField.getField(o.identifiedPath()), o.direction() == OrderByExpression.OrderByDirection.DESC ? SortOrder.DESC : SortOrder.ASC, query.distinct() || usesAggregateFunction));
    }

    private static boolean addSelect(AqlQueryWrapper query, AslPathCreator.PathToField pathToField, AslRootQuery rootQuery) {
        query.nonPrimitiveSelects().map(select -> switch (select.type()) {
            default -> throw new MatchException(null, null);
            case SelectWrapper.SelectType.PATH -> pathToField.getField(select.getIdentifiedPath().orElseThrow());
            case SelectWrapper.SelectType.AGGREGATE_FUNCTION -> new AslAggregatingField(select.getAggregateFunctionName(), pathToField.getField(select.getIdentifiedPath().orElse(null)), select.isCountDistinct());
            case SelectWrapper.SelectType.PRIMITIVE, SelectWrapper.SelectType.FUNCTION -> throw new IllegalArgumentException();
        }).forEach(rootQuery.getSelect()::add);
        boolean usesAggregateFunction = query.nonPrimitiveSelects().anyMatch(s -> s.type() == SelectWrapper.SelectType.AGGREGATE_FUNCTION);
        if (usesAggregateFunction) {
            rootQuery.getGroupByFields().addAll(query.nonPrimitiveSelects().filter(s -> s.type() != SelectWrapper.SelectType.AGGREGATE_FUNCTION).map(SelectWrapper::getIdentifiedPath).flatMap(Optional::stream).map(pathToField::getField).flatMap(aslField -> aslField.fieldsForAggregation(rootQuery)).distinct().toList());
        } else if (query.distinct()) {
            rootQuery.getGroupByFields().addAll(rootQuery.getSelect().stream().flatMap(aslField -> aslField.fieldsForAggregation(rootQuery)).distinct().toList());
        }
        return usesAggregateFunction;
    }

    private static void addSyntheticSelect(AqlQueryWrapper query, AslFromCreator.ContainsToOwnerProvider containsToStructureSubQuery, AslRootQuery rootQuery) {
        AslQuery ownerForSyntheticSelect = containsToStructureSubQuery.get(query.containsChain().chain().getFirst()).owner();
        AslColumnField field = rootQuery.getAvailableFields().stream().filter(AslColumnField.class::isInstance).map(AslColumnField.class::cast).filter(f -> f.getOwner() == ownerForSyntheticSelect).filter(f -> StringUtils.equalsAny((CharSequence)f.getColumnName(), (CharSequence[])new CharSequence[]{"id", AslStructureColumn.VO_ID.getFieldName()})).findFirst().orElseThrow();
        rootQuery.getSelect().add(new AslAggregatingField(AggregateFunction.AggregateFunctionName.COUNT, field, false));
    }

    private Optional<AslQueryCondition> buildWhereCondition(ConditionWrapper condition, AslPathCreator.PathToField pathToField) {
        ConditionWrapper conditionWrapper = condition;
        Objects.requireNonNull(conditionWrapper);
        ConditionWrapper conditionWrapper2 = conditionWrapper;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LogicalOperatorConditionWrapper.class, ComparisonOperatorConditionWrapper.class}, (Object)conditionWrapper2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                LogicalOperatorConditionWrapper lcd = (LogicalOperatorConditionWrapper)conditionWrapper2;
                yield AqlSqlLayer.logicalOperatorCondition(lcd, c -> this.buildWhereCondition((ConditionWrapper)c, pathToField));
            }
            case 1 -> {
                AslRmPathField pathField;
                ComparisonOperatorConditionWrapper comparison = (ComparisonOperatorConditionWrapper)conditionWrapper2;
                AslField aslField = pathToField.getField(comparison.leftComparisonOperand().path());
                if (aslField == null) {
                    throw new IllegalArgumentException("unknown field: %s".formatted(comparison.leftComparisonOperand().path().getPath().render()));
                }
                if (aslField instanceof AslDvOrderedColumnField) {
                    AslDvOrderedColumnField dvOrderedField = (AslDvOrderedColumnField)aslField;
                    yield AqlSqlLayer.buildDvOrderedCondition(dvOrderedField, dvOrderedField.getDvOrderedTypes(), comparison.operator(), comparison.rightComparisonOperands());
                }
                if (aslField instanceof AslRmPathField && !(pathField = (AslRmPathField)aslField).getDvOrderedTypes().isEmpty()) {
                    yield AqlSqlLayer.buildDvOrderedCondition(pathField, pathField.getDvOrderedTypes(), comparison.operator(), comparison.rightComparisonOperands());
                }
                yield this.fieldValueQueryCondition(aslField, comparison);
            }
        };
    }

    private static Optional<AslQueryCondition> logicalOperatorCondition(LogicalOperatorConditionWrapper condition, Function<ConditionWrapper, Optional<AslQueryCondition>> conditionBuilder) {
        Stream<AslQueryCondition> operands = condition.logicalOperands().stream().map(conditionBuilder).flatMap(Optional::stream);
        if (condition.operator() == ConditionWrapper.LogicalConditionOperator.NOT) {
            return Optional.of(ConditionWrapper.LogicalConditionOperator.NOT.build(operands.toList()));
        }
        return AslUtils.reduceConditions(condition.operator(), operands);
    }

    private Optional<AslQueryCondition> fieldValueQueryCondition(AslField aslField, ComparisonOperatorConditionWrapper comparison) {
        ConditionWrapper.ComparisonConditionOperator operator = comparison.operator();
        return Optional.of(switch (operator) {
            default -> throw new MatchException(null, null);
            case ConditionWrapper.ComparisonConditionOperator.EXISTS -> {
                if (aslField.getExtractedColumn() != null) {
                    yield new AslTrueQueryCondition();
                }
                yield new AslNotNullQueryCondition(aslField);
            }
            case ConditionWrapper.ComparisonConditionOperator.LIKE, ConditionWrapper.ComparisonConditionOperator.MATCHES, ConditionWrapper.ComparisonConditionOperator.EQ, ConditionWrapper.ComparisonConditionOperator.GT_EQ, ConditionWrapper.ComparisonConditionOperator.GT, ConditionWrapper.ComparisonConditionOperator.LT_EQ, ConditionWrapper.ComparisonConditionOperator.LT, ConditionWrapper.ComparisonConditionOperator.NEQ -> {
                List<?> values = this.whereConditionValues(aslField, comparison, operator);
                if (values.isEmpty()) {
                    switch (operator.getAslOperator()) {
                        case IN: 
                        case EQ: 
                        case LIKE: {
                            yield new AslFalseQueryCondition();
                        }
                        case NEQ: {
                            yield new AslTrueQueryCondition();
                        }
                    }
                    throw new IllegalArgumentException("Unexpected operator %s".formatted(new Object[]{operator.getAslOperator()}));
                }
                yield new AslFieldValueQueryCondition(aslField, operator.getAslOperator(), values);
            }
        });
    }

    private List<?> whereConditionValues(AslField aslField, ComparisonOperatorConditionWrapper comparison, ConditionWrapper.ComparisonConditionOperator operator) {
        AslExtractedColumn aslExtractedColumn = aslField.getExtractedColumn();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TEMPLATE_ID", "ARCHETYPE_NODE_ID", "ROOT_CONCEPT", "OV_TIME_COMMITTED_DV", "EHR_TIME_CREATED_DV", "AD_CHANGE_TYPE_CODE_STRING", "AD_CHANGE_TYPE_PREFERRED_TERM", "AD_CHANGE_TYPE_VALUE"}, (AslExtractedColumn)aslExtractedColumn, n)) {
            case 0 -> AslUtils.templateIdConditionValues(comparison.rightComparisonOperands(), operator, arg_0 -> ((KnowledgeCacheService)this.knowledgeCache).findUuidByTemplateId(arg_0));
            case 1 -> AslUtils.archetypeNodeIdConditionValues(comparison.rightComparisonOperands(), operator);
            case 2 -> AslUtils.archetypeNodeIdConditionValues(comparison.rightComparisonOperands(), operator).stream().filter(tc -> StructureRmType.COMPOSITION.getAlias().equals(tc.aliasedRmType())).map(AslRmTypeAndConcept::concept).toList();
            case 3, 4 -> AslUtils.streamStringPrimitives(comparison).map(AslUtils::toOffsetDateTime).filter(Objects::nonNull).toList();
            case 5 -> AslUtils.streamStringPrimitives(comparison).map(Primitive::getValue).map(ChangeTypeUtils::getJooqChangeTypeByCode).filter(Objects::nonNull).toList();
            case 6, 7 -> AslUtils.streamStringPrimitives(comparison).map(Primitive::getValue).map(v -> "unknown".equals(v) ? ContributionChangeType.Unknown : ContributionChangeType.lookupLiteral((String)v)).filter(Objects::nonNull).toList();
            case -1 -> AslUtils.conditionValue(comparison.rightComparisonOperands(), operator, aslField.getType());
            default -> AslUtils.conditionValue(comparison.rightComparisonOperands(), operator, aslField.getType());
        };
    }

    private static Optional<AslQueryCondition> buildDvOrderedCondition(AslField field, Set<String> dvOrderedTypes, ConditionWrapper.ComparisonConditionOperator operator, List<Primitive> values) {
        if (operator == ConditionWrapper.ComparisonConditionOperator.EXISTS || operator == ConditionWrapper.ComparisonConditionOperator.LIKE) {
            throw new IllegalArgumentException("LIKE/EXISTS on DV_ORDERED is not supported");
        }
        List<Pair<Set<String>, Set<Object>>> typeToValues = AqlSqlLayer.determinePossibleDvOrderedTypesAndValues(dvOrderedTypes, operator, values);
        if (typeToValues.isEmpty()) {
            return Optional.of(new AslFalseQueryCondition());
        }
        return AslUtils.reduceConditions(ConditionWrapper.LogicalConditionOperator.OR, typeToValues.stream().map(e -> new AslDvOrderedValueQueryCondition((Set)e.getKey(), field, operator.getAslOperator(), List.copyOf((Collection)e.getValue()))));
    }

    private static List<Pair<Set<String>, Set<Object>>> determinePossibleDvOrderedTypesAndValues(Set<String> allowedTypes, ConditionWrapper.ComparisonConditionOperator operator, Collection<Primitive> values) {
        HashMap<String, Set<Object>> nonNumericDvOrderedTypeToValues = new HashMap<String, Set<Object>>();
        boolean hasNumericDvOrdered = CollectionUtils.containsAny(allowedTypes, NUMERIC_DV_ORDERED_TYPES);
        HashSet<Constable> numericValues = new HashSet<Constable>();
        boolean isEqualsOp = operator == ConditionWrapper.ComparisonConditionOperator.EQ || operator == ConditionWrapper.ComparisonConditionOperator.MATCHES;
        for (Primitive value : values) {
            if (value instanceof TemporalPrimitive) {
                TemporalPrimitive p = (TemporalPrimitive)value;
                AqlSqlLayer.handleTemporalPrimitiveForDvOrdered(allowedTypes, p.getTemporal(), isEqualsOp, nonNumericDvOrderedTypeToValues);
                continue;
            }
            if (value instanceof StringPrimitive) {
                StringPrimitive p = (StringPrimitive)value;
                AqlSqlLayer.handleStringPrimitiveForDvOrdered(allowedTypes, p, isEqualsOp, nonNumericDvOrderedTypeToValues);
                continue;
            }
            if (!(value instanceof DoublePrimitive) && !(value instanceof LongPrimitive) || !hasNumericDvOrdered) continue;
            numericValues.add(value.getValue());
        }
        ArrayList<Pair<Set<String>, Set<Object>>> result = new ArrayList<Pair<Set<String>, Set<Object>>>();
        if (!numericValues.isEmpty()) {
            SetUtils.SetView numericDvOrderedTypes = SetUtils.intersection(allowedTypes, NUMERIC_DV_ORDERED_TYPES);
            result.add(Pair.of((Object)numericDvOrderedTypes, numericValues));
        }
        nonNumericDvOrderedTypeToValues.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).map(e -> Pair.of(Set.of((String)e.getKey()), (Object)((Set)e.getValue()))).forEach(result::add);
        return result;
    }

    private static void handleStringPrimitiveForDvOrdered(Set<String> allowedTypes, StringPrimitive p, boolean isEqualsOp, HashMap<String, Set<Object>> result) {
        String val = (String)((Object)p.getValue());
        if (CollectionUtils.containsAny(allowedTypes, (Object[])new String[]{"DV_DATE", "DV_DATE_TIME", "DV_TIME"})) {
            AslUtils.parseDateTimeOrTimeWithHigherPrecision(val).ifPresent(t -> AqlSqlLayer.handleTemporalPrimitiveForDvOrdered(allowedTypes, t, isEqualsOp, result));
        }
        if (allowedTypes.contains("DV_DURATION")) {
            Optional.of(val).map(v -> {
                try {
                    return new DvDuration(val);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }).map(DvDuration::getMagnitude).ifPresent(m -> AqlSqlLayer.addToMultiValuedMap(result, "DV_DURATION", m));
        }
    }

    private static void handleTemporalPrimitiveForDvOrdered(Set<String> allowedTypes, TemporalAccessor p, boolean isEqualsOp, HashMap<String, Set<Object>> result) {
        boolean hasDate = p.isSupported(ChronoField.YEAR);
        boolean hasTime = p.isSupported(ChronoField.HOUR_OF_DAY);
        if (hasDate) {
            if (!(hasTime && isEqualsOp || !allowedTypes.contains("DV_DATE"))) {
                AqlSqlLayer.addToMultiValuedMap(result, "DV_DATE", OpenEHRDateTimeSerializationUtils.toMagnitude((DvDate)new DvDate((Temporal)LocalDate.from(p))));
            }
            if (allowedTypes.contains("DV_DATE_TIME")) {
                AqlSqlLayer.addToMultiValuedMap(result, "DV_DATE_TIME", OpenEHRDateTimeSerializationUtils.toMagnitude((DvDateTime)new DvDateTime(p)));
            }
        } else if (hasTime && allowedTypes.contains("DV_TIME")) {
            AqlSqlLayer.addToMultiValuedMap(result, "DV_TIME", OpenEHRDateTimeSerializationUtils.toMagnitude((DvTime)new DvTime(p)));
        }
    }

    private static <K, V> void addToMultiValuedMap(Map<K, Set<V>> map, K key, V value) {
        map.computeIfAbsent(key, k -> new LinkedHashSet()).add(value);
    }
}

