/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.querywrapper.contains;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.ContainsWrapper;
import org.ehrbase.openehr.dbformat.StructureRmType;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPathUtil;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;

public final class RmContainsWrapper
implements ContainsWrapper {
    private final ContainmentClassExpression containment;
    private ContainsWrapper parent;

    public RmContainsWrapper(ContainmentClassExpression containment) {
        this.containment = containment;
    }

    public List<AndOperatorPredicate> getPredicate() {
        return this.containment.getPredicates();
    }

    public StructureRmType getStructureRmType() {
        return StructureRmType.byTypeName((String)this.containment.getType()).orElse(null);
    }

    @Override
    public String getRmType() {
        return StructureRmType.byTypeName((String)this.containment.getType()).map(Enum::name).orElse(this.containment.getType());
    }

    @Override
    public boolean isAtCode() {
        return this.hasConsistentNodeIdPrefixes("at", "id");
    }

    @Override
    public boolean isArchetype() {
        return this.hasConsistentNodeIdPrefixes("openEHR-EHR-");
    }

    @Override
    public ContainsWrapper getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ContainsWrapper parent) {
        this.parent = parent;
    }

    @Override
    public String alias() {
        return this.containment.getIdentifier();
    }

    public ContainmentClassExpression containment() {
        return this.containment;
    }

    public String toString() {
        return "RmContainsWrapper[containment=" + String.valueOf(this.containment) + "]";
    }

    private boolean hasConsistentNodeIdPrefixes(String ... allowedPrefixes) {
        List predicates = this.containment.getPredicates();
        if (CollectionUtils.isEmpty((Collection)predicates)) {
            return false;
        }
        return predicates.stream().map(andPred -> andPred.getOperands().stream().filter(p -> AqlObjectPathUtil.ARCHETYPE_NODE_ID.equals((Object)p.getPath()) && p.getOperator() == ComparisonOperatorPredicate.PredicateComparisonOperator.EQ && p.getValue() instanceof StringPrimitive).map(p -> (String)((Object)((StringPrimitive)p.getValue()).getValue())).map(v -> StringUtils.startsWithAny((CharSequence)v, (CharSequence[])allowedPrefixes)).reduce(Boolean::logicalAnd).orElse(false)).reduce(true, Boolean::logicalAnd);
    }
}

