/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.sql;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.service.TemplateService;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.EhrFolderData;
import org.ehrbase.jooq.pg.util.AdditionalSQLFunctions;
import org.ehrbase.openehr.aqlengine.AqlConfigurationProperties;
import org.ehrbase.openehr.aqlengine.asl.AslUtils;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslAggregatingField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslConstantField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslFolderItemIdVirtualField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslRmPathField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslSubqueryField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslEncapsulatingQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslFilteringQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslPathDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRmObjectDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.sql.ConditionUtils;
import org.ehrbase.openehr.aqlengine.sql.EncapsulatingQueryUtils;
import org.ehrbase.openehr.aqlengine.sql.FieldUtils;
import org.ehrbase.openehr.aqlengine.sql.postprocessor.AqlSqlQueryPostProcessor;
import org.jooq.ArrayAggOrderByStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.JSONB;
import org.jooq.Operator;
import org.jooq.OrderField;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.SelectJoinStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.SelectQuery;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;

@Component
public class AqlSqlQueryBuilder {
    private final AqlConfigurationProperties aqlConfigurationProperties;
    private final DSLContext context;
    private final TemplateService templateService;
    private final Optional<AqlSqlQueryPostProcessor> queryPostProcessor;

    public AqlSqlQueryBuilder(AqlConfigurationProperties aqlConfigurationProperties, DSLContext context, TemplateService templateService, Optional<AqlSqlQueryPostProcessor> queryPostProcessor) {
        this.aqlConfigurationProperties = aqlConfigurationProperties;
        this.context = context;
        this.templateService = templateService;
        this.queryPostProcessor = queryPostProcessor;
    }

    public static String subqueryAlias(AslQuery aslQuery) {
        return aslQuery.getAlias() + "sq";
    }

    public static String versionSubqueryAlias(AslQuery aslQuery) {
        return aslQuery.getAlias() + "_version_sq";
    }

    public SelectQuery<Record> buildSqlQuery(AslRootQuery aslRootQuery) {
        AslQueryTables aslQueryToTable = new AslQueryTables();
        SelectJoinStep<Record> encapsulatingQuery = this.buildEncapsulatingQuery(aslRootQuery, () -> this.context.select(new SelectFieldOrAsterisk[0]), aslQueryToTable);
        SelectQuery query = encapsulatingQuery.getQuery();
        if (aslRootQuery.getLimit() != null) {
            query.addLimit((Number)(aslRootQuery.getOffset() == null ? 0L : aslRootQuery.getOffset()), (Number)aslRootQuery.getLimit());
        }
        this.queryPostProcessor.ifPresent(p -> p.afterBuildSqlQuery(aslRootQuery, (SelectQuery<Record>)query));
        return query;
    }

    public Result<Record> explain(boolean analyze, SelectQuery<Record> selectQuery) {
        if (analyze) {
            return this.context.fetch("EXPLAIN (SUMMARY, COSTS, VERBOSE, FORMAT JSON, ANALYZE, TIMING) {0}", new QueryPart[]{selectQuery});
        }
        return this.context.fetch("EXPLAIN (SUMMARY, COSTS, VERBOSE, FORMAT JSON) {0}", new QueryPart[]{selectQuery});
    }

    private SelectJoinStep<Record> buildEncapsulatingQuery(AslEncapsulatingQuery aq, Supplier<SelectSelectStep<Record>> creator, AslQueryTables aslQueryToTable) {
        Iterator<Pair<AslQuery, AslJoin>> childIt = aq.getChildren().iterator();
        AslQuery aslRoot = (AslQuery)childIt.next().getLeft();
        Table<?> root = this.buildQuery(aslRoot, null, aslQueryToTable);
        aslQueryToTable.put(aslRoot, root, root);
        SelectJoinStep from = creator.get().from(root);
        while (childIt.hasNext()) {
            Pair<AslQuery, AslJoin> nextChild = childIt.next();
            AslQuery childQuery = (AslQuery)nextChild.getLeft();
            AslJoin join = (AslJoin)nextChild.getRight();
            AslQuery target = join.getLeft();
            Table<?> toJoin = this.buildQuery(childQuery, target, aslQueryToTable);
            if (this.aqlConfigurationProperties.pgLljWorkaround()) {
                EncapsulatingQueryUtils.applyPgLljWorkaround(childQuery, join, toJoin);
            }
            aslQueryToTable.put(childQuery, toJoin, toJoin);
            from.join(toJoin, join.getJoinType()).on(ConditionUtils.buildJoinCondition(join, aslQueryToTable));
        }
        SelectQuery query = from.getQuery();
        for (AslField field : aq.getSelect()) {
            SelectField<?> sqlField = EncapsulatingQueryUtils.selectField(field, aslQueryToTable);
            query.addSelect(new SelectFieldOrAsterisk[]{sqlField});
        }
        query.addConditions(Operator.AND, Stream.concat(Optional.of(aq).map(AslQuery::getCondition).stream(), aq.getStructureConditions().stream()).map(c -> ConditionUtils.buildCondition(c, aslQueryToTable, true)).toList());
        if (aq instanceof AslRootQuery) {
            AslRootQuery rq = (AslRootQuery)aq;
            rq.getGroupByFields().stream().flatMap(gb -> EncapsulatingQueryUtils.groupByFields(gb, aslQueryToTable)).forEach(xva$0 -> query.addGroupBy(new GroupField[]{xva$0}));
            rq.getGroupByDvOrderedMagnitudeFields().stream().map(f -> {
                Table<?> dataTable = aslQueryToTable.getDataTable(f.getInternalProvider());
                Field<JSONB> dvOrderedField = FieldUtils.buidDvOrderedField(true, f, dataTable);
                return AdditionalSQLFunctions.jsonb_dv_ordered_magnitude(dvOrderedField);
            }).forEach(xva$0 -> query.addGroupBy(new GroupField[]{xva$0}));
            rq.getOrderByFields().stream().flatMap(ob -> EncapsulatingQueryUtils.orderFields(ob, aslQueryToTable, this.templateService)).forEach(xva$0 -> query.addOrderBy(new OrderField[]{xva$0}));
        }
        return from;
    }

    private Table<?> buildQuery(AslQuery aslQuery, AslQuery target, AslQueryTables aslQueryToTable) {
        AslQuery aslQuery2 = aslQuery;
        Objects.requireNonNull(aslQuery2);
        AslQuery aslQuery3 = aslQuery2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslStructureQuery.class, AslEncapsulatingQuery.class, AslRmObjectDataQuery.class, AslFilteringQuery.class, AslPathDataQuery.class}, (Object)aslQuery3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslStructureQuery aq = (AslStructureQuery)aslQuery3;
                yield AqlSqlQueryBuilder.buildStructureQuery(aq, aslQueryToTable).asTable(aq.getAlias());
            }
            case 1 -> {
                AslEncapsulatingQuery aq = (AslEncapsulatingQuery)aslQuery3;
                yield this.buildEncapsulatingQuery(aq, () -> DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]), aslQueryToTable).asTable(aq.getAlias());
            }
            case 2 -> {
                AslRmObjectDataQuery aq = (AslRmObjectDataQuery)aslQuery3;
                yield DSL.lateral((TableLike)AqlSqlQueryBuilder.buildDataSubquery(aq, aslQueryToTable, new Condition[0]).asTable(aq.getAlias()));
            }
            case 3 -> {
                AslFilteringQuery aq = (AslFilteringQuery)aslQuery3;
                yield DSL.lateral((TableLike)AqlSqlQueryBuilder.buildFilteringQuery(aq, aslQueryToTable.getDataTable(target)).asTable(aq.getAlias()));
            }
            case 4 -> {
                AslPathDataQuery aq = (AslPathDataQuery)aslQuery3;
                yield DSL.lateral((TableLike)AqlSqlQueryBuilder.buildPathDataQuery(aq, target, aslQueryToTable).asTable(aq.getAlias()));
            }
        };
    }

    private static TableLike<Record> buildPathDataQuery(AslPathDataQuery aslData, AslQuery target, AslQueryTables aslQueryToTable) {
        Table<?> targetTable = aslQueryToTable.getDataTable(target);
        Function<String, Field> dataFieldProvider = colName -> FieldUtils.aliasedField(targetTable, aslData, colName, JSONB.class);
        return DSL.select(aslData.getSelect().stream().map(AslColumnField.class::cast).map(f -> AqlSqlQueryBuilder.pathDataField(aslData, f, dataFieldProvider)).toList());
    }

    private static Field pathDataField(AslPathDataQuery aslData, AslColumnField f, Function<String, Field<JSONB>> dataFieldProvider) {
        Field<JSONB> dataField = dataFieldProvider.apply(f.getColumnName());
        Field jsonbField = FieldUtils.buildJsonbPathField(aslData.getPathNodes(f), aslData.isMultipleValued(), dataField);
        Field field = f.getType() == String.class ? DSL.jsonbGetElementAsText(jsonbField, (int)0) : jsonbField;
        return field.as(f.getName(true));
    }

    private static SelectSelectStep<?> buildFilteringQuery(AslFilteringQuery aq, Table<?> target) {
        String fieldName = ((AslColumnField)aq.getSelect().getFirst()).getAliasedName();
        AslField aslField = aq.getSourceField();
        Objects.requireNonNull(aslField);
        AslField aslField2 = aslField;
        int n = 0;
        Stream<Param> fields = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslColumnField.class, AslComplexExtractedColumnField.class, AslConstantField.class, AslAggregatingField.class, AslSubqueryField.class, AslFolderItemIdVirtualField.class, AslRmPathField.class}, (Object)aslField2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslColumnField src = (AslColumnField)aslField2;
                yield Stream.of(FieldUtils.field(target, src, true).as(fieldName));
            }
            case 1 -> {
                AslComplexExtractedColumnField src = (AslComplexExtractedColumnField)aslField2;
                yield src.getExtractedColumn().getColumns().stream().map(fn -> FieldUtils.field(target, src, fn, true).as(src.aliasedName((String)fn)));
            }
            case 2 -> {
                AslConstantField cf = (AslConstantField)aslField2;
                yield Stream.of(DSL.inline(cf.getValue(), cf.getType()));
            }
            case 3 -> {
                AslAggregatingField __ = (AslAggregatingField)aslField2;
                throw new IllegalArgumentException("Filtering queries cannot be based on AslAggregatingField");
            }
            case 4 -> {
                AslSubqueryField __ = (AslSubqueryField)aslField2;
                throw new IllegalArgumentException("Filtering queries cannot be based on AslSubqueryField");
            }
            case 5 -> {
                AslFolderItemIdVirtualField __ = (AslFolderItemIdVirtualField)aslField2;
                throw new IllegalArgumentException("Filtering queries cannot be based on AslFolderItemIdValuesColumnField");
            }
            case 6 -> {
                AslRmPathField arpf = (AslRmPathField)aslField2;
                Field<JSONB> srcField = FieldUtils.field(target, arpf.getSrcField(), JSONB.class, true);
                Field<JSONB> ret = FieldUtils.buildJsonbPathField(arpf.getPathInJson(), false, srcField);
                if (arpf.getType() == String.class) {
                    yield Stream.of(DSL.jsonbGetElementAsText(ret, (Field)DSL.inline((int)0)).as(fieldName));
                }
                yield Stream.of(ret.as(fieldName));
            }
        };
        return DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])fields.toArray(Field[]::new)));
    }

    private static SelectConditionStep<Record> buildStructureQuery(AslStructureQuery aq, AslQueryTables aslQueryToTable) {
        boolean requiresDataTable = !aq.isRoot() || !aq.isRequiresVersionTableJoin() || AslUtils.concatStreams(aq.getSelect().stream(), Optional.of(aq).map(AslQuery::getCondition).stream().flatMap(AslUtils::streamConditionFields), aq.getStructureConditions().stream().flatMap(AslUtils::streamConditionFields)).flatMap(AslUtils::streamFieldNames).anyMatch(f -> aq.getType().getVersionTable().fieldStream().noneMatch(tf -> f.equals(tf.getName())));
        Table dataTable = requiresDataTable ? aq.getType().getDataTable().as(AqlSqlQueryBuilder.subqueryAlias(aq)) : null;
        Table primaryTable = aq.isRequiresVersionTableJoin() ? aq.getType().getVersionTable().as(AqlSqlQueryBuilder.versionSubqueryAlias(aq)) : dataTable;
        SelectJoinStep<Record> step = AqlSqlQueryBuilder.structureQueryBase(aq, primaryTable, dataTable, aq.isRequiresVersionTableJoin());
        aslQueryToTable.put(aq, dataTable, primaryTable);
        SelectConditionStep where = step.where((Condition[])Stream.concat(Optional.of(aq).map(AslQuery::getCondition).stream(), aq.getStructureConditions().stream()).map(c -> ConditionUtils.buildCondition(c, aslQueryToTable, false)).toArray(Condition[]::new));
        if (aq.isRoot() && requiresDataTable) {
            where = where.and(dataTable.field(AslStructureColumn.NUM.getFieldName(), Integer.class).eq((Field)DSL.inline((int)0)));
        }
        aslQueryToTable.remove(aq);
        return where;
    }

    private static SelectJoinStep<Record> structureQueryBase(AslStructureQuery aq, Table<?> primaryTable, Table<?> dataTable, boolean hasVersionTable) {
        Map<Class<? extends AslField>, List<AslField>> aslFields = aq.getSelect().stream().collect(Collectors.groupingBy(Object::getClass));
        Stream<Field<?>> columnFields = AqlSqlQueryBuilder.consumeFieldsOfType(aslFields, AslColumnField.class, cf -> (aq.isRequiresVersionTableJoin() && cf.isVersionTableField() ? primaryTable : dataTable).field(cf.getColumnName()).as(cf.getAliasedName()));
        Stream<AslFolderItemIdVirtualField> folderFields = AqlSqlQueryBuilder.consumeFieldsOfType(aslFields, AslFolderItemIdVirtualField.class, Function.identity());
        if (!aslFields.isEmpty()) {
            throw new IllegalStateException("StructureQueryBase could not handle AslFields of type %s".formatted(aslFields.values().stream().flatMap(Collection::stream).map(Object::getClass).map(Class::getSimpleName).toList()));
        }
        SelectJoinStep<Record> step = hasVersionTable ? AqlSqlQueryBuilder.structureQueryBaseVersionToDataTable(aq, primaryTable, dataTable, columnFields, folderFields) : AqlSqlQueryBuilder.structureQueryBaseUsingDataTable(aq, primaryTable, columnFields, folderFields);
        return step;
    }

    private static Pair<Table<?>, List<SelectFieldOrAsterisk>> buildFolderItemIdNestedSelect(Table<?> dataTable, AslFolderItemIdVirtualField column, boolean subAlias) {
        String fieldName = column.getFieldName();
        EhrFolderData baseFolderTable = Tables.EHR_FOLDER_DATA.as("base");
        EhrFolderData descendantFolderTable = Tables.EHR_FOLDER_DATA.as("descendant");
        Table itemsUUIDArrayTable = DSL.unnest((Field)descendantFolderTable.field((Field)Tables.EHR_FOLDER_DATA.ITEM_UUIDS)).as("fi_uuids");
        Field itemUUIDs = DSL.field((String)DSL.name((String)"fi_uuids").quotedName().toString(), UUID.class, (QueryPart[])new QueryPart[]{itemsUUIDArrayTable});
        SelectOnConditionStep selectOnConditionStep = DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[]{baseFolderTable.asterisk(), itemUUIDs}).from((TableLike)baseFolderTable).join((TableLike)descendantFolderTable).on(descendantFolderTable.EHR_ID.eq((Field)baseFolderTable.EHR_ID)).and(descendantFolderTable.EHR_FOLDERS_IDX.eq((Field)baseFolderTable.EHR_FOLDERS_IDX)).and(descendantFolderTable.NUM.between((Field)baseFolderTable.NUM, (Field)baseFolderTable.NUM_CAP)).join((TableLike)itemsUUIDArrayTable).on(new Condition[0]);
        Table joinTable = subAlias ? selectOnConditionStep.asTable(dataTable.getName() + "_items") : selectOnConditionStep.asTable(dataTable);
        List<Field<?>> selectFields = List.of(FieldUtils.virtualAliasedField(joinTable, itemUUIDs, column, fieldName));
        return Pair.of((Object)joinTable, selectFields);
    }

    private static SelectJoinStep<Record> structureQueryBaseVersionToDataTable(AslStructureQuery aq, Table<?> primaryTable, Table<?> dataTable, Stream<Field<?>> columnFields, Stream<AslFolderItemIdVirtualField> folderFields) {
        return switch (aq.getType()) {
            case AslStructureQuery.AslSourceRelation.EHR_STATUS -> AqlSqlQueryBuilder.structureQueryBaseUsingVersionAndDataTable(columnFields, primaryTable, dataTable, Tables.EHR_STATUS_VERSION.EHR_ID, Tables.EHR_STATUS_DATA.EHR_ID);
            case AslStructureQuery.AslSourceRelation.COMPOSITION -> AqlSqlQueryBuilder.structureQueryBaseUsingVersionAndDataTable(columnFields, primaryTable, dataTable, Tables.COMP_VERSION.VO_ID, Tables.COMP_DATA.VO_ID);
            case AslStructureQuery.AslSourceRelation.FOLDER -> AqlSqlQueryBuilder.folderStructureQueryBaseUsingVersionAndData(primaryTable, dataTable, folderFields, columnFields);
            default -> throw new IllegalArgumentException("%s has no version table".formatted(new Object[]{aq.getType()}));
        };
    }

    private static <T> SelectJoinStep<Record> structureQueryBaseUsingVersionAndDataTable(Stream<Field<?>> columnFields, Table<?> primaryTable, Table<?> dataTable, Field<T> versionField, Field<T> dataField) {
        SelectJoinStep from = DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])columnFields.toArray(SelectFieldOrAsterisk[]::new))).from(primaryTable);
        return dataTable == null ? from : from.join(dataTable).on(primaryTable.field(versionField).eq(dataTable.field(dataField)));
    }

    private static SelectJoinStep<Record> folderStructureQueryBaseUsingVersionAndData(Table<?> primaryTable, Table<?> dataTable, Stream<AslFolderItemIdVirtualField> folderFields, Stream<Field<?>> columnFields) {
        Optional<AslFolderItemIdVirtualField> folderItemAslField = folderFields.findFirst();
        Condition onCondition = primaryTable.field((Field)Tables.EHR_FOLDER_VERSION.EHR_ID).eq(dataTable.field((Field)Tables.EHR_FOLDER_DATA.EHR_ID)).and(primaryTable.field((Field)Tables.EHR_FOLDER_VERSION.EHR_FOLDERS_IDX).eq(dataTable.field((Field)Tables.EHR_FOLDER_DATA.EHR_FOLDERS_IDX)));
        if (folderItemAslField.isEmpty()) {
            return DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])columnFields.toArray(SelectFieldOrAsterisk[]::new))).from(primaryTable).join(dataTable).on(onCondition);
        }
        AslFolderItemIdVirtualField itemIdVirtualField = folderItemAslField.get();
        Pair<Table<?>, List<SelectFieldOrAsterisk>> tableToSelect = AqlSqlQueryBuilder.buildFolderItemIdNestedSelect(dataTable, itemIdVirtualField, false);
        Table joinTable = (Table)tableToSelect.getLeft();
        List selectFields = (List)tableToSelect.getRight();
        return DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])Stream.concat(columnFields, selectFields.stream()).toArray(SelectFieldOrAsterisk[]::new))).from(primaryTable).join((TableLike)joinTable).on(onCondition);
    }

    private static SelectJoinStep<Record> structureQueryBaseUsingDataTable(AslStructureQuery aq, Table<?> primaryTable, Stream<Field<?>> columnFields, Stream<AslFolderItemIdVirtualField> folderFields) {
        Optional<AslFolderItemIdVirtualField> columnField;
        if (aq.getType() == AslStructureQuery.AslSourceRelation.FOLDER && (columnField = folderFields.findFirst()).isPresent()) {
            AslFolderItemIdVirtualField column = columnField.get();
            Pair<Table<?>, List<SelectFieldOrAsterisk>> tableToSelect = AqlSqlQueryBuilder.buildFolderItemIdNestedSelect(primaryTable, column, true);
            Table joinTable = (Table)tableToSelect.getLeft();
            List selectFields = (List)tableToSelect.getRight();
            Condition onCondition = primaryTable.field((Field)Tables.EHR_FOLDER_DATA.NUM).eq(joinTable.field((Field)Tables.EHR_FOLDER_DATA.NUM)).and(primaryTable.field((Field)Tables.EHR_FOLDER_DATA.EHR_ID).eq(joinTable.field((Field)Tables.EHR_FOLDER_DATA.EHR_ID))).and(primaryTable.field((Field)Tables.EHR_FOLDER_DATA.EHR_FOLDERS_IDX).eq(joinTable.field((Field)Tables.EHR_FOLDER_DATA.EHR_FOLDERS_IDX)));
            return DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])Stream.concat(columnFields, selectFields.stream()).toArray(SelectFieldOrAsterisk[]::new))).from(primaryTable).join((TableLike)joinTable).on(onCondition);
        }
        return DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])columnFields.toArray(SelectFieldOrAsterisk[]::new))).from(primaryTable);
    }

    private static <T extends AslField, R> Stream<R> consumeFieldsOfType(Map<Class<? extends AslField>, List<AslField>> aslFields, Class<T> type, Function<? super T, ? extends R> mapper) {
        return Optional.ofNullable(aslFields.remove(type)).orElseGet(List::of).stream().filter(type::isInstance).map(type::cast).map(mapper);
    }

    private static <T> SelectJoinStep<Record> structureQueryBaseVersion(Stream<Field<?>> columnFields, Table<?> primaryTable, Table<?> dataTable, TableField<?, T> tableField) {
        return DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])columnFields.toArray(SelectFieldOrAsterisk[]::new))).from(primaryTable).join(dataTable).on(Objects.requireNonNull(primaryTable.field(tableField)).eq(dataTable.field(tableField)));
    }

    static SelectHavingStep<?> buildDataSubquery(AslRmObjectDataQuery aslData, AslQueryTables aslQueryToTable, Condition ... additionalConditions) {
        AslStructureQuery sq;
        AslQuery target = aslData.getBaseProvider();
        Table<?> targetTable = aslQueryToTable.getDataTable(target);
        AslStructureQuery.AslSourceRelation type = AslUtils.getTargetType(aslData.getBase());
        AslQuery aslQuery = aslData.getBase();
        boolean isRoot = aslQuery instanceof AslStructureQuery && (sq = (AslStructureQuery)aslQuery).isRoot();
        Table data = type.getDataTable().as(AqlSqlQueryBuilder.subqueryAlias(aslData));
        String dataFieldName = ((AslColumnField)aslData.getSelect().getFirst()).getName(true);
        Field aggregateField = AqlSqlQueryBuilder.dataArrayAggregation(data, type).as(DSL.name((String)dataFieldName));
        SelectJoinStep from = DSL.select((SelectField)aggregateField).from((TableLike)data);
        List<Field> pKeyFields = type.getPkeyFields().stream().map(field -> {
            Field f = data.field((Field)field);
            from.where(FieldUtils.aliasedField(targetTable, aslData, field).eq(f));
            return f;
        }).toList();
        Condition[] conditions = isRoot ? additionalConditions : (Condition[])ArrayUtils.addFirst((Object[])additionalConditions, (Object)Objects.requireNonNull(data.field((Field)Tables.COMP_DATA.NUM)).between(FieldUtils.aliasedField(targetTable, aslData, Tables.COMP_DATA.NUM), FieldUtils.aliasedField(targetTable, aslData, Tables.COMP_DATA.NUM_CAP)));
        return from.where(conditions).groupBy(pKeyFields);
    }

    private static ArrayAggOrderByStep<Record2<String, JSONB>[]> dataArrayAggregation(Table<?> dataTable, AslStructureQuery.AslSourceRelation type) {
        Field valueField;
        Field keyField = dataTable.field((Field)Tables.COMP_DATA.ENTITY_IDX);
        Field dataField = dataTable.field((Field)Tables.COMP_DATA.DATA);
        if (type == AslStructureQuery.AslSourceRelation.FOLDER) {
            Field uuidsField = dataTable.field((Field)EhrFolderData.EHR_FOLDER_DATA.ITEM_UUIDS);
            valueField = DSL.case_().when(DSL.cardinality((Field)uuidsField).eq((Field)DSL.inline((int)0)), dataField).else_(AdditionalSQLFunctions.jsonb_set((Field)dataField, (Field)AdditionalSQLFunctions.array_to_jsonb((Field)uuidsField), (String[])new String[]{"IA"}));
        } else {
            valueField = dataField;
        }
        return DSL.arrayAgg((Field)DSL.field((SelectField)DSL.row((SelectField)keyField, (SelectField)valueField)));
    }

    static class AslQueryTables {
        private final Map<AslQuery, Table<?>> dataTables = new HashMap();
        private final Map<AslQuery, Table<?>> versionTables = new HashMap();

        private AslQueryTables() {
        }

        Table<?> getDataTable(AslQuery q) {
            return this.dataTables.get(q);
        }

        Table<?> getVersionTable(AslQuery q) {
            return this.versionTables.get(q);
        }

        public void put(AslQuery q, Table<?> dataTable, Table<?> versionTable) {
            this.dataTables.put(q, dataTable);
            this.versionTables.put(q, versionTable);
        }

        public void remove(AslStructureQuery aq) {
            this.dataTables.remove(aq);
            this.versionTables.remove(aq);
        }
    }
}

