/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.exception.IllegalAqlException;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.util.AdditionalSQLFunctions;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.AslRmTypeAndConcept;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslAndQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslCoalesceJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslDvOrderedValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFalseQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldFieldQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotNullQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslOrQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslProvidesJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslTrueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslAggregatingField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslConstantField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslFolderItemIdVirtualField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslRmPathField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslSubqueryField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslVirtualField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslDelegatingJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslFolderItemJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslPathFilterJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.sql.AqlSqlQueryBuilder;
import org.ehrbase.openehr.aqlengine.sql.FieldUtils;
import org.ehrbase.openehr.dbformat.RmAttributeAlias;
import org.ehrbase.openehr.dbformat.RmTypeAlias;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.Param;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.impl.DSL;

final class ConditionUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private ConditionUtils() {
    }

    public static Condition buildJoinCondition(AslJoin aslJoin, AqlSqlQueryBuilder.AslQueryTables aslQueryToTable) {
        return aslJoin.getOn().stream().map(jc -> {
            AslJoinCondition aslJoinCondition = jc;
            Objects.requireNonNull(aslJoinCondition);
            AslJoinCondition selector0$temp = aslJoinCondition;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslDelegatingJoinCondition.class, AslPathFilterJoinCondition.class, AslFolderItemJoinCondition.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    AslDelegatingJoinCondition desc = (AslDelegatingJoinCondition)selector0$temp;
                    yield ConditionUtils.delegatingJoinCondition(desc, aslQueryToTable);
                }
                case 1 -> {
                    AslPathFilterJoinCondition filterCondition = (AslPathFilterJoinCondition)selector0$temp;
                    yield ConditionUtils.buildCondition(filterCondition.getCondition(), aslQueryToTable, true);
                }
                case 2 -> {
                    AslFolderItemJoinCondition c = (AslFolderItemJoinCondition)selector0$temp;
                    yield ConditionUtils.joinFolderItemIdEqualVoIdCondition(c, aslQueryToTable.getDataTable(aslJoin.getLeft()), aslQueryToTable.getDataTable(aslJoin.getRight()));
                }
            };
        }).reduce(DSL.noCondition(), DSL::and);
    }

    private static Condition delegatingJoinCondition(AslDelegatingJoinCondition joinCondition, AqlSqlQueryBuilder.AslQueryTables aslQueryToTable) {
        AslProvidesJoinCondition aslProvidesJoinCondition = joinCondition.getDelegate();
        Objects.requireNonNull(aslProvidesJoinCondition);
        AslProvidesJoinCondition aslProvidesJoinCondition2 = aslProvidesJoinCondition;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslFieldFieldQueryCondition.class, AslCoalesceJoinCondition.class}, (Object)aslProvidesJoinCondition2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslFieldFieldQueryCondition ffc = (AslFieldFieldQueryCondition)aslProvidesJoinCondition2;
                yield ConditionUtils.fieldJoinCondition(ffc, aslQueryToTable);
            }
            case 1 -> {
                AslCoalesceJoinCondition cjc = (AslCoalesceJoinCondition)aslProvidesJoinCondition2;
                yield ConditionUtils.coalesceJoinCondition(cjc, aslQueryToTable);
            }
        };
    }

    private static Condition coalesceJoinCondition(AslCoalesceJoinCondition delegate, AqlSqlQueryBuilder.AslQueryTables aslQueryToTable) {
        return DSL.condition((Field)DSL.coalesce((Field)ConditionUtils.fieldJoinCondition(delegate.getTernaryCondition(), aslQueryToTable), (Field[])new Field[]{DSL.condition((Field)DSL.inline((boolean)delegate.getDefaultValue()))}));
    }

    private static Condition fieldJoinCondition(AslFieldFieldQueryCondition ic, AqlSqlQueryBuilder.AslQueryTables aslQueryToTable) {
        Field lf = ConditionUtils.getSqlField(aslQueryToTable, ic.getLeftField());
        Field rf = ConditionUtils.getSqlField(aslQueryToTable, ic.getRightField());
        return switch (ic.getOperator()) {
            default -> throw new MatchException(null, null);
            case AslQueryCondition.AslConditionOperator.LIKE -> lf.like(rf);
            case AslQueryCondition.AslConditionOperator.IN -> lf.in(new Field[]{rf});
            case AslQueryCondition.AslConditionOperator.EQ -> lf.eq(rf);
            case AslQueryCondition.AslConditionOperator.NEQ -> lf.ne(rf);
            case AslQueryCondition.AslConditionOperator.GT_EQ -> lf.ge(rf);
            case AslQueryCondition.AslConditionOperator.GT -> lf.gt(rf);
            case AslQueryCondition.AslConditionOperator.LT_EQ -> lf.le(rf);
            case AslQueryCondition.AslConditionOperator.LT -> lf.lt(rf);
            case AslQueryCondition.AslConditionOperator.IS_NULL -> lf.isNull();
            case AslQueryCondition.AslConditionOperator.IS_NOT_NULL -> lf.isNotNull();
        };
    }

    private static Field getSqlField(AqlSqlQueryBuilder.AslQueryTables aslQueryToTable, AslField leftField) {
        AslField aslField = leftField;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslColumnField.class, AslConstantField.class, AslSubqueryField.class, AslVirtualField.class}, (Object)aslField, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslColumnField cf = (AslColumnField)aslField;
                yield FieldUtils.field(aslQueryToTable.getDataTable(cf.getProvider()), cf, true);
            }
            case 1 -> {
                AslConstantField cf = (AslConstantField)aslField;
                yield DSL.inline(cf.getValue());
            }
            case 2 -> {
                AslSubqueryField __ = (AslSubqueryField)aslField;
                throw new IllegalArgumentException("AslFieldFieldQueryConditions using AslSubqueryFields are not supported");
            }
            case 3 -> {
                AslVirtualField __ = (AslVirtualField)aslField;
                throw new IllegalArgumentException("AslFieldFieldQueryConditions using AslVirtualFields are not supported");
            }
            case -1 -> null;
        };
    }

    public static Condition buildCondition(AslQueryCondition c, AqlSqlQueryBuilder.AslQueryTables tables, boolean useAliases) {
        AslQueryCondition aslQueryCondition = c;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslAndQueryCondition.class, AslOrQueryCondition.class, AslNotQueryCondition.class, AslFalseQueryCondition.class, AslTrueQueryCondition.class, AslNotNullQueryCondition.class, AslFieldValueQueryCondition.class, AslFieldFieldQueryCondition.class, AslCoalesceJoinCondition.class}, (Object)aslQueryCondition, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> DSL.noCondition();
            case 0 -> {
                AslAndQueryCondition and = (AslAndQueryCondition)aslQueryCondition;
                yield DSL.and(and.getOperands().stream().map(o -> ConditionUtils.buildCondition(o, tables, useAliases)).toList());
            }
            case 1 -> {
                AslOrQueryCondition or = (AslOrQueryCondition)aslQueryCondition;
                yield DSL.or(or.getOperands().stream().map(o -> ConditionUtils.buildCondition(o, tables, useAliases)).toList());
            }
            case 2 -> {
                AslNotQueryCondition not = (AslNotQueryCondition)aslQueryCondition;
                yield DSL.not((Condition)ConditionUtils.buildCondition(not.getCondition(), tables, useAliases));
            }
            case 3 -> {
                AslFalseQueryCondition __ = (AslFalseQueryCondition)aslQueryCondition;
                yield DSL.falseCondition();
            }
            case 4 -> {
                AslTrueQueryCondition __ = (AslTrueQueryCondition)aslQueryCondition;
                yield DSL.trueCondition();
            }
            case 5 -> {
                AslNotNullQueryCondition nn = (AslNotNullQueryCondition)aslQueryCondition;
                yield ConditionUtils.notNullCondition(tables, useAliases, nn);
            }
            case 6 -> {
                AslFieldValueQueryCondition fv = (AslFieldValueQueryCondition)aslQueryCondition;
                yield ConditionUtils.buildFieldValueCondition(tables, useAliases, fv);
            }
            case 7 -> {
                AslFieldFieldQueryCondition __ = (AslFieldFieldQueryCondition)aslQueryCondition;
                throw new IllegalArgumentException("AslFieldConditions are not supported in WHERE clauses");
            }
            case 8 -> {
                AslCoalesceJoinCondition __ = (AslCoalesceJoinCondition)aslQueryCondition;
                throw new IllegalArgumentException("AslCoalesceJoinConditions are not supported in WHERE clauses");
            }
        };
    }

    private static Condition notNullCondition(AqlSqlQueryBuilder.AslQueryTables tables, boolean useAliases, AslNotNullQueryCondition nn) {
        AslField field = nn.getField();
        if (field.getExtractedColumn() != null) {
            return DSL.trueCondition();
        }
        if (field instanceof AslColumnField) {
            AslColumnField f = (AslColumnField)field;
            return (f.isVersionTableField() ? tables.getVersionTable(field.getProvider()) : tables.getDataTable(field.getProvider())).field(f.getName(useAliases)).isNotNull();
        }
        throw new IllegalArgumentException("Unsupported field type: %s".formatted(field.getClass().getSimpleName()));
    }

    private static Condition buildFieldValueCondition(AqlSqlQueryBuilder.AslQueryTables tables, boolean useAliases, AslFieldValueQueryCondition fv) {
        AslField field = fv.getField();
        AslQuery internalProvider = field.getInternalProvider();
        Table<?> srcTable = tables.getDataTable(internalProvider);
        if (fv instanceof AslDvOrderedValueQueryCondition) {
            AslDvOrderedValueQueryCondition dvc = (AslDvOrderedValueQueryCondition)fv;
            Field<JSONB> sqlDvOrderedField = FieldUtils.buidDvOrderedField(useAliases, field, srcTable);
            Field sqlMagnitudeField = AdditionalSQLFunctions.jsonb_dv_ordered_magnitude(sqlDvOrderedField);
            Field sqlTypeField = DSL.jsonbGetAttributeAsText(sqlDvOrderedField, (Field)DSL.inline((String)RmAttributeAlias.getAlias((String)"_type")));
            List<String> types = dvc.getTypesToCompare().stream().map(RmTypeAlias::getAlias).toList();
            return ConditionUtils.applyOperator(AslQueryCondition.AslConditionOperator.IN, sqlTypeField, types).and(ConditionUtils.applyOperator(dvc.getOperator(), sqlMagnitudeField, dvc.getValues()));
        }
        AslField aslField = field;
        Objects.requireNonNull(aslField);
        AslField aslField2 = aslField;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslComplexExtractedColumnField.class, AslColumnField.class, AslConstantField.class, AslAggregatingField.class, AslSubqueryField.class, AslFolderItemIdVirtualField.class, AslRmPathField.class}, (Object)aslField2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslComplexExtractedColumnField ecf = (AslComplexExtractedColumnField)aslField2;
                yield ConditionUtils.complexExtractedColumnCondition(useAliases, fv, ecf, srcTable, tables.getVersionTable(internalProvider));
            }
            case 1 -> {
                AslColumnField f = (AslColumnField)aslField2;
                yield ConditionUtils.applyOperator(fv.getOperator(), FieldUtils.field(f.isVersionTableField() ? tables.getVersionTable(internalProvider) : srcTable, f, useAliases), fv.getValues());
            }
            case 2 -> {
                AslConstantField f = (AslConstantField)aslField2;
                yield ConditionUtils.applyOperator(fv.getOperator(), (Field)DSL.inline(f.getValue(), f.getType()), fv.getValues());
            }
            case 3 -> {
                AslAggregatingField __ = (AslAggregatingField)aslField2;
                throw new IllegalArgumentException("AslAggregatingField cannot be used in WHERE");
            }
            case 4 -> {
                AslSubqueryField __ = (AslSubqueryField)aslField2;
                throw new IllegalArgumentException("AslSubqueryField cannot be used in WHERE");
            }
            case 5 -> {
                AslFolderItemIdVirtualField __ = (AslFolderItemIdVirtualField)aslField2;
                throw new IllegalArgumentException("AslFolderItemIdValuesColumnField cannot be used in WHERE");
            }
            case 6 -> {
                AslRmPathField arpf = (AslRmPathField)aslField2;
                Field<JSONB> srcField = FieldUtils.field(Objects.requireNonNull(srcTable), arpf.getSrcField(), JSONB.class, useAliases);
                Field f = FieldUtils.buildJsonbPathField(arpf.getPathInJson(), false, srcField);
                yield ConditionUtils.applyOperator(fv.getOperator(), arpf.getType() == String.class ? DSL.jsonbGetElementAsText(f, (Field)DSL.inline((int)0)) : f, fv.getValues());
            }
        };
    }

    static Condition complexExtractedColumnCondition(boolean useAliases, AslFieldValueQueryCondition<?> fv, AslComplexExtractedColumnField ecf, Table<?> dataTable, Table<?> versionTable) {
        return switch (ecf.getExtractedColumn()) {
            default -> throw new MatchException(null, null);
            case AslExtractedColumn.VO_ID -> {
                switch (fv.getOperator()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case IS_NULL: 
                    case IS_NOT_NULL: {
                        yield ConditionUtils.voIdCondition(versionTable, useAliases, null, fv.getOperator(), ecf);
                    }
                    case IN: 
                    case EQ: {
                        yield ConditionUtils.voIdInCondition(versionTable, useAliases, fv.getValues(), true, ecf);
                    }
                    case NEQ: {
                        yield ConditionUtils.voIdInCondition(versionTable, useAliases, fv.getValues(), false, ecf);
                    }
                    case LIKE: 
                    case GT_EQ: 
                    case GT: 
                    case LT_EQ: 
                    case LT: 
                }
                yield ConditionUtils.voIdCondition(versionTable, useAliases, (String)fv.getValues().getFirst(), fv.getOperator(), ecf);
            }
            case AslExtractedColumn.ARCHETYPE_NODE_ID -> {
                AslQueryCondition.AslConditionOperator op = fv.getOperator() == AslQueryCondition.AslConditionOperator.IN ? AslQueryCondition.AslConditionOperator.EQ : fv.getOperator();
                yield fv.getValues().stream().map(AslRmTypeAndConcept.class::cast).map(p -> ConditionUtils.archetypeNodeIdCondition(dataTable, useAliases, ecf, p, op)).reduce(DSL.noCondition(), DSL::or);
            }
            case AslExtractedColumn.TEMPLATE_ID, AslExtractedColumn.NAME_VALUE, AslExtractedColumn.EHR_ID, AslExtractedColumn.ROOT_CONCEPT, AslExtractedColumn.OV_CONTRIBUTION_ID, AslExtractedColumn.OV_TIME_COMMITTED_DV, AslExtractedColumn.OV_TIME_COMMITTED, AslExtractedColumn.AD_SYSTEM_ID, AslExtractedColumn.AD_DESCRIPTION_DV, AslExtractedColumn.AD_DESCRIPTION_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_DV, AslExtractedColumn.AD_CHANGE_TYPE_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_CODE_STRING, AslExtractedColumn.AD_CHANGE_TYPE_PREFERRED_TERM, AslExtractedColumn.AD_CHANGE_TYPE_TERMINOLOGY_ID_VALUE, AslExtractedColumn.EHR_TIME_CREATED_DV, AslExtractedColumn.EHR_TIME_CREATED, AslExtractedColumn.EHR_SYSTEM_ID, AslExtractedColumn.EHR_SYSTEM_ID_DV -> throw new IllegalArgumentException("Extracted column %s is not complex".formatted(new Object[]{ecf.getExtractedColumn()}));
        };
    }

    private static Condition archetypeNodeIdCondition(Table<?> src, boolean aliasedNames, AslComplexExtractedColumnField ecf, AslRmTypeAndConcept rmTypeAndConcept, AslQueryCondition.AslConditionOperator op) {
        return Stream.of(Pair.of((Object)Tables.COMP_DATA.RM_ENTITY, (Object)rmTypeAndConcept.aliasedRmType()), Pair.of((Object)Tables.COMP_DATA.ENTITY_CONCEPT, (Object)rmTypeAndConcept.concept())).filter(p -> p.getValue() != null).map(p1 -> ConditionUtils.applyOperator(op, FieldUtils.field(src, ecf, ((TableField)p1.getKey()).getName(), aliasedNames), List.of((String)p1.getValue()))).reduce(DSL.noCondition(), op == AslQueryCondition.AslConditionOperator.NEQ ? DSL::or : DSL::and);
    }

    private static Condition voIdInCondition(Table<?> versionTable, boolean aliasedNames, List<String> ids, boolean notNegated, AslComplexExtractedColumnField field) {
        Condition uidVersionCond;
        if (ids.isEmpty()) {
            return notNegated ? DSL.falseCondition() : DSL.trueCondition();
        }
        if (ids.size() == 1) {
            return ConditionUtils.voIdCondition(versionTable, aliasedNames, ids.getFirst(), notNegated ? AslQueryCondition.AslConditionOperator.EQ : AslQueryCondition.AslConditionOperator.NEQ, field);
        }
        ArrayList uidList = null;
        ArrayList uidVersionList = null;
        for (String id : ids) {
            Pair<String, Integer> voId = ConditionUtils.parseVoId(id);
            Field<?> voIdValueField = ConditionUtils.createVoIdValue(voId);
            if (voId.getRight() == null) {
                if (uidList == null) {
                    uidList = new ArrayList(ids.size());
                }
                uidList.add(voIdValueField);
                continue;
            }
            if (uidVersionList == null) {
                uidVersionList = new ArrayList(ids.size());
            }
            uidVersionList.add(voIdValueField);
        }
        Field<?> uuidField = FieldUtils.field(versionTable, field, Tables.COMP_VERSION.VO_ID.getName(), aliasedNames);
        Condition uidCond = uidList == null ? null : uuidField.in(uidList);
        if (uidVersionList == null) {
            uidVersionCond = null;
        } else {
            Field<?> versionField = FieldUtils.field(versionTable, field, Tables.COMP_VERSION.SYS_VERSION.getName(), aliasedNames);
            uidVersionCond = DSL.field((SelectField)DSL.row(uuidField, versionField)).in(uidVersionList);
        }
        Condition cond = DSL.or((Condition)uidCond, uidVersionCond);
        if (notNegated) {
            return cond;
        }
        return cond.not();
    }

    private static Condition voIdCondition(Table<?> versionTable, boolean aliasedNames, String id, AslQueryCondition.AslConditionOperator op, AslComplexExtractedColumnField field) {
        Field left;
        Field uuidField = FieldUtils.field(versionTable, field, Tables.COMP_VERSION.VO_ID.getName(), aliasedNames);
        if (op == AslQueryCondition.AslConditionOperator.IS_NULL) {
            return uuidField.isNull();
        }
        if (op == AslQueryCondition.AslConditionOperator.IS_NOT_NULL) {
            return uuidField.isNotNull();
        }
        Pair<String, Integer> voId = ConditionUtils.parseVoId(id);
        if (voId.getRight() == null) {
            left = uuidField;
        } else {
            Field<?> versionField = FieldUtils.field(versionTable, field, Tables.COMP_VERSION.SYS_VERSION.getName(), aliasedNames);
            left = DSL.field((SelectField)DSL.row(uuidField, versionField));
        }
        Field<?> right = ConditionUtils.createVoIdValue(voId);
        return switch (op) {
            default -> throw new MatchException(null, null);
            case AslQueryCondition.AslConditionOperator.IN, AslQueryCondition.AslConditionOperator.EQ -> left.eq(right);
            case AslQueryCondition.AslConditionOperator.NEQ -> left.ne(right);
            case AslQueryCondition.AslConditionOperator.LT -> left.lt(right);
            case AslQueryCondition.AslConditionOperator.GT -> left.gt(right);
            case AslQueryCondition.AslConditionOperator.GT_EQ -> left.ge(right);
            case AslQueryCondition.AslConditionOperator.LT_EQ -> left.le(right);
            case AslQueryCondition.AslConditionOperator.LIKE, AslQueryCondition.AslConditionOperator.IS_NULL, AslQueryCondition.AslConditionOperator.IS_NOT_NULL -> throw new IllegalArgumentException();
        };
    }

    private static Pair<String, Integer> parseVoId(String id) {
        int uidEndPos = id.indexOf("::");
        if (uidEndPos < 0) {
            return Pair.of((Object)id, null);
        }
        int versionPos = id.indexOf("::", uidEndPos + 2);
        return Pair.of((Object)id.substring(0, uidEndPos), (Object)Integer.parseInt(id.substring(versionPos + 2)));
    }

    private static Field<?> createVoIdValue(Pair<String, Integer> voId) {
        Field uuidField = DSL.inline((String)((String)voId.getLeft())).cast(UUID.class);
        if (voId.getRight() == null) {
            return uuidField;
        }
        Param versionField = DSL.inline((Integer)((Integer)voId.getRight()));
        return DSL.field((SelectField)DSL.row((SelectField)uuidField, (SelectField)versionField));
    }

    private static Condition applyOperator(AslQueryCondition.AslConditionOperator operator, Field field, Collection<?> values) {
        boolean isUuidField;
        Class sqlFieldType = field.getType();
        boolean isJsonbField = JSONB.class.isAssignableFrom(sqlFieldType);
        boolean bl = isUuidField = !isJsonbField && UUID.class.isAssignableFrom(sqlFieldType);
        if (operator == AslQueryCondition.AslConditionOperator.LIKE) {
            String aslLikePattern = (String)values.stream().findFirst().orElseThrow();
            String aqlLikePattern = isJsonbField ? ConditionUtils.translateAqlLikePatternToJsonSql(aslLikePattern) : ConditionUtils.translateAqlLikePatternToSql(aslLikePattern);
            return field.cast(String.class).like((Field)DSL.inline((String)aqlLikePattern));
        }
        if (operator == AslQueryCondition.AslConditionOperator.IS_NULL) {
            return field.isNull();
        }
        if (operator == AslQueryCondition.AslConditionOperator.IS_NOT_NULL) {
            return field.isNotNull();
        }
        boolean orderOperator = EnumSet.of(AslQueryCondition.AslConditionOperator.GT_EQ, AslQueryCondition.AslConditionOperator.GT, AslQueryCondition.AslConditionOperator.LT_EQ, AslQueryCondition.AslConditionOperator.LT).contains((Object)operator);
        List<Object> filteredValues = values.stream().map(v -> {
            Object value;
            if (isUuidField && v instanceof String) {
                UUID uuid;
                String s = (String)v;
                try {
                    uuid = UUID.fromString(s);
                }
                catch (IllegalArgumentException e) {
                    uuid = null;
                }
                value = uuid;
            } else {
                value = isJsonbField || orderOperator || sqlFieldType.isInstance(v) || Number.class.isAssignableFrom(sqlFieldType) && v instanceof Number ? v : null;
            }
            return value;
        }).filter(Objects::nonNull).toList();
        return switch (filteredValues.size()) {
            case 0 -> {
                switch (operator) {
                    case IN: 
                    case EQ: {
                        yield DSL.falseCondition();
                    }
                    case NEQ: {
                        yield DSL.trueCondition();
                    }
                    case GT_EQ: 
                    case GT: 
                    case LT_EQ: 
                    case LT: {
                        throw new IllegalArgumentException("%s-Condition needs one value, not 0".formatted(new Object[]{operator}));
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)operator));
            }
            case 1 -> {
                Object val = filteredValues.getFirst();
                boolean valueAndFieldTypeCompatible = sqlFieldType.isInstance(val) || Number.class.isAssignableFrom(sqlFieldType) && val instanceof Number;
                Field wrappedValue = isJsonbField || orderOperator && !valueAndFieldTypeCompatible ? AdditionalSQLFunctions.to_jsonb((Object)val) : DSL.inline((Object)val);
                Field wrappedField = !isJsonbField && orderOperator && !valueAndFieldTypeCompatible ? AdditionalSQLFunctions.to_jsonb((Field)field) : field;
                switch (operator) {
                    case IN: 
                    case EQ: {
                        yield field.eq(wrappedValue);
                    }
                    case NEQ: {
                        yield field.ne(wrappedValue);
                    }
                    case GT_EQ: {
                        yield wrappedField.ge(wrappedValue);
                    }
                    case GT: {
                        yield wrappedField.gt(wrappedValue);
                    }
                    case LT_EQ: {
                        yield wrappedField.le(wrappedValue);
                    }
                    case LT: {
                        yield wrappedField.lt(wrappedValue);
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)operator));
            }
            default -> {
                switch (operator) {
                    case IN: {
                        yield field.in(filteredValues.stream().map(v -> isJsonbField ? AdditionalSQLFunctions.to_jsonb((Object)v) : DSL.inline((Object)v)).toList());
                    }
                    case EQ: 
                    case NEQ: 
                    case GT_EQ: 
                    case GT: 
                    case LT_EQ: 
                    case LT: {
                        throw new IllegalArgumentException("%s-Condition needs one value, not %d".formatted(new Object[]{operator, filteredValues.size()}));
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)operator));
            }
        };
    }

    public static String translateAqlLikePatternToSql(String aqlLike) {
        StringBuilder sb = new StringBuilder(aqlLike.length());
        int l = aqlLike.length();
        block10: for (int pos = 0; pos < l; ++pos) {
            char c = aqlLike.charAt(pos);
            switch (c) {
                case '%': 
                case '_': {
                    sb.append('\\').append(c);
                    continue block10;
                }
                case '\\': {
                    if (++pos >= l) {
                        throw new IllegalAqlException("Invalid LIKE pattern: %s".formatted(aqlLike));
                    }
                    char next = aqlLike.charAt(pos);
                    switch (next) {
                        case '*': 
                        case '?': {
                            sb.append(next);
                            continue block10;
                        }
                        case '\\': {
                            sb.append("\\\\");
                            continue block10;
                        }
                    }
                    throw new IllegalAqlException("Invalid LIKE pattern: %s".formatted(aqlLike));
                }
                case '?': {
                    sb.append('_');
                    continue block10;
                }
                case '*': {
                    sb.append('%');
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String translateAqlLikePatternToJsonSql(String aqlLike) {
        String jsonLike = ConditionUtils.escapeAsJsonString(aqlLike);
        StringBuilder sb = new StringBuilder(jsonLike.length());
        sb.append('\"');
        int l = jsonLike.length() - 1;
        block10: for (int pos = 1; pos < l; ++pos) {
            char c0 = jsonLike.charAt(pos);
            switch (c0) {
                case '%': 
                case '_': {
                    sb.append("\\").append(c0);
                    continue block10;
                }
                case '\\': {
                    if (++pos >= l) {
                        throw new IllegalAqlException("Invalid LIKE pattern: %s".formatted(aqlLike));
                    }
                    char c1 = jsonLike.charAt(pos);
                    if (c1 != '\\') {
                        sb.append("\\\\").append(c1);
                        continue block10;
                    }
                    char c2 = jsonLike.charAt(++pos);
                    switch (c2) {
                        case '*': 
                        case '?': {
                            sb.append(c2);
                            continue block10;
                        }
                        case '\\': {
                            if (++pos >= l || jsonLike.charAt(pos) != '\\') {
                                throw new IllegalAqlException("Invalid LIKE pattern: %s".formatted(aqlLike));
                            }
                            sb.append("\\\\\\\\");
                            continue block10;
                        }
                    }
                    throw new IllegalAqlException("Invalid LIKE pattern: %s".formatted(aqlLike));
                }
                case '?': {
                    sb.append('_');
                    continue block10;
                }
                case '*': {
                    sb.append('%');
                    continue block10;
                }
                default: {
                    sb.append(c0);
                }
            }
        }
        sb.append('_');
        return sb.toString();
    }

    private static Condition joinFolderItemIdEqualVoIdCondition(AslFolderItemJoinCondition dc, Table<?> sqlLeft, Table<?> sqlRight) {
        AslQuery leftOwner = dc.getLeftOwner();
        AslQuery rightProvider = dc.rightProvider();
        AslQuery rightOwner = dc.getRightOwner();
        AslFolderItemIdVirtualField column = leftOwner.getSelect().stream().filter(AslFolderItemIdVirtualField.class::isInstance).map(AslFolderItemIdVirtualField.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("AslFolderItemJoinCondition requires an AslFolderItemIdValuesColumnField"));
        return FieldUtils.field(sqlRight, rightProvider, rightOwner, AslStructureColumn.VO_ID.getFieldName(), UUID.class, true).eq(FieldUtils.field(sqlLeft, column, column.getFieldName(), UUID.class, true));
    }

    static String escapeAsJsonString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)string);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException(e.getMessage(), (IOException)((Object)e));
        }
    }
}

