/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.openehr.aqlengine.asl.AslFromCreator;
import org.ehrbase.openehr.aqlengine.asl.AslUtils;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.jooq.JoinType;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class AslFromCreatorTest {
    private final KnowledgeCacheService mockKnowledgeCacheService = (KnowledgeCacheService)Mockito.mock((Object[])new KnowledgeCacheService[0]);

    AslFromCreatorTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.reset((Object[])new KnowledgeCacheService[]{this.mockKnowledgeCacheService});
    }

    private AslRootQuery addFromClause(String aql) {
        AslUtils.AliasProvider aliasProvider = new AslUtils.AliasProvider();
        AslRootQuery aslQuery = new AslRootQuery();
        AqlQuery aqlQuery = AqlQueryParser.parse((String)aql);
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery, (boolean)false);
        AslFromCreator aslFromCreator = new AslFromCreator(aliasProvider, this.mockKnowledgeCacheService, true);
        aslFromCreator.addFromClause(aslQuery, queryWrapper);
        return aslQuery;
    }

    private static ThrowingConsumer<Pair<AslQuery, AslJoin>> isStructureQueryRootWithVersion(AslStructureQuery.AslSourceRelation type) {
        return pair -> {
            Assertions.assertThat((Object)((AslQuery)pair.getKey())).isInstanceOfSatisfying(AslStructureQuery.class, sq -> {
                Assertions.assertThat((Comparable)sq.getType()).isSameAs((Object)type);
                Assertions.assertThat((boolean)sq.isRequiresVersionTableJoin()).isTrue();
                Assertions.assertThat((Object)sq.getCondition()).isNull();
            });
            Assertions.assertThat((Object)((AslJoin)pair.getValue())).isNull();
        };
    }

    @Nested
    class Folder {
        Folder() {
        }

        @Test
        void simple() {
            AslRootQuery aslQuery = AslFromCreatorTest.this.addFromClause("SELECT f/uid/value\nFROM FOLDER f\n");
            ((ObjectAssert)Assertions.assertThat((List)aslQuery.getChildren()).singleElement()).satisfies(new ThrowingConsumer[]{Folder.isStructureQueryRootWithVersionOnFolder()});
        }

        @Test
        void containsFolder() {
            AslRootQuery aslQuery = AslFromCreatorTest.this.addFromClause("SELECT f1/uid/value, f2/uid/value\nFROM FOLDER f1 CONTAINS FOLDER f2\n");
            Assertions.assertThat((List)aslQuery.getChildren()).hasSize(2);
            ((ObjectAssert)Assertions.assertThat((List)aslQuery.getChildren()).element(0)).satisfies(new ThrowingConsumer[]{Folder.isStructureQueryRootWithVersionOnFolder()});
            ((ObjectAssert)Assertions.assertThat((List)aslQuery.getChildren()).element(1)).satisfies(new ThrowingConsumer[]{Folder.isStructureQueryWithDataContains(AslStructureQuery.AslSourceRelation.FOLDER, AslStructureQuery.AslSourceRelation.FOLDER, false)});
        }

        @Test
        void containsComposition() {
            AslRootQuery aslQuery = AslFromCreatorTest.this.addFromClause("SELECT c/uid/value\nFROM FOLDER CONTAINS COMPOSITION c\n");
            Assertions.assertThat((List)aslQuery.getChildren()).hasSize(2);
            ((ObjectAssert)Assertions.assertThat((List)aslQuery.getChildren()).element(0)).satisfies(new ThrowingConsumer[]{Folder.isStructureQueryRootWithVersionOnFolder()});
            ((ObjectAssert)Assertions.assertThat((List)aslQuery.getChildren()).element(1)).satisfies(new ThrowingConsumer[]{Folder.isStructureQueryWithDataContains(AslStructureQuery.AslSourceRelation.FOLDER, AslStructureQuery.AslSourceRelation.COMPOSITION, true)});
        }

        @Test
        void containsFolderContainsComposition() {
            AslRootQuery aslQuery = AslFromCreatorTest.this.addFromClause("SELECT c/uid/value\nFROM FOLDER CONTAINS FOLDER f2[openEHR-EHR-FOLDER.episode_of_care.v1] CONTAINS COMPOSITION c\n");
            Assertions.assertThat((List)aslQuery.getChildren()).hasSize(3);
            ((ObjectAssert)Assertions.assertThat((List)aslQuery.getChildren()).element(0)).satisfies(new ThrowingConsumer[]{Folder.isStructureQueryRootWithVersionOnFolder()});
            ((ObjectAssert)Assertions.assertThat((List)aslQuery.getChildren()).element(1)).satisfies(new ThrowingConsumer[]{Folder.isStructureQueryWithDataContains(AslStructureQuery.AslSourceRelation.FOLDER, AslStructureQuery.AslSourceRelation.FOLDER, false)});
            ((ObjectAssert)Assertions.assertThat((List)aslQuery.getChildren()).element(2)).satisfies(new ThrowingConsumer[]{Folder.isStructureQueryWithDataContains(AslStructureQuery.AslSourceRelation.FOLDER, AslStructureQuery.AslSourceRelation.COMPOSITION, true)});
        }

        private static ThrowingConsumer<Pair<AslQuery, AslJoin>> isStructureQueryRootWithVersionOnFolder() {
            return AslFromCreatorTest.isStructureQueryRootWithVersion(AslStructureQuery.AslSourceRelation.FOLDER);
        }

        private static ThrowingConsumer<Pair<AslQuery, AslJoin>> isStructureQueryWithDataContains(AslStructureQuery.AslSourceRelation leftType, AslStructureQuery.AslSourceRelation rightType, boolean requiresVersionJoin) {
            return pair -> {
                ((ObjectAssert)Assertions.assertThat((Object)((AslJoin)pair.getValue())).isNotNull()).satisfies(new ThrowingConsumer[]{join -> {
                    Assertions.assertThat((Comparable)join.getJoinType()).isSameAs((Object)JoinType.JOIN);
                    Assertions.assertThat((Object)join.getLeft()).isInstanceOfSatisfying(AslStructureQuery.class, left -> Assertions.assertThat((Comparable)left.getType()).isSameAs((Object)leftType));
                    Assertions.assertThat((Object)join.getRight()).isInstanceOfSatisfying(AslStructureQuery.class, right -> Assertions.assertThat((Comparable)right.getType()).isSameAs((Object)rightType));
                }});
                Assertions.assertThat((Object)((AslQuery)pair.getKey())).isInstanceOfSatisfying(AslStructureQuery.class, sq -> {
                    Assertions.assertThat((Comparable)sq.getType()).isSameAs((Object)rightType);
                    Assertions.assertThat((boolean)sq.isRequiresVersionTableJoin()).isEqualTo(requiresVersionJoin);
                });
            };
        }
    }
}

