/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.openehr.aqlengine.TestAqlQueryContext;
import org.ehrbase.openehr.aqlengine.asl.AqlSqlLayer;
import org.ehrbase.openehr.aqlengine.asl.AslCleanupPostProcessor;
import org.ehrbase.openehr.aqlengine.asl.AslGraph;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class AslGraphTest {
    private final KnowledgeCacheService mockKnowledgeCacheService = (KnowledgeCacheService)Mockito.mock((Object[])new KnowledgeCacheService[0]);

    AslGraphTest() {
    }

    @Test
    @Disabled
    void printDataQueryGraph() {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)"SELECT\n  -- c1/content[openEHR-EHR-SECTION.adhoc.v1],\n  -- c1/content[openEHR-EHR-SECTION.adhoc.v1]/name,\n  c1/content[openEHR-EHR-SECTION.adhoc.v1]/name/value\n  -- ,c1/content[openEHR-EHR-SECTION.adhoc.v1,'Diagnostic Results']/name/value\nFROM EHR e\n  CONTAINS COMPOSITION c1\n");
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery, (boolean)false);
        AslRootQuery rootQuery = new AqlSqlLayer(this.mockKnowledgeCacheService, () -> "node", (AqlQueryContext)new TestAqlQueryContext()).buildAslRootQuery(queryWrapper);
        System.out.println(AslGraph.createAslGraph(rootQuery));
    }

    @Test
    void stableAslGraphTest() {
        List<String> variants = IntStream.range(0, 100).parallel().mapToObj(i -> this.createSampleGraph()).distinct().toList();
        Assertions.assertThat(variants).hasSize(1);
    }

    private String createSampleGraph() {
        AqlQuery sampleAqlQuery = AqlQueryParser.parse((String)"SELECT\nc/uid/value AS compositionID,\nc/context/start_time AS startTime,\nsample/items[at0002]/value/value,\nc/feeder_audit,\nxds/items[at0003]/value,\nc/content[openEHR-EHR-SECTION.problem_list.v0]/items[openEHR-EHR-EVALUATION.problem_diagnosis.v1]/data[at0001]/items[at0002]/value,\nsample/items[at0007]/items[at0016]/value,\nxds/items[at0010]/value/value,\nsample/items[at0023]/value/value,\nsample/items[at0007]/items[at0014]/value,\nsample/items[at0007]/items[at0015]/value,\nc/content[openEHR-EHR-SECTION.conclusion.v0]/items[openEHR-EHR-EVALUATION.clinical_synopsis.v1]/data[at0001]/items[at0002]/value/value,\no/data[at0001]/events[at0002]/data[at0003]/items[at0101]/value/value,\no/data[at0001]/events[at0002]/data[at0003]/items[openEHR-EHR-CLUSTER.laboratory_test_analyte.v1]/items[at0024]/value,\no/data[at0001]/events[at0002]/data[at0003]/items[openEHR-EHR-CLUSTER.laboratory_test_analyte.v1]/items[at0001]/value,\no/data[at0001]/events[at0002]/data[at0003]/items[openEHR-EHR-CLUSTER.specimen.v1]/items[at0015]/value/value\nFROM EHR e[ehr_id/value='87a474c0-ce8d-4f6f-b999-20b2f1842e47']\nCONTAINS COMPOSITION c[openEHR-EHR-COMPOSITION.report-result.v1]\nCONTAINS (\nCLUSTER sample[openEHR-EHR-CLUSTER.sample.v0]\nAND\nCLUSTER xds[openEHR-EHR-CLUSTER.xds_metadata.v0]\nAND\nOBSERVATION o[openEHR-EHR-OBSERVATION.laboratory_test_result.v1]\n)\nWHERE\no/data[at0001]/events[at0002]/data[at0003]/items[openEHR-EHR-CLUSTER.laboratory_test_analyte.v1]/items[at0024]/value/defining_code/code_string='123'\nORDER BY o/data[at0001]/events[at0002]/data[at0003]/items[openEHR-EHR-CLUSTER.specimen.v1]/items[at0015]/value DESC\n");
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)sampleAqlQuery, (boolean)false);
        AslRootQuery rootQuery = new AqlSqlLayer(this.mockKnowledgeCacheService, () -> "node", (AqlQueryContext)new TestAqlQueryContext()).buildAslRootQuery(queryWrapper);
        new AslCleanupPostProcessor().afterBuildAsl(rootQuery, sampleAqlQuery, queryWrapper, null);
        return AslGraph.createAslGraph(rootQuery);
    }
}

