/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.aql;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.dto.AqlQueryRequest;
import org.ehrbase.openehr.aqlengine.aql.AqlQueryParsingPostProcessor;
import org.ehrbase.openehr.aqlengine.aql.model.ListPredicateOperand;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorSymbol;
import org.ehrbase.openehr.sdk.aql.dto.condition.LogicalOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.MatchesCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.WhereCondition;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.operand.Operand;
import org.ehrbase.openehr.sdk.aql.dto.operand.PathPredicateOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.springframework.stereotype.Component;

@Component
public class AqlConditionAsPredicatePostProcessor
implements AqlQueryParsingPostProcessor {
    private static final Set<AslExtractedColumn> SUPPORTED_EXCTRACTED_COLUMNS = EnumSet.of(AslExtractedColumn.EHR_ID, AslExtractedColumn.VO_ID, AslExtractedColumn.ARCHETYPE_NODE_ID, AslExtractedColumn.ROOT_CONCEPT, AslExtractedColumn.TEMPLATE_ID);

    @Override
    public void afterParseAql(AqlQuery aqlQuery, AqlQueryRequest request, AqlQueryContext ctx) {
        aqlQuery.setWhere(this.moveConditions(aqlQuery.getWhere()));
    }

    /*
     * Enabled aggressive block sorting
     */
    private WhereCondition moveConditions(WhereCondition where) {
        WhereCondition whereCondition;
        WhereCondition whereCondition2 = where;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ComparisonOperatorCondition.class, LogicalOperatorCondition.class, MatchesCondition.class}, (Object)whereCondition2, n)) {
                case 0: {
                    Operand operand;
                    ComparisonOperatorCondition c = (ComparisonOperatorCondition)whereCondition2;
                    if (c.getSymbol() == ComparisonOperatorSymbol.EQ && (operand = c.getValue()) instanceof PathPredicateOperand) {
                        ContainmentClassExpression cce;
                        IdentifiedPath ip;
                        PathPredicateOperand val = (PathPredicateOperand)operand;
                        operand = c.getStatement();
                        if (operand instanceof IdentifiedPath && (operand = (ip = (IdentifiedPath)operand).getRoot()) instanceof ContainmentClassExpression && this.isSupported(ip, cce = (ContainmentClassExpression)operand)) {
                            this.addPredicate(ip, cce, val);
                            return null;
                        }
                    }
                    n = 1;
                    continue block5;
                }
                case 1: {
                    LogicalOperatorCondition c = (LogicalOperatorCondition)whereCondition2;
                    if (c.getSymbol() != LogicalOperatorCondition.ConditionLogicalOperatorSymbol.AND || !CollectionUtils.isNotEmpty((Collection)c.getValues())) {
                        n = 2;
                        continue block5;
                    }
                    List values = c.getValues();
                    int i = 0;
                    while (true) {
                        if (i >= values.size()) {
                            whereCondition = c;
                            return whereCondition;
                        }
                        WhereCondition condition = (WhereCondition)values.get(i);
                        if (this.moveConditions(condition) == null) {
                            values.remove(i--);
                        }
                        ++i;
                    }
                }
                case 2: {
                    ContainmentClassExpression cce;
                    IdentifiedPath ip;
                    MatchesCondition c = (MatchesCondition)whereCondition2;
                    IdentifiedPath identifiedPath = c.getStatement();
                    if (identifiedPath instanceof IdentifiedPath && (identifiedPath = (ip = identifiedPath).getRoot()) instanceof ContainmentClassExpression && this.isSupported(ip, cce = (ContainmentClassExpression)identifiedPath)) {
                        ListPredicateOperand<Primitive> val = new ListPredicateOperand<Primitive>(c.getValues().stream().filter(Primitive.class::isInstance).map(Primitive.class::cast).toList());
                        this.addPredicate(ip, cce, val);
                        return null;
                    }
                    n = 3;
                    continue block5;
                }
            }
            break;
        }
        whereCondition = where;
        return whereCondition;
    }

    private boolean isSupported(IdentifiedPath ip, ContainmentClassExpression cce) {
        return AslExtractedColumn.find(cce.getType(), ip.getPath()).filter(SUPPORTED_EXCTRACTED_COLUMNS::contains).isPresent();
    }

    private void addPredicate(IdentifiedPath ip, ContainmentClassExpression cce, PathPredicateOperand<?> val) {
        ComparisonOperatorPredicate predicate = new ComparisonOperatorPredicate(ip.getPath(), ComparisonOperatorPredicate.PredicateComparisonOperator.EQ, val);
        if (CollectionUtils.isEmpty((Collection)cce.getPredicates())) {
            ArrayList<AndOperatorPredicate> predicates = new ArrayList<AndOperatorPredicate>();
            AndOperatorPredicate andOperatorPredicate2 = new AndOperatorPredicate(new ArrayList());
            andOperatorPredicate2.getOperands().add(predicate);
            predicates.add(andOperatorPredicate2);
            cce.setPredicates(predicates);
        } else {
            cce.getPredicates().forEach(andOperatorPredicate -> andOperatorPredicate.getOperands().add(predicate));
        }
    }

    public int getOrder() {
        return 2000;
    }
}

