/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.aql;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.dto.AqlQueryRequest;
import org.ehrbase.api.exception.AqlFeatureNotImplementedException;
import org.ehrbase.openehr.aqlengine.aql.AqlQueryParsingPostProcessor;
import org.ehrbase.openehr.aqlengine.aql.AqlQueryUtils;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.Containment;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperatorSymbol;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.util.AqlUtil;
import org.springframework.stereotype.Component;

@Component
public class AqlEhrPathPostProcessor
implements AqlQueryParsingPostProcessor {
    @Override
    public void afterParseAql(AqlQuery aqlQuery, AqlQueryRequest request, AqlQueryContext ctx) {
        AqlEhrPathPostProcessor.replaceEhrPaths(aqlQuery);
    }

    public int getOrder() {
        return -1000;
    }

    static void replaceEhrPaths(AqlQuery aqlQuery) {
        AqlEhrPathPostProcessor.replaceEhrPath(aqlQuery, "ehr_status", "EHR_STATUS", "s");
    }

    static void replaceEhrPath(AqlQuery aqlQuery, String ehrPath, String type, String aliasPrefix) {
        List<IdentifiedPath> ehrPaths = AqlQueryUtils.allIdentifiedPaths(aqlQuery).filter(ip -> {
            ContainmentClassExpression cce;
            AbstractContainmentExpression patt0$temp = ip.getRoot();
            return patt0$temp instanceof ContainmentClassExpression && (cce = (ContainmentClassExpression)patt0$temp).getType().equals("EHR");
        }).filter(ip -> Optional.of(ip).map(IdentifiedPath::getPath).map(AqlObjectPath::getPathNodes).map(List::getFirst).map(AqlObjectPath.PathNode::getAttribute).filter(ehrPath::equals).isPresent()).toList();
        if (ehrPaths.isEmpty()) {
            return;
        }
        if (ehrPaths.stream().map(IdentifiedPath::getRoot).map(AbstractContainmentExpression::getIdentifier).distinct().count() > 1L) {
            throw new AqlFeatureNotImplementedException("Multiple EHR in FROM are not supported");
        }
        if (ehrPaths.stream().map(IdentifiedPath::getRootPredicate).anyMatch(CollectionUtils::isNotEmpty)) {
            throw new AqlFeatureNotImplementedException("Root predicates for EHR/%s are not supported".formatted(ehrPath));
        }
        if (ehrPaths.stream().map(IdentifiedPath::getPath).map(p -> ((AqlObjectPath.PathNode)p.getPathNodes().getFirst()).getPredicateOrOperands()).distinct().count() > 1L) {
            throw new AqlFeatureNotImplementedException("Specifying different predicates for EHR/%s is not supported".formatted(ehrPath));
        }
        String alias = AqlUtil.streamContainments((Containment)aqlQuery.getFrom()).map(AbstractContainmentExpression::getIdentifier).filter(Objects::nonNull).filter(s -> s.matches(Pattern.quote(aliasPrefix) + "\\d*")).map(s -> aliasPrefix.equals(s) ? 0L : Long.parseLong(s.substring(1))).max(Comparator.naturalOrder()).map(i -> aliasPrefix + (i + 1L)).orElse(aliasPrefix);
        ContainmentClassExpression ehrContainment = (ContainmentClassExpression)ehrPaths.getFirst().getRoot();
        ContainmentClassExpression ehrStatusContainment = new ContainmentClassExpression();
        ehrStatusContainment.setType(type);
        ehrStatusContainment.setIdentifier(alias);
        ehrPaths.stream().findFirst().map(IdentifiedPath::getPath).map(p -> ((AqlObjectPath.PathNode)p.getPathNodes().getFirst()).getPredicateOrOperands()).ifPresent(arg_0 -> ((ContainmentClassExpression)ehrStatusContainment).setPredicates(arg_0));
        if (ehrContainment.getContains() == null) {
            ehrContainment.setContains((Containment)ehrStatusContainment);
        } else {
            ContainmentSetOperator cse;
            Containment containment = ehrContainment.getContains();
            if (containment instanceof ContainmentSetOperator && (cse = (ContainmentSetOperator)containment).getSymbol() == ContainmentSetOperatorSymbol.AND) {
                cse.setValues(Stream.concat(Stream.of(ehrStatusContainment), cse.getValues().stream()).toList());
            } else {
                ContainmentSetOperator and = new ContainmentSetOperator();
                and.setSymbol(ContainmentSetOperatorSymbol.AND);
                and.setValues(List.of(ehrStatusContainment, ehrContainment.getContains()));
                ehrContainment.setContains((Containment)and);
            }
        }
        ehrPaths.forEach(ip -> {
            ip.setRoot((AbstractContainmentExpression)ehrStatusContainment);
            List pathNodes = ip.getPath().getPathNodes();
            ip.setPath(pathNodes.size() == 1 ? null : new AqlObjectPath(pathNodes.subList(1, pathNodes.size())));
        });
    }
}

