/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.aql;

import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.dto.AqlQueryRequest;
import org.ehrbase.openehr.aqlengine.aql.AqlQueryParsingPostProcessor;
import org.ehrbase.openehr.aqlengine.aql.AqlQueryUtils;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.containment.Containment;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.springframework.stereotype.Component;

@Component
public class AqlFromEhrOptimisationPostProcessor
implements AqlQueryParsingPostProcessor {
    public int getOrder() {
        return 1000;
    }

    @Override
    public void afterParseAql(AqlQuery aqlQuery, AqlQueryRequest request, AqlQueryContext ctx) {
        ContainmentClassExpression containment;
        Containment containment2 = aqlQuery.getFrom();
        if (containment2 instanceof ContainmentClassExpression && "EHR".equals((containment = (ContainmentClassExpression)containment2).getType()) && (containment2 = containment.getContains()) instanceof ContainmentClassExpression) {
            ContainmentClassExpression childContainment = (ContainmentClassExpression)containment2;
            if (!AqlFromEhrOptimisationPostProcessor.isReferenced(containment, aqlQuery)) {
                aqlQuery.setFrom((Containment)childContainment);
            }
        }
    }

    protected static boolean isReferenced(ContainmentClassExpression containment, AqlQuery aqlQuery) {
        if (containment.getPredicates() != null) {
            return true;
        }
        String identifier = containment.getIdentifier();
        if (identifier == null) {
            return false;
        }
        return AqlQueryUtils.allIdentifiedPaths(aqlQuery).anyMatch(p -> p.getRoot().equals((Object)containment));
    }
}

