/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.aql;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.ExistsCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LikeCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LogicalOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.MatchesCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.NotCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.WhereCondition;
import org.ehrbase.openehr.sdk.aql.dto.operand.AggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.ColumnExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.ComparisonLeftOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.operand.Operand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.QueryParameter;
import org.ehrbase.openehr.sdk.aql.dto.operand.SingleRowFunction;
import org.ehrbase.openehr.sdk.aql.dto.orderby.OrderByExpression;
import org.ehrbase.openehr.sdk.aql.dto.select.SelectExpression;

public final class AqlQueryUtils {
    private AqlQueryUtils() {
    }

    public static Stream<IdentifiedPath> allIdentifiedPaths(AqlQuery query) {
        return Stream.of(query.getSelect().getStatement().stream().flatMap(AqlQueryUtils::allIdentifiedPaths), AqlQueryUtils.streamWhereConditions(query.getWhere()).flatMap(AqlQueryUtils::allIdentifiedPaths), Optional.of(query).map(AqlQuery::getOrderBy).stream().flatMap(Collection::stream).map(OrderByExpression::getStatement)).flatMap(s -> s);
    }

    public static Stream<IdentifiedPath> allIdentifiedPaths(WhereCondition w) {
        if (w instanceof ComparisonOperatorCondition) {
            ComparisonOperatorCondition c = (ComparisonOperatorCondition)w;
            return Stream.concat(AqlQueryUtils.allIdentifiedPaths(c.getStatement()), AqlQueryUtils.allIdentifiedPaths(c.getValue()));
        }
        if (w instanceof MatchesCondition) {
            MatchesCondition c = (MatchesCondition)w;
            return Stream.of(c.getStatement());
        }
        if (w instanceof LikeCondition) {
            LikeCondition c = (LikeCondition)w;
            return Stream.of(c.getStatement());
        }
        if (w instanceof ExistsCondition) {
            ExistsCondition c = (ExistsCondition)w;
            return Stream.of(c.getValue());
        }
        throw new IllegalArgumentException("Unsupported type of " + String.valueOf(w));
    }

    public static Stream<IdentifiedPath> allIdentifiedPaths(SelectExpression selectExpression) {
        ColumnExpression columnExpression = selectExpression.getColumnExpression();
        if (columnExpression instanceof Primitive) {
            return Stream.empty();
        }
        if (columnExpression instanceof AggregateFunction) {
            AggregateFunction f = (AggregateFunction)columnExpression;
            return Optional.of(f).map(AggregateFunction::getIdentifiedPath).stream();
        }
        if (columnExpression instanceof IdentifiedPath) {
            IdentifiedPath ip = (IdentifiedPath)columnExpression;
            return Stream.of(ip);
        }
        if (columnExpression instanceof SingleRowFunction) {
            SingleRowFunction f = (SingleRowFunction)columnExpression;
            return f.getOperandList().stream().flatMap(AqlQueryUtils::allIdentifiedPaths);
        }
        throw new IllegalArgumentException("Unsupported type of " + String.valueOf(columnExpression));
    }

    public static Stream<IdentifiedPath> allIdentifiedPaths(Operand operand) {
        if (operand instanceof Primitive) {
            return Stream.empty();
        }
        if (operand instanceof QueryParameter) {
            return Stream.empty();
        }
        if (operand instanceof IdentifiedPath) {
            IdentifiedPath ip = (IdentifiedPath)operand;
            return Stream.of(ip);
        }
        if (operand instanceof SingleRowFunction) {
            SingleRowFunction f = (SingleRowFunction)operand;
            return f.getOperandList().stream().flatMap(AqlQueryUtils::allIdentifiedPaths);
        }
        throw new IllegalArgumentException("Unsupported type of " + String.valueOf(operand));
    }

    public static Stream<IdentifiedPath> allIdentifiedPaths(ComparisonLeftOperand operand) {
        if (operand instanceof IdentifiedPath) {
            IdentifiedPath ip = (IdentifiedPath)operand;
            return Stream.of(ip);
        }
        if (operand instanceof SingleRowFunction) {
            SingleRowFunction f = (SingleRowFunction)operand;
            return f.getOperandList().stream().flatMap(AqlQueryUtils::allIdentifiedPaths);
        }
        throw new IllegalArgumentException("Unsupported type of " + String.valueOf(operand));
    }

    public static Stream<WhereCondition> streamWhereConditions(WhereCondition condition) {
        if (condition == null) {
            return Stream.empty();
        }
        return Stream.of(condition).flatMap(c -> {
            if (c instanceof ComparisonOperatorCondition || c instanceof MatchesCondition || c instanceof LikeCondition || c instanceof ExistsCondition) {
                return Stream.of(c);
            }
            if (c instanceof LogicalOperatorCondition) {
                LogicalOperatorCondition logical = (LogicalOperatorCondition)c;
                return logical.getValues().stream().flatMap(AqlQueryUtils::streamWhereConditions);
            }
            if (c instanceof NotCondition) {
                NotCondition not = (NotCondition)c;
                return AqlQueryUtils.streamWhereConditions(not.getConditionDto());
            }
            throw new IllegalStateException("Unsupported condition type %s".formatted(c.getClass()));
        });
    }
}

