/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import java.lang.runtime.SwitchBootstraps;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.openehr.aqlengine.asl.AslUtils;
import org.ehrbase.openehr.aqlengine.asl.OwnerProviderTuple;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotNullQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslProvidesJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslFolderItemIdVirtualField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslFolderItemJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslEncapsulatingQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.ContainsChain;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.ContainsSetOperationWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.ContainsWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.RmContainsWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.VersionContainsWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.ConditionWrapper;
import org.ehrbase.openehr.dbformat.AncestorStructureRmType;
import org.ehrbase.openehr.dbformat.RmTypeAlias;
import org.ehrbase.openehr.dbformat.StructureRmType;
import org.ehrbase.openehr.sdk.aql.dto.containment.Containment;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperatorSymbol;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentVersionExpression;
import org.jooq.JoinType;

public final class AslFromCreator {
    private final AslUtils.AliasProvider aliasProvider;
    private final KnowledgeCacheService knowledgeCacheService;
    private final boolean archetypeLocalNodePredicates;

    public AslFromCreator(AslUtils.AliasProvider aliasProvider, KnowledgeCacheService knowledgeCacheService, boolean archetypeLocalNodePredicates1) {
        this.aliasProvider = aliasProvider;
        this.knowledgeCacheService = knowledgeCacheService;
        this.archetypeLocalNodePredicates = archetypeLocalNodePredicates1;
    }

    public ContainsToOwnerProvider addFromClause(AslRootQuery rootQuery, AqlQueryWrapper queryWrapper) {
        HashMap<ContainsWrapper, OwnerProviderTuple> containsToStructureSubQuery = new HashMap<ContainsWrapper, OwnerProviderTuple>();
        ContainsChain fromChain = queryWrapper.containsChain();
        this.addContainsChain(rootQuery, null, null, fromChain, false, containsToStructureSubQuery);
        AslFromCreator.buildContainsCondition(fromChain, false, containsToStructureSubQuery).ifPresent(rootQuery::addConditionAnd);
        return containsToStructureSubQuery::get;
    }

    private static AslStructureQuery.AslSourceRelation getSourceRelation(RmContainsWrapper desc, AslStructureQuery parent) {
        if ("EHR".equals(desc.getRmType())) {
            return AslStructureQuery.AslSourceRelation.EHR;
        }
        return Optional.of(desc).map(RmContainsWrapper::getStructureRmType).map(StructureRmType::getStructureRoot).or(() -> AncestorStructureRmType.byTypeName((String)desc.getRmType()).map(AncestorStructureRmType::getStructureRoot)).map(AslStructureQuery.AslSourceRelation::get).or(() -> Optional.ofNullable(parent).map(AslStructureQuery::getType)).orElse(null);
    }

    private void addContainsChain(AslEncapsulatingQuery encapsulatingQuery, AslStructureQuery lastParent, ContainsWrapper lastParentWrapper, ContainsChain containsChain, boolean useLeftJoin, Map<ContainsWrapper, OwnerProviderTuple> containsToStructureSubQuery) {
        AslStructureQuery currentParent = lastParent;
        ContainsWrapper currentParentWrapper = lastParentWrapper;
        for (ContainsWrapper descriptor : containsChain.chain()) {
            currentParent = this.addContainsSubquery(encapsulatingQuery, useLeftJoin, containsToStructureSubQuery, descriptor, currentParent);
            currentParentWrapper = descriptor;
        }
        if (containsChain.hasTrailingSetOperation()) {
            RmContainsWrapper rmContainsWrapper;
            if (currentParentWrapper instanceof VersionContainsWrapper) {
                VersionContainsWrapper vcw = (VersionContainsWrapper)currentParentWrapper;
                rmContainsWrapper = vcw.child();
            } else {
                rmContainsWrapper = (RmContainsWrapper)currentParentWrapper;
            }
            RmContainsWrapper parentWrapper = rmContainsWrapper;
            this.addContainsChainSetOperator(encapsulatingQuery, containsChain, useLeftJoin, containsToStructureSubQuery, currentParent, parentWrapper);
        }
    }

    private AslStructureQuery addContainsSubquery(AslEncapsulatingQuery encapsulatingQuery, boolean useLeftJoin, Map<ContainsWrapper, OwnerProviderTuple> containsToStructureSubQuery, ContainsWrapper descriptor, AslStructureQuery currentParent) {
        RmContainsWrapper usedWrapper;
        ContainsWrapper containsWrapper = descriptor;
        Objects.requireNonNull(containsWrapper);
        ContainsWrapper containsWrapper2 = containsWrapper;
        int n = 0;
        boolean isOriginalVersion = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VersionContainsWrapper.class, RmContainsWrapper.class}, (Object)containsWrapper2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                VersionContainsWrapper vcw = (VersionContainsWrapper)containsWrapper2;
                usedWrapper = vcw.child();
                yield true;
            }
            case 1 -> {
                RmContainsWrapper rcw;
                usedWrapper = rcw = (RmContainsWrapper)containsWrapper2;
                yield false;
            }
        };
        AslStructureQuery.AslSourceRelation parentType = Optional.ofNullable(currentParent).map(AslStructureQuery::getType).orElse(null);
        AslStructureQuery.AslSourceRelation sourceRelation = AslFromCreator.getSourceRelation(usedWrapper, currentParent);
        boolean requiresVersionJoin = isOriginalVersion || parentType == AslStructureQuery.AslSourceRelation.EHR ? true : (parentType == AslStructureQuery.AslSourceRelation.FOLDER && sourceRelation == AslStructureQuery.AslSourceRelation.COMPOSITION ? true : (currentParent != null || sourceRelation == AslStructureQuery.AslSourceRelation.EHR ? false : Optional.of(usedWrapper).map(RmContainsWrapper::getStructureRmType).filter(StructureRmType::isStructureRoot).isPresent()));
        AslStructureQuery structureQuery = this.containsSubquery(usedWrapper, requiresVersionJoin, sourceRelation, isOriginalVersion);
        this.addContainsSubqueryToContainer(usedWrapper, encapsulatingQuery, structureQuery, currentParent, useLeftJoin);
        OwnerProviderTuple ownerProviderTuple = new OwnerProviderTuple(structureQuery, structureQuery);
        containsToStructureSubQuery.put(usedWrapper, ownerProviderTuple);
        if (isOriginalVersion) {
            containsToStructureSubQuery.put(descriptor, ownerProviderTuple);
        }
        return structureQuery;
    }

    private void addContainsSubqueryToContainer(RmContainsWrapper wrapper, AslEncapsulatingQuery container, AslStructureQuery toAdd, AslStructureQuery joinParent, boolean asLeftJoin) {
        AslJoin join;
        if (joinParent == null || container.getChildren().isEmpty()) {
            join = null;
        } else {
            JoinType joinType = asLeftJoin ? JoinType.LEFT_OUTER_JOIN : JoinType.JOIN;
            join = new AslJoin((AslQuery)joinParent, joinType, (AslQuery)toAdd, this.aslJoinCondition(wrapper, toAdd, joinParent));
        }
        container.addChild(toAdd, join);
    }

    private AslJoinCondition[] aslJoinCondition(RmContainsWrapper childWrapper, AslStructureQuery toAdd, AslStructureQuery joinParent) {
        RmContainsWrapper rcw;
        AslStructureQuery.AslSourceRelation parentType = joinParent.getType();
        AslStructureQuery.AslSourceRelation targetType = toAdd.getType();
        if (parentType == AslStructureQuery.AslSourceRelation.FOLDER && targetType == AslStructureQuery.AslSourceRelation.COMPOSITION) {
            return new AslJoinCondition[]{new AslFolderItemJoinCondition(joinParent, joinParent, targetType, toAdd, toAdd)};
        }
        ContainsWrapper containsWrapper = childWrapper.getParent();
        RmContainsWrapper parentWrapper = containsWrapper instanceof RmContainsWrapper ? (rcw = (RmContainsWrapper)containsWrapper) : null;
        return (AslJoinCondition[])AslUtils.descendantJoinConditionProviders(joinParent, joinParent, parentWrapper, toAdd, toAdd, childWrapper, this.archetypeLocalNodePredicates).map(AslProvidesJoinCondition::provideJoinCondition).toArray(AslJoinCondition[]::new);
    }

    private void addContainsChainSetOperator(AslEncapsulatingQuery currentQuery, ContainsChain containsChain, boolean asLeftJoin, Map<ContainsWrapper, OwnerProviderTuple> containsToStructureSubQuery, AslStructureQuery currentParent, RmContainsWrapper parentWrapper) {
        ContainsSetOperationWrapper setOperator = containsChain.trailingSetOperation();
        for (ContainsChain operand : setOperator.operands()) {
            boolean requiresOrOperandSubQuery;
            boolean bl = requiresOrOperandSubQuery = setOperator.operator() == ContainmentSetOperatorSymbol.OR && operand.size() > 1;
            if (requiresOrOperandSubQuery) {
                RmContainsWrapper rmContainsWrapper;
                ContainsWrapper childDescriptor = operand.chain().getFirst();
                if (childDescriptor instanceof VersionContainsWrapper) {
                    VersionContainsWrapper vcw = (VersionContainsWrapper)childDescriptor;
                    rmContainsWrapper = vcw.child();
                } else {
                    rmContainsWrapper = (RmContainsWrapper)childDescriptor;
                }
                RmContainsWrapper childWrapper = rmContainsWrapper;
                AslEncapsulatingQuery orSq = this.buildOrOperandAsEncapsulatingQuery(containsToStructureSubQuery, currentParent, parentWrapper, operand);
                AslStructureQuery child = (AslStructureQuery)orSq.getChildren().getFirst().getLeft();
                currentQuery.addChild(orSq, new AslJoin((AslQuery)currentParent, JoinType.LEFT_OUTER_JOIN, (AslQuery)orSq, (AslJoinCondition[])AslUtils.descendantJoinConditionProviders(currentParent, currentParent, parentWrapper, orSq, child, childWrapper, this.archetypeLocalNodePredicates).map(AslProvidesJoinCondition::provideJoinCondition).toArray(AslJoinCondition[]::new)));
                continue;
            }
            this.addContainsChain(currentQuery, currentParent, parentWrapper, operand, asLeftJoin || setOperator.operator() == ContainmentSetOperatorSymbol.OR, containsToStructureSubQuery);
        }
    }

    private AslEncapsulatingQuery buildOrOperandAsEncapsulatingQuery(Map<ContainsWrapper, OwnerProviderTuple> containsToStructureSubQuery, AslStructureQuery currentParent, RmContainsWrapper parentWrapper, ContainsChain operand) {
        AslEncapsulatingQuery orSq = new AslEncapsulatingQuery(this.aliasProvider.uniqueAlias("or_sq"));
        HashMap<ContainsWrapper, OwnerProviderTuple> subQueryMap = new HashMap<ContainsWrapper, OwnerProviderTuple>();
        this.addContainsChain(orSq, currentParent, parentWrapper, operand, false, subQueryMap);
        AslFromCreator.buildContainsCondition(operand, false, subQueryMap).ifPresent(orSq::addStructureCondition);
        subQueryMap.forEach((k, v) -> containsToStructureSubQuery.put((ContainsWrapper)k, new OwnerProviderTuple(v.owner(), orSq)));
        return orSq;
    }

    private AslStructureQuery containsSubquery(RmContainsWrapper containsWrapper, boolean requiresVersionJoin, AslStructureQuery.AslSourceRelation sourceRelation, boolean isOriginalVersion) {
        boolean isRoot;
        List rmTypes;
        String rmType = containsWrapper.getRmType();
        String sAlias = this.aliasProvider.uniqueAlias("s" + RmTypeAlias.optionalAlias((String)rmType).orElse(rmType) + Optional.of(containsWrapper).map(ContainsWrapper::alias).map(a -> "_" + a).orElse(""));
        if ("EHR".equals(rmType)) {
            rmTypes = List.of("EHR");
            isRoot = false;
        } else {
            rmTypes = AncestorStructureRmType.byTypeName((String)rmType).map(AncestorStructureRmType::getDescendants).map(s -> s.stream().distinct().map(Enum::name).toList()).orElseGet(() -> List.of(containsWrapper.getStructureRmType().name()));
            isRoot = "EHR_STATUS".equals(rmType) || "COMPOSITION".equals(rmType);
        }
        List<AslField> fields = AslFromCreator.fieldsForContainsSubquery(containsWrapper, requiresVersionJoin, sourceRelation);
        AslStructureQuery aslStructureQuery = new AslStructureQuery(sAlias, sourceRelation, fields, rmTypes, isRoot ? List.of() : rmTypes, null, requiresVersionJoin, isOriginalVersion, isRoot);
        AslUtils.predicates(containsWrapper.getPredicate(), c -> AslUtils.structurePredicateCondition(c, aslStructureQuery, arg_0 -> ((KnowledgeCacheService)this.knowledgeCacheService).findUuidByTemplateId(arg_0))).ifPresent(aslStructureQuery::addConditionAnd);
        return aslStructureQuery;
    }

    private static List<AslField> fieldsForContainsSubquery(RmContainsWrapper currentDesc, boolean requiresVersionJoin, AslStructureQuery.AslSourceRelation sourceRelation) {
        ArrayList<AslField> fields = new ArrayList<AslField>();
        if ("EHR".equals(currentDesc.getRmType())) {
            fields.add(new AslColumnField(UUID.class, "id", null, false, AslExtractedColumn.EHR_ID));
            fields.add(new AslColumnField(OffsetDateTime.class, "creation_date", null, false, null));
        } else {
            Arrays.stream(AslStructureColumn.values()).filter(c -> requiresVersionJoin || c.isFromDataTable() || sourceRelation.getPkeyFields().stream().anyMatch(f -> f.getName().equals(c.getFieldName()))).filter(c -> Optional.of(c).map(f -> requiresVersionJoin && c.isFromVersionTable() ? sourceRelation.getVersionTable() : sourceRelation.getDataTable()).map(t -> t.field(c.getFieldName())).isPresent()).map(AslStructureColumn::field).forEach(fields::add);
            if (requiresVersionJoin && "COMPOSITION".equals(currentDesc.getRmType())) {
                fields.add(new AslColumnField(String.class, Tables.COMP_VERSION.ROOT_CONCEPT.getName(), null, true, AslExtractedColumn.ROOT_CONCEPT));
            }
            if ("FOLDER".equals(currentDesc.getRmType())) {
                boolean mustAddItemsField;
                Containment containment = currentDesc.containment().getContains();
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ContainmentClassExpression.class, ContainmentVersionExpression.class}, (Object)containment, n)) {
                    case 0: {
                        ContainmentClassExpression cce = (ContainmentClassExpression)containment;
                        boolean bl = Objects.equals(cce.getType(), "COMPOSITION");
                        break;
                    }
                    case 1: {
                        ContainmentClassExpression cce;
                        boolean bl;
                        ContainmentVersionExpression cve = (ContainmentVersionExpression)containment;
                        Containment containment2 = cve.getContains();
                        if (containment2 instanceof ContainmentClassExpression && Objects.equals((cce = (ContainmentClassExpression)containment2).getType(), "COMPOSITION")) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case -1: {
                        boolean bl = false;
                        break;
                    }
                    default: {
                        boolean bl = mustAddItemsField = false;
                    }
                }
                if (mustAddItemsField) {
                    fields.add(new AslFolderItemIdVirtualField());
                }
            }
        }
        return fields;
    }

    private static Optional<AslQueryCondition> buildContainsCondition(ContainsChain chainDescriptor, boolean chainIsBelowOr, Map<ContainsWrapper, OwnerProviderTuple> containsToStructureSubQuery) {
        if (!chainIsBelowOr && !chainDescriptor.hasTrailingSetOperation()) {
            return Optional.empty();
        }
        ArrayList conditions = new ArrayList();
        if (chainIsBelowOr) {
            chainDescriptor.chain().stream().map(containsToStructureSubQuery::get).map(OwnerProviderTuple::provider).map(t -> new AslNotNullQueryCondition(t.getSelect().getFirst())).forEach(conditions::add);
        }
        if (chainDescriptor.hasTrailingSetOperation()) {
            AslFromCreator.containsConditionForSetOperator(chainDescriptor, chainIsBelowOr, containsToStructureSubQuery).forEach(conditions::add);
        }
        return Optional.of(conditions).map(Collection::stream).map(AslUtils::and);
    }

    private static Stream<AslQueryCondition> containsConditionForSetOperator(ContainsChain chainDescriptor, boolean chainIsBelowOr, Map<ContainsWrapper, OwnerProviderTuple> containsToStructureSubQuery) {
        ContainsSetOperationWrapper setOperator = chainDescriptor.trailingSetOperation();
        boolean isOrOperator = setOperator.operator() == ContainmentSetOperatorSymbol.OR;
        Stream<AslQueryCondition> operatorConditions = setOperator.operands().stream().map(operand -> {
            if (isOrOperator && operand.size() > 1) {
                OwnerProviderTuple subQuery = (OwnerProviderTuple)containsToStructureSubQuery.get(operand.chain().getFirst());
                return new AslNotNullQueryCondition(AslUtils.findFieldForOwner(AslStructureColumn.VO_ID, subQuery.provider().getSelect(), subQuery.owner()));
            }
            return AslFromCreator.buildContainsCondition(operand, chainIsBelowOr || isOrOperator, containsToStructureSubQuery).orElse(null);
        }).filter(Objects::nonNull);
        return isOrOperator ? AslUtils.reduceConditions(ConditionWrapper.LogicalConditionOperator.OR, operatorConditions).stream() : operatorConditions;
    }

    @FunctionalInterface
    public static interface ContainsToOwnerProvider {
        public OwnerProviderTuple get(ContainsWrapper var1);
    }
}

