/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import java.lang.runtime.SwitchBootstraps;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.openehr.aqlengine.aql.model.ListPredicateOperand;
import org.ehrbase.openehr.aqlengine.asl.OwnerProviderTuple;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.AslRmTypeAndConcept;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslAndQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslCoalesceJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFalseQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldFieldQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotNullQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslOrQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslProvidesJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslTrueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslAggregatingField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslConstantField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslFolderItemIdVirtualField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslRmPathField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslStringAggregationField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslSubqueryField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslEncapsulatingQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathCohesionAnalysis;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathInfo;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.RmContainsWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.ComparisonOperatorConditionWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.ConditionWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.LogicalOperatorConditionWrapper;
import org.ehrbase.openehr.dbformat.StructureRmType;
import org.ehrbase.openehr.sdk.aql.dto.operand.PathPredicateOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.TemporalPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.ehrbase.openehr.sdk.util.OpenEHRDateTimeParseUtils;
import org.jooq.Field;
import org.jooq.JSONB;

public final class AslUtils {
    private static final String EHR_TABLE_ID_FIELD = Tables.EHR_.ID.getUnqualifiedName().first();
    private static final String COMP_DATA_TABLE_ROOT_CONCEPT_FIELD = Tables.COMP_VERSION.ROOT_CONCEPT.getUnqualifiedName().first();
    private static final EnumSet<AslStructureQuery.AslSourceRelation> SUPPORTED_DESCENDANT_PARENT_RELATIONS = EnumSet.of(AslStructureQuery.AslSourceRelation.COMPOSITION, AslStructureQuery.AslSourceRelation.EHR_STATUS, AslStructureQuery.AslSourceRelation.FOLDER, AslStructureQuery.AslSourceRelation.EHR);
    private static final EnumSet<AslStructureQuery.AslSourceRelation> SUPPORTED_DESCENDANT_CONDITIONS = EnumSet.of(AslStructureQuery.AslSourceRelation.COMPOSITION, AslStructureQuery.AslSourceRelation.EHR_STATUS, AslStructureQuery.AslSourceRelation.FOLDER);

    private AslUtils() {
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key: attempted merging values %s and %s", u, v));
        }, LinkedHashMap::new);
    }

    @SafeVarargs
    public static <T> Stream<T> concatStreams(Stream<? extends T> ... streams) {
        return Arrays.stream(streams).flatMap(s -> s);
    }

    public static Stream<String> streamFieldNames(AslField field) {
        AslField aslField = field;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslColumnField.class, AslRmPathField.class, AslConstantField.class, AslAggregatingField.class, AslComplexExtractedColumnField.class, AslSubqueryField.class, AslFolderItemIdVirtualField.class, AslStringAggregationField.class}, (Object)aslField, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslColumnField cf = (AslColumnField)aslField;
                yield Stream.of(cf.getColumnName());
            }
            case 1 -> {
                AslRmPathField pf = (AslRmPathField)aslField;
                yield Stream.of(pf.getSrcField().getColumnName());
            }
            case 2 -> {
                AslConstantField __ = (AslConstantField)aslField;
                yield Stream.empty();
            }
            case 3 -> {
                AslAggregatingField af = (AslAggregatingField)aslField;
                yield AslUtils.streamFieldNames(af.getBaseField());
            }
            case 4 -> {
                AslComplexExtractedColumnField ecf = (AslComplexExtractedColumnField)aslField;
                yield ecf.getExtractedColumn().getColumns().stream();
            }
            case 5 -> {
                AslStructureQuery sq;
                AslSubqueryField sqf = (AslSubqueryField)aslField;
                AslQuery baseQuery = ((AslDataQuery)sqf.getBaseQuery()).getBase();
                Stream<String> pkeyFieldNames = AslUtils.getTargetType(baseQuery).getPkeyFields().stream().map(Field::getName);
                Stream filterConditionFieldNames = sqf.getFilterConditions().stream().flatMap(AslUtils::streamConditionFields).flatMap(AslUtils::streamFieldNames);
                if (baseQuery instanceof AslStructureQuery && (sq = (AslStructureQuery)baseQuery).isRoot()) {
                    yield AslUtils.concatStreams(pkeyFieldNames, filterConditionFieldNames);
                }
                yield AslUtils.concatStreams(pkeyFieldNames, filterConditionFieldNames, Stream.of(AslStructureColumn.NUM.getFieldName()), Stream.of(AslStructureColumn.NUM_CAP.getFieldName()));
            }
            case 6 -> {
                AslFolderItemIdVirtualField f = (AslFolderItemIdVirtualField)aslField;
                yield Stream.of(f.getFieldName());
            }
            case -1 -> Stream.empty();
            case 7 -> {
                AslStringAggregationField f = (AslStringAggregationField)aslField;
                yield AslUtils.streamFieldNames(f.getBaseField());
            }
        };
    }

    public static AslStructureQuery.AslSourceRelation getTargetType(AslQuery target) {
        if (target instanceof AslStructureQuery) {
            AslStructureQuery sq = (AslStructureQuery)target;
            return sq.getType();
        }
        throw new IllegalArgumentException("target is no StructureQuery: %s".formatted(target));
    }

    public static Stream<AslField> streamConditionFields(AslQueryCondition condition) {
        AslQueryCondition aslQueryCondition = condition;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslAndQueryCondition.class, AslOrQueryCondition.class, AslNotQueryCondition.class, AslNotNullQueryCondition.class, AslFieldValueQueryCondition.class, AslFalseQueryCondition.class, AslTrueQueryCondition.class, AslProvidesJoinCondition.class}, (Object)aslQueryCondition, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslAndQueryCondition c = (AslAndQueryCondition)aslQueryCondition;
                yield c.getOperands().stream().flatMap(AslUtils::streamConditionFields);
            }
            case 1 -> {
                AslOrQueryCondition c = (AslOrQueryCondition)aslQueryCondition;
                yield c.getOperands().stream().flatMap(AslUtils::streamConditionFields);
            }
            case 2 -> {
                AslNotQueryCondition c = (AslNotQueryCondition)aslQueryCondition;
                yield AslUtils.streamConditionFields(c.getCondition());
            }
            case 3 -> {
                AslNotNullQueryCondition c = (AslNotNullQueryCondition)aslQueryCondition;
                yield Stream.of(c.getField());
            }
            case 4 -> {
                AslFieldValueQueryCondition c = (AslFieldValueQueryCondition)aslQueryCondition;
                yield Stream.of(c.getField());
            }
            case 5 -> {
                AslFalseQueryCondition __ = (AslFalseQueryCondition)aslQueryCondition;
                yield Stream.empty();
            }
            case 6 -> {
                AslTrueQueryCondition __ = (AslTrueQueryCondition)aslQueryCondition;
                yield Stream.empty();
            }
            case 7 -> {
                AslProvidesJoinCondition __ = (AslProvidesJoinCondition)aslQueryCondition;
                throw new IllegalArgumentException();
            }
            case -1 -> Stream.empty();
        };
    }

    public static Stream<ComparisonOperatorConditionWrapper> streamConditionDescriptors(ConditionWrapper condition) {
        if (condition == null) {
            return Stream.empty();
        }
        if (condition instanceof ComparisonOperatorConditionWrapper) {
            ComparisonOperatorConditionWrapper cd = (ComparisonOperatorConditionWrapper)condition;
            return Stream.of(cd);
        }
        if (condition instanceof LogicalOperatorConditionWrapper) {
            LogicalOperatorConditionWrapper ld = (LogicalOperatorConditionWrapper)condition;
            return ld.logicalOperands().stream().flatMap(AslUtils::streamConditionDescriptors);
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(condition));
    }

    public static OffsetDateTime toOffsetDateTime(StringPrimitive sp) {
        boolean hasOffset;
        TemporalAccessor temporal;
        if (sp instanceof TemporalPrimitive) {
            TemporalPrimitive tp = (TemporalPrimitive)sp;
            temporal = tp.getTemporal();
        } else {
            temporal = AslUtils.parseDateTimeOrTimeWithHigherPrecision((String)((Object)sp.getValue())).orElse(null);
        }
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)temporal;
            return odt;
        }
        if (!temporal.isSupported(ChronoField.YEAR)) {
            return null;
        }
        boolean hasTime = temporal.isSupported(ChronoField.HOUR_OF_DAY);
        boolean bl = hasOffset = hasTime && temporal.isSupported(ChronoField.OFFSET_SECONDS);
        if (hasOffset) {
            return OffsetDateTime.from(temporal);
        }
        if (hasTime) {
            return LocalDateTime.from(temporal).atOffset(ZoneOffset.UTC);
        }
        return LocalDate.from(temporal).atStartOfDay().atOffset(ZoneOffset.UTC);
    }

    public static Optional<TemporalAccessor> parseDateTimeOrTimeWithHigherPrecision(String val) {
        block4: {
            int dotIdx = val.indexOf(46);
            int tIdx = val.indexOf(84);
            int length = val.length();
            try {
                if (dotIdx == 19 && tIdx == 10 && length > 20 || dotIdx == 15 && tIdx == 8 && length > 16) {
                    return Optional.of(OpenEHRDateTimeParseUtils.parseDateTime((String)val));
                }
                if (tIdx == -1 && (dotIdx == 8 && length > 9 || dotIdx == 10 && length > 11)) {
                    return Optional.of(OpenEHRDateTimeParseUtils.parseTime((String)val));
                }
            }
            catch (IllegalArgumentException e) {
                if (e.getCause() instanceof DateTimeException) break block4;
                throw e;
            }
        }
        return Optional.empty();
    }

    public static AslColumnField findFieldForOwner(AslStructureColumn structureField, List<AslField> fields, AslQuery owner) {
        return AslUtils.findFieldForOwner(structureField.getFieldName(), fields, owner);
    }

    public static AslColumnField findFieldForOwner(String fieldName, List<AslField> fields, AslQuery owner) {
        return fields.stream().filter(f -> f.getOwner() == owner).filter(AslColumnField.class::isInstance).map(AslColumnField.class::cast).filter(f -> fieldName.equals(f.getColumnName())).findFirst().orElseThrow(() -> new IllegalArgumentException("Field '%s' does not exist for owner '%s'".formatted(fieldName, owner.getAlias())));
    }

    static AslQueryCondition structurePredicateCondition(ComparisonOperatorPredicate predicate, AslStructureQuery query, Function<String, Optional<UUID>> templateUuidLookupFunc) {
        List<Object> list;
        HashSet<String> candidateTypes = new HashSet<String>(query.getRmTypes());
        if (candidateTypes.isEmpty() && query.getType() == AslStructureQuery.AslSourceRelation.EHR) {
            candidateTypes.add("EHR");
        }
        AslExtractedColumn extractedColumn = AslExtractedColumn.find((String)candidateTypes.iterator().next(), predicate.getPath()).filter(ec -> ec.getAllowedRmTypes().containsAll(candidateTypes)).orElseThrow();
        AslField.FieldSource ownerSource = AslField.FieldSource.withOwner(query);
        PathPredicateOperand pathPredicateOperand = predicate.getValue();
        if (pathPredicateOperand instanceof ListPredicateOperand) {
            ListPredicateOperand lpo = (ListPredicateOperand)pathPredicateOperand;
            list = lpo.getValues();
        } else {
            list = List.of((Primitive)predicate.getValue());
        }
        List<Object> value = list;
        ConditionWrapper.ComparisonConditionOperator operator = ConditionWrapper.ComparisonConditionOperator.valueOf(predicate.getOperator().name());
        AslQueryCondition.AslConditionOperator aslOperator = value.size() > 1 && operator == ConditionWrapper.ComparisonConditionOperator.EQ ? AslQueryCondition.AslConditionOperator.IN : operator.getAslOperator();
        AslFieldValueQueryCondition condition = switch (extractedColumn) {
            default -> throw new MatchException(null, null);
            case AslExtractedColumn.NAME_VALUE -> new AslFieldValueQueryCondition(AslUtils.findFieldForOwner(AslStructureColumn.ENTITY_NAME, query.getSelect(), (AslQuery)query), aslOperator, AslUtils.conditionValue(value, operator, String.class));
            case AslExtractedColumn.VO_ID -> new AslFieldValueQueryCondition(AslComplexExtractedColumnField.voIdField(ownerSource), aslOperator, AslUtils.conditionValue(value, operator, String.class));
            case AslExtractedColumn.EHR_ID -> new AslFieldValueQueryCondition(AslUtils.findFieldForOwner(EHR_TABLE_ID_FIELD, query.getSelect(), (AslQuery)query), aslOperator, AslUtils.conditionValue(value, operator, String.class));
            case AslExtractedColumn.ARCHETYPE_NODE_ID -> new AslFieldValueQueryCondition<AslRmTypeAndConcept>(AslComplexExtractedColumnField.archetypeNodeIdField(ownerSource), aslOperator, AslUtils.archetypeNodeIdConditionValues(value, operator));
            case AslExtractedColumn.ROOT_CONCEPT -> new AslFieldValueQueryCondition<String>(AslUtils.findFieldForOwner(COMP_DATA_TABLE_ROOT_CONCEPT_FIELD, query.getSelect(), (AslQuery)query), aslOperator, AslUtils.archetypeNodeIdConditionValues(value, operator).stream().filter(tc -> StructureRmType.COMPOSITION.getAlias().equals(tc.aliasedRmType())).map(AslRmTypeAndConcept::concept).toList());
            case AslExtractedColumn.TEMPLATE_ID -> {
                List<UUID> templateUuids = AslUtils.templateIdConditionValues(value, operator, templateUuidLookupFunc);
                yield new AslFieldValueQueryCondition<UUID>(AslUtils.findFieldForOwner(AslStructureColumn.TEMPLATE_ID, query.getSelect(), (AslQuery)query), aslOperator, templateUuids);
            }
            case AslExtractedColumn.OV_CONTRIBUTION_ID, AslExtractedColumn.OV_TIME_COMMITTED, AslExtractedColumn.OV_TIME_COMMITTED_DV, AslExtractedColumn.AD_SYSTEM_ID, AslExtractedColumn.AD_CHANGE_TYPE_TERMINOLOGY_ID_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_PREFERRED_TERM, AslExtractedColumn.AD_CHANGE_TYPE_CODE_STRING, AslExtractedColumn.AD_CHANGE_TYPE_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_DV, AslExtractedColumn.AD_DESCRIPTION_VALUE, AslExtractedColumn.AD_DESCRIPTION_DV, AslExtractedColumn.EHR_TIME_CREATED, AslExtractedColumn.EHR_TIME_CREATED_DV, AslExtractedColumn.EHR_SYSTEM_ID, AslExtractedColumn.EHR_SYSTEM_ID_DV -> throw new IllegalArgumentException("Unexpected structure predicate on %s".formatted(new Object[]{extractedColumn}));
        };
        if (condition.getValues().isEmpty()) {
            return switch (condition.getOperator()) {
                case AslQueryCondition.AslConditionOperator.IN, AslQueryCondition.AslConditionOperator.EQ, AslQueryCondition.AslConditionOperator.LIKE -> new AslFalseQueryCondition();
                case AslQueryCondition.AslConditionOperator.NEQ -> new AslTrueQueryCondition();
                default -> throw new IllegalArgumentException("Unexpected operator %s".formatted(new Object[]{condition.getOperator()}));
            };
        }
        return condition;
    }

    static List<AslRmTypeAndConcept> archetypeNodeIdConditionValues(List<Primitive> comparison, ConditionWrapper.ComparisonConditionOperator operator) {
        return AslUtils.conditionValue(comparison, operator, String.class).stream().map(String.class::cast).map(AslRmTypeAndConcept::fromArchetypeNodeId).toList();
    }

    static List<UUID> templateIdConditionValues(List<Primitive> operands, ConditionWrapper.ComparisonConditionOperator operator, Function<String, Optional<UUID>> templateUuidLookupFunc) {
        if (EnumSet.of(ConditionWrapper.ComparisonConditionOperator.LIKE, ConditionWrapper.ComparisonConditionOperator.GT_EQ, ConditionWrapper.ComparisonConditionOperator.GT, ConditionWrapper.ComparisonConditionOperator.LT_EQ, ConditionWrapper.ComparisonConditionOperator.LT).contains((Object)operator)) {
            throw new IllegalArgumentException("unexpected operator for template_id: %s".formatted(new Object[]{operator}));
        }
        return AslUtils.conditionValue(operands, operator, String.class).stream().filter(Objects::nonNull).map(String.class::cast).map(templateUuidLookupFunc).flatMap(Optional::stream).toList();
    }

    static Stream<StringPrimitive> streamStringPrimitives(ComparisonOperatorConditionWrapper c) {
        return c.rightComparisonOperands().stream().filter(StringPrimitive.class::isInstance).map(StringPrimitive.class::cast);
    }

    static Optional<AslQueryCondition> reduceConditions(ConditionWrapper.LogicalConditionOperator setOp, Stream<AslQueryCondition> conditions) {
        List<AslQueryCondition> unfiltered = conditions.toList();
        if (unfiltered.isEmpty()) {
            return Optional.empty();
        }
        List<AslQueryCondition> filtered = unfiltered.stream().filter(setOp::filterNotNoop).toList();
        if (filtered.isEmpty()) {
            return Optional.of(unfiltered.getFirst());
        }
        if (filtered.size() == 1) {
            return Optional.of(filtered.getFirst());
        }
        return filtered.stream().filter(setOp::filterShortCircuit).findFirst().or(() -> Optional.of(setOp.build(filtered)));
    }

    static Optional<AslQueryCondition> predicates(List<AndOperatorPredicate> orPredicates, Function<ComparisonOperatorPredicate, AslQueryCondition> comparisonOperatorHandler) {
        return AslUtils.reduceConditions(ConditionWrapper.LogicalConditionOperator.OR, CollectionUtils.emptyIfNull(orPredicates).stream().map(p -> AslUtils.reduceConditions(ConditionWrapper.LogicalConditionOperator.AND, p.getOperands().stream().map(comparisonOperatorHandler))).flatMap(Optional::stream));
    }

    static List<?> conditionValue(List<Primitive> values, ConditionWrapper.ComparisonConditionOperator operator, Class<?> type) {
        boolean isJsonbField = JSONB.class.isAssignableFrom(type);
        return switch (operator) {
            default -> throw new MatchException(null, null);
            case ConditionWrapper.ComparisonConditionOperator.EXISTS -> Collections.emptyList();
            case ConditionWrapper.ComparisonConditionOperator.MATCHES, ConditionWrapper.ComparisonConditionOperator.EQ, ConditionWrapper.ComparisonConditionOperator.NEQ -> values.stream().map(Primitive::getValue).filter(p -> isJsonbField || type.isInstance(p) || UUID.class.isAssignableFrom(type) && p instanceof String).toList();
            case ConditionWrapper.ComparisonConditionOperator.LT, ConditionWrapper.ComparisonConditionOperator.GT_EQ, ConditionWrapper.ComparisonConditionOperator.GT, ConditionWrapper.ComparisonConditionOperator.LT_EQ -> values.stream().map(Primitive::getValue).toList();
            case ConditionWrapper.ComparisonConditionOperator.LIKE -> values.stream().map(Primitive::getValue).map(String.class::cast).filter(p -> isJsonbField || type.isInstance(p) || UUID.class.isAssignableFrom(type)).toList();
        };
    }

    static AslQueryCondition and(Stream<AslQueryCondition> conditionStream) {
        List<AslQueryCondition> conditions = conditionStream.toList();
        return switch (conditions.size()) {
            case 0 -> null;
            case 1 -> conditions.getFirst();
            default -> new AslAndQueryCondition(conditions);
        };
    }

    public static Stream<AslFieldFieldQueryCondition> descendantJoinConditionProviders(AslQuery leftQuery, AslStructureQuery leftOwner, RmContainsWrapper leftWrapper, AslQuery rightQuery, AslStructureQuery rightOwner, RmContainsWrapper rightWrapper, boolean archetypeLocalNodePredicates) {
        AslStructureQuery.AslSourceRelation parentRelation = leftOwner.getType();
        if (!SUPPORTED_DESCENDANT_PARENT_RELATIONS.contains((Object)parentRelation)) {
            throw new IllegalArgumentException("unexpected parent relation type %s".formatted(new Object[]{parentRelation}));
        }
        AslStructureQuery.AslSourceRelation descendantRelation = rightOwner.getType();
        if (!SUPPORTED_DESCENDANT_CONDITIONS.contains((Object)descendantRelation)) {
            throw new IllegalArgumentException("unexpected descendant relation type %s".formatted(new Object[]{descendantRelation}));
        }
        Stream<AslFieldFieldQueryCondition> idConditions = parentRelation == AslStructureQuery.AslSourceRelation.EHR ? Stream.of(new AslFieldFieldQueryCondition(AslUtils.findFieldForOwner(EHR_TABLE_ID_FIELD, leftQuery.getSelect(), (AslQuery)leftOwner), AslQueryCondition.AslConditionOperator.EQ, AslUtils.findFieldForOwner(AslStructureColumn.EHR_ID, rightQuery.getSelect(), (AslQuery)rightOwner))) : AslUtils.sameVersionedObjectJoinConditions(leftQuery, leftOwner, rightQuery, rightOwner);
        return AslUtils.concatStreams(idConditions, AslUtils.getContainsJoinConditions(leftQuery, leftOwner, leftWrapper, rightQuery, rightOwner, rightWrapper, archetypeLocalNodePredicates));
    }

    public static Stream<AslFieldFieldQueryCondition> pathChildJoinConditions(AslQuery left, AslStructureQuery leftOwner, AslQuery right, AslStructureQuery rightOwner) {
        return AslUtils.concatStreams(AslUtils.sameVersionedObjectJoinConditions(left, leftOwner, right, rightOwner), Stream.of(AslUtils.numEqualParentNumJoinCondition(left, leftOwner, right, rightOwner)));
    }

    public static Stream<AslFieldFieldQueryCondition> archetypeAnchorJoinConditions(PathCohesionAnalysis.PathCohesionTreeNode leftNode, AslQuery left, AslStructureQuery leftOwner, AslQuery right, AslStructureQuery rightOwner) {
        return AslUtils.concatStreams(AslUtils.sameVersionedObjectJoinConditions(left, leftOwner, right, rightOwner), Stream.of(AslUtils.cItemNumJoinCondition(leftNode, left, leftOwner, right, rightOwner)));
    }

    public static Stream<AslFieldFieldQueryCondition> nodeIdAnchorJoinConditions(PathCohesionAnalysis.PathCohesionTreeNode leftNode, AslQuery left, AslStructureQuery leftOwner, AslQuery right, AslStructureQuery rightOwner) {
        return AslUtils.concatStreams(AslUtils.sameVersionedObjectJoinConditions(left, leftOwner, right, rightOwner), Stream.of(AslUtils.cItemNumJoinCondition(leftNode, left, leftOwner, right, rightOwner)), AslUtils.numCapBetweenJoinConditions(left, leftOwner, right, rightOwner));
    }

    public static Stream<AslCoalesceJoinCondition> sameParentAsSiblingsJoinCondition(AslEncapsulatingQuery query, AslQuery leftProvider, AslQuery rightProvider, AslStructureQuery rightOwner, PathCohesionAnalysis.PathCohesionTreeNode currentNode, Function<PathCohesionAnalysis.PathCohesionTreeNode, OwnerProviderTuple> nodeToSq) {
        AslColumnField rightParentNumField = AslUtils.findFieldForOwner(AslStructureColumn.PARENT_NUM, rightProvider.getSelect(), (AslQuery)rightOwner);
        Stream<PathCohesionAnalysis.PathCohesionTreeNode> siblings = ((PathCohesionAnalysis.PathCohesionTreeNode)currentNode.getParent()).streamChildren().filter(c -> c != currentNode);
        return siblings.map(nodeToSq).filter(Objects::nonNull).flatMap(csq -> {
            Stream<AslQuery> sibling = query.getChildren().stream().skip(1L).filter(jp -> ((AslJoin)jp.getRight()).getLeft() == leftProvider).filter(jp -> jp.getLeft() == csq.provider()).map(Pair::getLeft);
            return sibling.map(q -> q.getSelect().stream().filter(AslColumnField.class::isInstance).map(AslColumnField.class::cast).filter(f -> AslStructureColumn.PARENT_NUM.getFieldName().equals(f.getColumnName())).findFirst().orElseThrow(() -> new IllegalArgumentException("Field '%s' does not exist for query '%s'".formatted(AslStructureColumn.PARENT_NUM.getFieldName(), q.getAlias())))).map(pnf -> new AslCoalesceJoinCondition(new AslFieldFieldQueryCondition(rightParentNumField, AslQueryCondition.AslConditionOperator.EQ, (AslField)pnf), true));
        });
    }

    private static Stream<AslFieldFieldQueryCondition> sameVersionedObjectJoinConditions(AslQuery left, AslStructureQuery leftOwner, AslQuery right, AslStructureQuery rightOwner) {
        AslStructureQuery.AslSourceRelation parentRelation = leftOwner.getType();
        if (!EnumSet.of(AslStructureQuery.AslSourceRelation.COMPOSITION, AslStructureQuery.AslSourceRelation.EHR_STATUS, AslStructureQuery.AslSourceRelation.FOLDER).contains((Object)parentRelation)) {
            throw new IllegalArgumentException("unexpected parent relation type %s".formatted(new Object[]{parentRelation}));
        }
        AslStructureQuery.AslSourceRelation childRelation = rightOwner.getType();
        if (!EnumSet.of(AslStructureQuery.AslSourceRelation.COMPOSITION, AslStructureQuery.AslSourceRelation.EHR_STATUS, AslStructureQuery.AslSourceRelation.FOLDER).contains((Object)childRelation)) {
            throw new IllegalArgumentException("unexpected descendant relation type %s".formatted(new Object[]{childRelation}));
        }
        return (switch (parentRelation) {
            default -> throw new MatchException(null, null);
            case AslStructureQuery.AslSourceRelation.EHR_STATUS -> Stream.of(AslStructureColumn.EHR_ID);
            case AslStructureQuery.AslSourceRelation.COMPOSITION -> Stream.of(AslStructureColumn.VO_ID);
            case AslStructureQuery.AslSourceRelation.FOLDER -> Stream.of(AslStructureColumn.EHR_ID, AslStructureColumn.EHR_FOLDER_IDX);
            case AslStructureQuery.AslSourceRelation.AUDIT_DETAILS -> throw new IllegalArgumentException("Path child condition not applicable to AUDIT_DETAILS");
            case AslStructureQuery.AslSourceRelation.EHR -> throw new IllegalArgumentException("Path child condition not applicable to EHR");
        }).map(sc -> AslUtils.columnEqualToColumnJoinCondition(sc, left, leftOwner, sc, right, rightOwner));
    }

    private static AslFieldFieldQueryCondition joinColumnEqualCondition(AslStructureColumn column, AslQuery left, AslStructureQuery leftOwner, AslQuery right, AslStructureQuery rightOwner) {
        return AslUtils.columnEqualToColumnJoinCondition(column, left, leftOwner, column, right, rightOwner);
    }

    private static AslFieldFieldQueryCondition columnEqualToColumnJoinCondition(AslStructureColumn leftColumn, AslQuery left, AslStructureQuery leftOwner, AslStructureColumn rightColumn, AslQuery right, AslStructureQuery rightOwner) {
        return new AslFieldFieldQueryCondition(AslUtils.findFieldForOwner(leftColumn, left.getSelect(), (AslQuery)leftOwner), AslQueryCondition.AslConditionOperator.EQ, AslUtils.findFieldForOwner(rightColumn, right.getSelect(), (AslQuery)rightOwner));
    }

    private static Stream<AslFieldFieldQueryCondition> numCapBetweenJoinConditions(AslQuery left, AslStructureQuery leftOwner, AslQuery right, AslStructureQuery rightOwner) {
        if (leftOwner.isRoot()) {
            return Stream.empty();
        }
        return Stream.of(new AslFieldFieldQueryCondition(AslUtils.findFieldForOwner(AslStructureColumn.NUM, left.getSelect(), (AslQuery)leftOwner), AslQueryCondition.AslConditionOperator.LT, AslUtils.findFieldForOwner(AslStructureColumn.NUM, right.getSelect(), (AslQuery)rightOwner)), new AslFieldFieldQueryCondition(AslUtils.findFieldForOwner(AslStructureColumn.NUM_CAP, left.getSelect(), (AslQuery)leftOwner), AslQueryCondition.AslConditionOperator.GT_EQ, AslUtils.findFieldForOwner(AslStructureColumn.NUM, right.getSelect(), (AslQuery)rightOwner)));
    }

    private static AslFieldFieldQueryCondition numEqualParentNumJoinCondition(AslQuery left, AslStructureQuery leftOwner, AslQuery right, AslStructureQuery rightOwner) {
        if (leftOwner.isRoot()) {
            return new AslFieldFieldQueryCondition(AslUtils.findFieldForOwner(AslStructureColumn.PARENT_NUM, right.getSelect(), (AslQuery)rightOwner), AslQueryCondition.AslConditionOperator.EQ, new AslConstantField<Integer>(Integer.class, 0, AslField.FieldSource.NONE, null));
        }
        return AslUtils.columnEqualToColumnJoinCondition(AslStructureColumn.NUM, left, leftOwner, AslStructureColumn.PARENT_NUM, right, rightOwner);
    }

    private static AslFieldFieldQueryCondition cItemNumJoinCondition(PathCohesionAnalysis.PathCohesionTreeNode leftNode, AslQuery left, AslStructureQuery leftOwner, AslQuery right, AslStructureQuery rightOwner) {
        if (leftOwner.isRoot()) {
            return new AslFieldFieldQueryCondition(AslUtils.findFieldForOwner(AslStructureColumn.C_ITEM_NUM, right.getSelect(), (AslQuery)rightOwner), AslQueryCondition.AslConditionOperator.EQ, new AslConstantField<Integer>(Integer.class, 0, AslField.FieldSource.NONE, null));
        }
        if (PathInfo.hasArchetypeAttribute(leftNode)) {
            return AslUtils.columnEqualToColumnJoinCondition(AslStructureColumn.NUM, left, leftOwner, AslStructureColumn.C_ITEM_NUM, right, rightOwner);
        }
        return AslUtils.columnEqualToColumnJoinCondition(AslStructureColumn.C_ITEM_NUM, left, leftOwner, AslStructureColumn.C_ITEM_NUM, right, rightOwner);
    }

    private static AslFieldFieldQueryCondition archetypeParentContainsCondition(AslQuery parent, AslStructureQuery parentOwner, AslQuery child, AslStructureQuery childOwner) {
        return new AslFieldFieldQueryCondition(AslUtils.findFieldForOwner(AslStructureColumn.NUM, parent.getSelect(), (AslQuery)parentOwner), AslQueryCondition.AslConditionOperator.EQ, AslUtils.findFieldForOwner(AslStructureColumn.C_ITEM_NUM, child.getSelect(), (AslQuery)childOwner));
    }

    private static AslFieldFieldQueryCondition atCodeParentContainsCondition(AslQuery parent, AslStructureQuery parentOwner, AslQuery child, AslStructureQuery childOwner) {
        return AslUtils.joinColumnEqualCondition(AslStructureColumn.C_ITEM_NUM, parent, parentOwner, child, childOwner);
    }

    private static Stream<AslFieldFieldQueryCondition> getContainsJoinConditions(AslQuery leftQuery, AslStructureQuery leftOwner, RmContainsWrapper leftWrapper, AslQuery rightQuery, AslStructureQuery rightOwner, RmContainsWrapper rightWrapper, boolean archetypeLocalNodePredicates) {
        if (!leftOwner.getType().getStructureRoot().isVersioned()) {
            return Stream.empty();
        }
        if (leftOwner.getType() != rightOwner.getType()) {
            throw new IllegalArgumentException("Unexpected relation type between %s and %s".formatted(new Object[]{leftOwner.getType(), rightOwner.getType()}));
        }
        if (!archetypeLocalNodePredicates || leftWrapper == null || !rightWrapper.isAtCode()) {
            return AslUtils.numCapBetweenJoinConditions(leftQuery, leftOwner, rightQuery, rightOwner);
        }
        if (leftWrapper.isArchetype()) {
            return Stream.of(AslUtils.archetypeParentContainsCondition(leftQuery, leftOwner, rightQuery, rightOwner));
        }
        if (leftWrapper.isAtCode()) {
            return AslUtils.concatStreams(Stream.of(AslUtils.atCodeParentContainsCondition(leftQuery, leftOwner, rightQuery, rightOwner)), AslUtils.numCapBetweenJoinConditions(leftQuery, leftOwner, rightQuery, rightOwner));
        }
        throw new IllegalArgumentException("Unexpected containment with node predicate without known archetype");
    }

    public static final class AliasProvider {
        private final Map<String, Integer> aliasCounters = new HashMap<String, Integer>();

        public String uniqueAlias(String alias) {
            return alias + "_" + String.valueOf(this.aliasCounters.compute(alias, (k, v) -> v == null ? 0 : v + 1));
        }
    }
}

