/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.featurecheck;

import java.lang.constant.Constable;
import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import org.ehrbase.api.exception.AqlFeatureNotImplementedException;
import org.ehrbase.api.exception.IllegalAqlException;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.openehr.aqlengine.aql.AqlQueryUtils;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.featurecheck.ClauseType;
import org.ehrbase.openehr.aqlengine.featurecheck.FeatureCheck;
import org.ehrbase.openehr.aqlengine.featurecheck.FeatureCheckUtils;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorSymbol;
import org.ehrbase.openehr.sdk.aql.dto.condition.ExistsCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LikeCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.MatchesCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.WhereCondition;
import org.ehrbase.openehr.sdk.aql.dto.operand.ComparisonLeftOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.operand.LikeOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;

final class WhereCheck
implements FeatureCheck {
    private final SystemService systemService;

    public WhereCheck(SystemService systemService) {
        this.systemService = systemService;
    }

    @Override
    public void ensureSupported(AqlQuery aqlQuery) {
        WhereCondition where = aqlQuery.getWhere();
        AqlQueryUtils.streamWhereConditions(where).forEach(c -> {
            WhereCondition whereCondition = c;
            Objects.requireNonNull(whereCondition);
            WhereCondition selector0$temp = whereCondition;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ComparisonOperatorCondition.class, LikeCondition.class, MatchesCondition.class, ExistsCondition.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    ComparisonOperatorCondition comp = (ComparisonOperatorCondition)selector0$temp;
                    this.ensureWhereComparisonConditionSupported(comp);
                    break;
                }
                case 1: {
                    LikeCondition like = (LikeCondition)selector0$temp;
                    this.ensureLikeConditionSupported(like);
                    break;
                }
                case 2: {
                    MatchesCondition matches = (MatchesCondition)selector0$temp;
                    this.ensureMatchesConditionSupported(matches);
                    break;
                }
                case 3: {
                    ExistsCondition exists = (ExistsCondition)selector0$temp;
                    WhereCheck.ensureExistsConditionSupported(exists);
                    break;
                }
                default: {
                    throw new IllegalAqlException("Unexpected condition type %s".formatted(c));
                }
            }
        });
    }

    private void ensureWhereComparisonConditionSupported(ComparisonOperatorCondition condition) {
        FeatureCheckUtils.PathDetails pathWithType;
        ComparisonLeftOperand conditionStatement = condition.getStatement();
        if (conditionStatement instanceof IdentifiedPath) {
            IdentifiedPath conditionField = (IdentifiedPath)conditionStatement;
            pathWithType = FeatureCheckUtils.findSupportedIdentifiedPath(conditionField, false, ClauseType.WHERE, this.systemService.getSystemId());
            if (conditionField.getPath().equals((Object)AslExtractedColumn.ARCHETYPE_NODE_ID.getPath()) && !EnumSet.of(ComparisonOperatorSymbol.EQ, ComparisonOperatorSymbol.NEQ).contains(condition.getSymbol())) {
                throw new AqlFeatureNotImplementedException("Conditions on 'archetype_node_id' only support =,!=, LIKE and MATCHES");
            }
            if (conditionField.getPath().equals((Object)AslExtractedColumn.TEMPLATE_ID.getPath()) && !EnumSet.of(ComparisonOperatorSymbol.EQ, ComparisonOperatorSymbol.NEQ).contains(condition.getSymbol())) {
                throw new AqlFeatureNotImplementedException("Conditions on 'archetype_details/template_id/value' only support =,!= and MATCHES");
            }
            if (pathWithType.extractedColumn() == AslExtractedColumn.OV_TIME_COMMITTED) {
                throw new AqlFeatureNotImplementedException("Conditions on %s of VERSION".formatted(conditionField.getPath().render()));
            }
            if (EnumSet.of(AslExtractedColumn.AD_CHANGE_TYPE_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_CODE_STRING, AslExtractedColumn.AD_CHANGE_TYPE_PREFERRED_TERM).contains((Object)pathWithType.extractedColumn()) && !EnumSet.of(ComparisonOperatorSymbol.EQ, ComparisonOperatorSymbol.NEQ).contains(condition.getSymbol())) {
                throw new AqlFeatureNotImplementedException("Conditions on %s of VERSION only support =,!= and MATCHES".formatted(conditionField.getPath().render()));
            }
        } else {
            throw new AqlFeatureNotImplementedException("Functions are not supported in WHERE");
        }
        FeatureCheckUtils.ensureOperandSupported(pathWithType, condition.getValue(), this.systemService.getSystemId());
    }

    private static void ensureExistsConditionSupported(ExistsCondition exists) {
        throw new AqlFeatureNotImplementedException("WHERE: EXISTS operator is not supported");
    }

    private void ensureMatchesConditionSupported(MatchesCondition matches) {
        FeatureCheckUtils.PathDetails pathWithType = FeatureCheckUtils.findSupportedIdentifiedPath(matches.getStatement(), false, ClauseType.WHERE, this.systemService.getSystemId());
        matches.getValues().forEach(operand -> FeatureCheckUtils.ensureOperandSupported(pathWithType, operand, this.systemService.getSystemId()));
    }

    private void ensureLikeConditionSupported(LikeCondition like) {
        AqlObjectPath path = like.getStatement().getPath();
        FeatureCheckUtils.findSupportedIdentifiedPath(like.getStatement(), false, ClauseType.WHERE, this.systemService.getSystemId());
        LikeOperand operand = like.getValue();
        if (AslExtractedColumn.VO_ID.getPath().equals((Object)path)) {
            throw new AqlFeatureNotImplementedException("LIKE on /uid/value is not supported");
        }
        if (!(operand instanceof Primitive)) {
            throw new AqlFeatureNotImplementedException("Only primitive operands are supported");
        }
        Primitive primitive = (Primitive)operand;
        Constable value = primitive.getValue();
        if (!(value instanceof String)) {
            throw new AqlFeatureNotImplementedException("LIKE must use String values");
        }
        String s = (String)((Object)value);
        if (AslExtractedColumn.ARCHETYPE_NODE_ID.getPath().equals((Object)path) && !s.matches("openEHR-EHR-[A-Z]+\\..*")) {
            throw new AqlFeatureNotImplementedException("LIKE on archetype_node_id has to start with 'openEHR-EHR-{RM-TYPE}.'");
        }
        if (AslExtractedColumn.TEMPLATE_ID.getPath().equals((Object)path)) {
            throw new AqlFeatureNotImplementedException("Conditions on 'archetype_details/template_id/value' only support =,!= and MATCHES");
        }
    }
}

