/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.querywrapper.select;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.ContainsWrapper;
import org.ehrbase.openehr.sdk.aql.dto.operand.AggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.CountDistinctAggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.dto.select.SelectExpression;

public final class SelectWrapper {
    private final SelectExpression selectExpression;
    private final SelectType type;
    private final ContainsWrapper root;

    public SelectWrapper(SelectExpression selectExpression, SelectType type, ContainsWrapper root) {
        this.selectExpression = selectExpression;
        this.type = type;
        this.root = root;
    }

    public String getSelectAlias() {
        return this.selectExpression.getAlias();
    }

    public Optional<IdentifiedPath> getIdentifiedPath() {
        return Optional.ofNullable(switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.selectExpression.getColumnExpression();
            case 1 -> null;
            case 2 -> ((AggregateFunction)this.selectExpression.getColumnExpression()).getIdentifiedPath();
            case 3 -> throw new UnsupportedOperationException("Not implemented");
        }).map(IdentifiedPath.class::cast);
    }

    public AggregateFunction.AggregateFunctionName getAggregateFunctionName() {
        if (this.type == SelectType.AGGREGATE_FUNCTION) {
            return ((AggregateFunction)this.selectExpression.getColumnExpression()).getFunctionName();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isCountDistinct() {
        if (this.type != SelectType.AGGREGATE_FUNCTION) {
            throw new UnsupportedOperationException();
        }
        return this.selectExpression.getColumnExpression() instanceof CountDistinctAggregateFunction;
    }

    public Primitive getPrimitive() {
        if (this.type != SelectType.PRIMITIVE) {
            throw new UnsupportedOperationException();
        }
        return (Primitive)this.selectExpression.getColumnExpression();
    }

    public Optional<String> getSelectPath() {
        if (this.type == SelectType.PATH) {
            return Optional.of(Stream.of(this.root.alias(), this.getIdentifiedPath().map(IdentifiedPath::getPath).map(AqlObjectPath::render).orElse(null)).filter(StringUtils::isNotBlank).collect(Collectors.joining("/")));
        }
        return Optional.empty();
    }

    public SelectExpression selectExpression() {
        return this.selectExpression;
    }

    public SelectType type() {
        return this.type;
    }

    public ContainsWrapper root() {
        return this.root;
    }

    public String toString() {
        return "SelectWrapper[selectExpression=" + String.valueOf(this.selectExpression) + ", type=" + String.valueOf((Object)this.type) + ", root=" + String.valueOf(this.root) + "]";
    }

    public static enum SelectType {
        PATH,
        PRIMITIVE,
        AGGREGATE_FUNCTION,
        FUNCTION;

    }
}

