/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.sql.postprocessor;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.time.temporal.TemporalAccessor;
import java.util.UUID;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.openehr.aqlengine.ChangeTypeUtils;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.sql.postprocessor.AqlSqlResultPostprocessor;
import org.ehrbase.openehr.dbformat.RmTypeAlias;
import org.ehrbase.openehr.sdk.util.OpenEHRDateTimeSerializationUtils;
import org.jooq.Record;

public class ExtractedColumnResultPostprocessor
implements AqlSqlResultPostprocessor {
    private final AslExtractedColumn extractedColumn;
    private final KnowledgeCacheService knowledgeCache;
    private final String nodeName;

    public ExtractedColumnResultPostprocessor(AslExtractedColumn extractedColumn, KnowledgeCacheService knowledgeCache, String nodeName) {
        this.extractedColumn = extractedColumn;
        this.knowledgeCache = knowledgeCache;
        this.nodeName = nodeName;
    }

    @Override
    public Object postProcessColumn(Object columnValue) {
        if (columnValue == null) {
            return null;
        }
        return switch (this.extractedColumn) {
            default -> throw new MatchException(null, null);
            case AslExtractedColumn.TEMPLATE_ID -> this.knowledgeCache.findTemplateIdByUuid((UUID)columnValue).orElse(null);
            case AslExtractedColumn.OV_TIME_COMMITTED_DV, AslExtractedColumn.EHR_TIME_CREATED_DV -> new DvDateTime((TemporalAccessor)columnValue);
            case AslExtractedColumn.OV_TIME_COMMITTED, AslExtractedColumn.EHR_TIME_CREATED -> OpenEHRDateTimeSerializationUtils.formatDateTime((TemporalAccessor)((TemporalAccessor)columnValue));
            case AslExtractedColumn.AD_DESCRIPTION_DV -> new DvText((String)columnValue);
            case AslExtractedColumn.AD_CHANGE_TYPE_DV -> ExtractedColumnResultPostprocessor.contributionChangeTypeAsDvCodedText((ContributionChangeType)columnValue);
            case AslExtractedColumn.AD_CHANGE_TYPE_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_PREFERRED_TERM -> ((ContributionChangeType)columnValue).getLiteral().toLowerCase();
            case AslExtractedColumn.AD_CHANGE_TYPE_CODE_STRING -> ChangeTypeUtils.getCodeByJooqChangeType((ContributionChangeType)columnValue);
            case AslExtractedColumn.VO_ID -> ExtractedColumnResultPostprocessor.restoreVoId((Record)columnValue, this.nodeName);
            case AslExtractedColumn.ROOT_CONCEPT -> "openEHR-EHR-COMPOSITION" + String.valueOf(columnValue);
            case AslExtractedColumn.ARCHETYPE_NODE_ID -> ExtractedColumnResultPostprocessor.restoreArchetypeNodeId((Record)columnValue);
            case AslExtractedColumn.EHR_SYSTEM_ID_DV -> new HierObjectId((String)columnValue);
            case AslExtractedColumn.NAME_VALUE, AslExtractedColumn.EHR_ID, AslExtractedColumn.OV_CONTRIBUTION_ID, AslExtractedColumn.AD_SYSTEM_ID, AslExtractedColumn.AD_DESCRIPTION_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_TERMINOLOGY_ID_VALUE, AslExtractedColumn.EHR_SYSTEM_ID -> columnValue;
        };
    }

    private static String restoreArchetypeNodeId(Record srcRow) {
        String entityConcept = (String)srcRow.get(0);
        if (!entityConcept.startsWith(".")) {
            return entityConcept;
        }
        String rmType = RmTypeAlias.getRmType((String)((String)srcRow.get(1)));
        return "openEHR-EHR-" + rmType + entityConcept;
    }

    private static String restoreVoId(Record srcRow, String nodeName) {
        Object id = srcRow.get(0);
        if (id == null) {
            return null;
        }
        return String.valueOf(id) + "::" + nodeName + "::" + String.valueOf(srcRow.get(1));
    }

    private static DvCodedText contributionChangeTypeAsDvCodedText(ContributionChangeType changeType) {
        return new DvCodedText(changeType.getLiteral().toLowerCase(), new CodePhrase(new TerminologyId("openehr"), ChangeTypeUtils.getCodeByJooqChangeType(changeType), changeType.getLiteral().toLowerCase()));
    }
}

