/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.openehr.util.TreeNode;

public class TreeUtils {
    public static <T extends TreeNode<T>> String renderTree(T root, Comparator<T> childOrder, Function<T, String> nodeRenderer) {
        StringBuilder sb = new StringBuilder();
        TreeUtils.renderTreeNode(root, sb, 0, childOrder, nodeRenderer);
        return sb.toString();
    }

    private static <T extends TreeNode<T>> void renderTreeNode(T node, StringBuilder sb, int level, Comparator<T> childOrder, Function<T, String> nodeRenderer) {
        if (!sb.isEmpty()) {
            sb.append("\n");
        }
        for (int l = 0; l < level; ++l) {
            sb.append("  ");
        }
        String nodeStr = nodeRenderer.apply(node);
        if (StringUtils.isBlank((CharSequence)nodeStr)) {
            throw new IllegalArgumentException("rendered node must not be blank");
        }
        if (Pattern.compile("^\\s").matcher(nodeStr).find()) {
            throw new IllegalArgumentException("rendered node must not start with whitespace");
        }
        if (Pattern.compile("\\R").matcher(nodeStr).find()) {
            throw new IllegalArgumentException("rendered node must not contain line breaks");
        }
        sb.append(nodeStr);
        Stream<T> childStream = node.streamChildren();
        if (childOrder != null) {
            childStream = childStream.sorted(childOrder);
        }
        childStream.forEach(n -> TreeUtils.renderTreeNode(n, sb, level + 1, childOrder, nodeRenderer));
    }

    public static <T extends TreeNode<T>> T parseTree(String treeGraph, Function<String, T> nodeParser) {
        TreeNode root;
        Pattern p = Pattern.compile("((?:  )*)(.+)");
        Iterator it = treeGraph.lines().map(l -> {
            Matcher matcher = p.matcher((CharSequence)l);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("illegal line: %s".formatted(l));
            }
            return matcher;
        }).map(m -> Pair.of((Object)(m.group(1).length() / 2), (Object)m.group(2))).iterator();
        TreeNode lastNode = root = (TreeNode)nodeParser.apply((String)((Pair)it.next()).getRight());
        int lastLevel = 0;
        while (it.hasNext()) {
            Pair next = (Pair)it.next();
            int level = (Integer)next.getLeft();
            if (level <= 0) {
                throw new IllegalArgumentException("Only one root allowed: %s".formatted(next.getRight()));
            }
            int parentLevel = level - 1;
            if (parentLevel > lastLevel) {
                throw new IllegalArgumentException("Inconsistent level of %s: %d >>  %d".formatted(next.getRight(), level, lastLevel));
            }
            TreeNode parent = lastNode;
            for (int i = lastLevel; i > parentLevel; --i) {
                parent = parent.parent;
            }
            lastNode = parent.addChild((TreeNode)nodeParser.apply((String)next.getRight()));
            lastLevel = level;
        }
        return (T)root;
    }
}

