/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.sql;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.util.AdditionalSQLFunctions;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslAggregatingField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslConstantField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslEncapsulatingQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslFilteringQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslPathDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRmObjectDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.sql.ConditionUtils;
import org.ehrbase.openehr.aqlengine.sql.EncapsulatingQueryUtils;
import org.ehrbase.openehr.aqlengine.sql.FieldUtils;
import org.ehrbase.openehr.aqlengine.sql.postprocessor.AqlSqlQueryPostProcessor;
import org.ehrbase.openehr.dbformat.RmAttributeAlias;
import org.ehrbase.openehr.dbformat.jooq.prototypes.ObjectDataTablePrototype;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.JSONB;
import org.jooq.JSONObjectAggNullStep;
import org.jooq.JoinType;
import org.jooq.Operator;
import org.jooq.OrderField;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.SelectJoinStep;
import org.jooq.SelectQuery;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AqlSqlQueryBuilder {
    private final DSLContext context;
    private final KnowledgeCacheService knowledgeCache;
    private final Optional<AqlSqlQueryPostProcessor> queryPostProcessor;
    @Value(value="${ehrbase.aql.pg-llj-workaround:true}")
    private boolean pgLljWorkaround = true;

    public AqlSqlQueryBuilder(DSLContext context, KnowledgeCacheService knowledgeCache, Optional<AqlSqlQueryPostProcessor> queryPostProcessor) {
        this.context = context;
        this.knowledgeCache = knowledgeCache;
        this.queryPostProcessor = queryPostProcessor;
    }

    public static String subqueryAlias(AslQuery aslQuery) {
        return aslQuery.getAlias() + "sq";
    }

    public static String versionSubqueryAlias(AslQuery aslQuery) {
        return aslQuery.getAlias() + "_version_sq";
    }

    public SelectQuery<Record> buildSqlQuery(AslRootQuery aslRootQuery) {
        AslQueryTables aslQueryToTable = new AslQueryTables();
        SelectJoinStep<Record> encapsulatingQuery = this.buildEncapsulatingQuery(aslRootQuery, () -> this.context.select(new SelectFieldOrAsterisk[0]), aslQueryToTable);
        SelectQuery query = encapsulatingQuery.getQuery();
        if (aslRootQuery.getLimit() != null) {
            query.addLimit((Number)(aslRootQuery.getOffset() == null ? 0L : aslRootQuery.getOffset()), (Number)aslRootQuery.getLimit());
        }
        this.queryPostProcessor.ifPresent(p -> p.afterBuildSqlQuery(aslRootQuery, (SelectQuery<Record>)query));
        return query;
    }

    public Result<Record> explain(boolean analyze, SelectQuery<Record> selectQuery) {
        if (analyze) {
            return this.context.fetch("EXPLAIN (SUMMARY, COSTS, VERBOSE, FORMAT JSON, ANALYZE, TIMING) {0}", new QueryPart[]{selectQuery});
        }
        return this.context.fetch("EXPLAIN (SUMMARY, COSTS, VERBOSE, FORMAT JSON) {0}", new QueryPart[]{selectQuery});
    }

    @Nonnull
    private SelectJoinStep<Record> buildEncapsulatingQuery(AslEncapsulatingQuery aq, Supplier<SelectSelectStep<Record>> creator, AslQueryTables aslQueryToTable) {
        Iterator<Pair<AslQuery, AslJoin>> childIt = aq.getChildren().iterator();
        AslQuery aslRoot = (AslQuery)childIt.next().getLeft();
        Table<?> root = this.buildQuery(aslRoot, null, aslQueryToTable);
        aslQueryToTable.put(aslRoot, root, root);
        SelectJoinStep from = creator.get().from(root);
        while (childIt.hasNext()) {
            Pair<AslQuery, AslJoin> nextChild = childIt.next();
            AslQuery childQuery = (AslQuery)nextChild.getLeft();
            AslJoin join = (AslJoin)nextChild.getRight();
            AslQuery target = join.getLeft();
            Table<?> toJoin = this.buildQuery(childQuery, target, aslQueryToTable);
            if (this.pgLljWorkaround) {
                EncapsulatingQueryUtils.applyPgLljWorkaround(childQuery, join, toJoin);
            }
            aslQueryToTable.put(childQuery, toJoin, toJoin);
            from.join(toJoin, join.getJoinType()).on(ConditionUtils.buildJoinCondition(join, aslQueryToTable));
        }
        SelectQuery query = from.getQuery();
        for (AslField field : aq.getSelect()) {
            SelectField<?> sqlField = EncapsulatingQueryUtils.selectField(field, aslQueryToTable);
            query.addSelect(new SelectFieldOrAsterisk[]{sqlField});
        }
        query.addConditions(Operator.AND, Stream.concat(Optional.of(aq).map(AslQuery::getCondition).stream(), aq.getStructureConditions().stream()).map(c -> ConditionUtils.buildCondition(c, aslQueryToTable, true)).toList());
        if (aq instanceof AslRootQuery) {
            AslRootQuery rq = (AslRootQuery)aq;
            rq.getGroupByFields().stream().flatMap(gb -> EncapsulatingQueryUtils.groupByFields(gb, aslQueryToTable)).forEach(xva$0 -> query.addGroupBy(new GroupField[]{xva$0}));
            rq.getGroupByDvOrderedMagnitudeFields().stream().map(f -> AdditionalSQLFunctions.jsonb_dv_ordered_magnitude(FieldUtils.field(aslQueryToTable.getDataTable(f.getInternalProvider()), f, true))).forEach(xva$0 -> query.addGroupBy(new GroupField[]{xva$0}));
            rq.getOrderByFields().stream().flatMap(ob -> EncapsulatingQueryUtils.orderFields(ob, aslQueryToTable, this.knowledgeCache)).forEach(xva$0 -> query.addOrderBy(new OrderField[]{xva$0}));
        }
        return from;
    }

    private Table<?> buildQuery(AslQuery aslQuery, AslQuery target, AslQueryTables aslQueryToTable) {
        AslQuery aslQuery2 = aslQuery;
        Objects.requireNonNull(aslQuery2);
        AslQuery aslQuery3 = aslQuery2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslStructureQuery.class, AslEncapsulatingQuery.class, AslRmObjectDataQuery.class, AslFilteringQuery.class, AslPathDataQuery.class}, (Object)aslQuery3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslStructureQuery aq = (AslStructureQuery)aslQuery3;
                yield AqlSqlQueryBuilder.buildStructureQuery(aq, aslQueryToTable).asTable(aq.getAlias());
            }
            case 1 -> {
                AslEncapsulatingQuery aq = (AslEncapsulatingQuery)aslQuery3;
                yield DSL.lateral(this.buildEncapsulatingQuery(aq, () -> DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]), aslQueryToTable)).asTable(aq.getAlias());
            }
            case 2 -> {
                AslRmObjectDataQuery aq = (AslRmObjectDataQuery)aslQuery3;
                yield DSL.lateral((TableLike)AqlSqlQueryBuilder.buildDataSubquery(aq, aslQueryToTable).asTable(aq.getAlias()));
            }
            case 3 -> {
                AslFilteringQuery aq = (AslFilteringQuery)aslQuery3;
                yield DSL.lateral((TableLike)AqlSqlQueryBuilder.buildFilteringQuery(aq, aslQueryToTable.getDataTable(target)).asTable(aq.getAlias()));
            }
            case 4 -> {
                AslPathDataQuery aq = (AslPathDataQuery)aslQuery3;
                yield DSL.lateral((TableLike)AqlSqlQueryBuilder.buildPathDataQuery(aq, target, aslQueryToTable).asTable(aq.getAlias()));
            }
        };
    }

    private static AslStructureQuery.AslSourceRelation getTargetType(AslQuery target) {
        if (target instanceof AslStructureQuery) {
            AslStructureQuery sq = (AslStructureQuery)target;
            return sq.getType();
        }
        throw new IllegalArgumentException("target is no StructureQuery: %s".formatted(target));
    }

    private static TableLike<Record> buildPathDataQuery(AslPathDataQuery aslData, AslQuery target, AslQueryTables aslQueryToTable) {
        Function<String, Field> dataFieldProvider;
        Table data;
        Table targetTable = aslQueryToTable.getDataTable(target);
        AslQuery base = aslData.getBase();
        if (base instanceof AslStructureQuery) {
            AslStructureQuery baseSq = (AslStructureQuery)base;
            data = baseSq.getType().getDataTable().as(AqlSqlQueryBuilder.subqueryAlias(aslData));
            dataFieldProvider = __ -> data.field((Field)ObjectDataTablePrototype.INSTANCE.DATA);
        } else {
            data = targetTable;
            dataFieldProvider = colName -> FieldUtils.aliasedField(data, aslData, colName, JSONB.class);
        }
        SelectSelectStep select = DSL.select(aslData.getSelect().stream().map(AslColumnField.class::cast).map(f -> AqlSqlQueryBuilder.pathDataField(aslData, f, dataFieldProvider)).toList());
        if (base instanceof AslStructureQuery) {
            List<Condition> pkeyCondition = data.getPrimaryKey().getFields().stream().map(f -> FieldUtils.aliasedField(targetTable, aslData, f).eq(data.field((Field)f))).toList();
            return select.from((TableLike)data).where(pkeyCondition);
        }
        return select;
    }

    @Nonnull
    private static Field pathDataField(AslPathDataQuery aslData, AslColumnField f, Function<String, Field<JSONB>> dataFieldProvider) {
        Field<JSONB> dataField = dataFieldProvider.apply(f.getColumnName());
        Field jsonbField = AqlSqlQueryBuilder.buildJsonbPathField(aslData.getPathNodes(f), aslData.isMultipleValued(), dataField);
        Field field = f.getType() == String.class ? DSL.jsonbGetElementAsText(jsonbField, (int)0) : jsonbField;
        return field.as(f.getName(true));
    }

    private static Field<JSONB> buildJsonbPathField(List<AqlObjectPath.PathNode> pathNodes, boolean multipleValued, Field<JSONB> jsonbField) {
        Iterator attributeIt = pathNodes.stream().map(AqlObjectPath.PathNode::getAttribute).map(RmAttributeAlias::getAlias).iterator();
        Field field = jsonbField;
        while (attributeIt.hasNext()) {
            field = DSL.jsonbGetAttribute((Field)field, (Field)DSL.inline((String)((String)attributeIt.next())));
        }
        if (multipleValued) {
            field = AdditionalSQLFunctions.jsonb_array_elements(field);
        }
        return field;
    }

    private static SelectSelectStep<?> buildFilteringQuery(AslFilteringQuery aq, Table<?> target) {
        AslField aslField = aq.getSourceField();
        Objects.requireNonNull(aslField);
        AslField aslField2 = aslField;
        int n = 0;
        Stream<Param> fields = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslColumnField.class, AslComplexExtractedColumnField.class, AslConstantField.class, AslAggregatingField.class}, (Object)aslField2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslColumnField src = (AslColumnField)aslField2;
                yield Stream.of(FieldUtils.field(target, src, true).as(((AslColumnField)aq.getSelect().getFirst()).getAliasedName()));
            }
            case 1 -> {
                AslComplexExtractedColumnField src = (AslComplexExtractedColumnField)aslField2;
                yield src.getExtractedColumn().getColumns().stream().map(fieldName -> FieldUtils.field(target, src, fieldName, true).as(src.aliasedName((String)fieldName)));
            }
            case 2 -> {
                AslConstantField cf = (AslConstantField)aslField2;
                yield Stream.of(DSL.inline(cf.getValue(), cf.getType()));
            }
            case 3 -> {
                AslAggregatingField __ = (AslAggregatingField)aslField2;
                throw new IllegalArgumentException("Filtering queries cannot be based on AslAggregatingField");
            }
        };
        return DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])fields.toArray(Field[]::new)));
    }

    @Nonnull
    private static SelectConditionStep<Record> buildStructureQuery(AslStructureQuery aq, AslQueryTables aslQueryToTable) {
        Table dataTable = aq.getType().getDataTable().as(AqlSqlQueryBuilder.subqueryAlias(aq));
        Table primaryTable = aq.isRequiresVersionTableJoin() ? aq.getType().getVersionTable().as(AqlSqlQueryBuilder.versionSubqueryAlias(aq)) : dataTable;
        SelectJoinStep<Record> step = AqlSqlQueryBuilder.structureQueryBase(aq, primaryTable, dataTable, aq.isRequiresVersionTableJoin());
        aslQueryToTable.put(aq, dataTable, primaryTable);
        SelectConditionStep where = step.where((Condition[])Stream.concat(Optional.of(aq).map(AslQuery::getCondition).stream(), aq.getStructureConditions().stream()).map(c -> ConditionUtils.buildCondition(c, aslQueryToTable, false)).toArray(Condition[]::new));
        aslQueryToTable.remove(aq);
        return where;
    }

    @Nonnull
    private static SelectJoinStep<Record> structureQueryBase(AslStructureQuery aq, Table<?> primaryTable, Table<?> dataTable, boolean hasVersionTable) {
        SelectJoinStep step = DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])aq.getSelect().stream().map(AslColumnField.class::cast).map(f -> (aq.isRequiresVersionTableJoin() && f.isVersionTableField() ? primaryTable : dataTable).field(f.getColumnName()).as(f.getAliasedName())).toArray(SelectFieldOrAsterisk[]::new))).from(primaryTable);
        if (hasVersionTable) {
            step = switch (aq.getType()) {
                default -> throw new MatchException(null, null);
                case AslStructureQuery.AslSourceRelation.EHR, AslStructureQuery.AslSourceRelation.AUDIT_DETAILS -> throw new IllegalArgumentException("%s has no version table".formatted(new Object[]{aq.getType()}));
                case AslStructureQuery.AslSourceRelation.EHR_STATUS -> step.join(dataTable, JoinType.JOIN).on(primaryTable.field((Field)Tables.EHR_STATUS_VERSION.EHR_ID).eq(dataTable.field((Field)Tables.EHR_STATUS_DATA.EHR_ID)));
                case AslStructureQuery.AslSourceRelation.COMPOSITION -> step.join(dataTable, JoinType.JOIN).on(primaryTable.field((Field)Tables.COMP_VERSION.VO_ID).eq(dataTable.field((Field)Tables.COMP_DATA.VO_ID)));
                case AslStructureQuery.AslSourceRelation.FOLDER -> step.join(dataTable, JoinType.JOIN).on(primaryTable.field((Field)Tables.EHR_FOLDER_VERSION.EHR_ID).eq(dataTable.field((Field)Tables.EHR_FOLDER_DATA.EHR_ID)).and(primaryTable.field((Field)Tables.EHR_FOLDER_VERSION.EHR_FOLDERS_IDX).eq(dataTable.field((Field)Tables.EHR_FOLDER_DATA.EHR_FOLDERS_IDX))));
            };
        }
        return step;
    }

    private static SelectHavingStep<Record1<JSONB>> buildDataSubquery(AslRmObjectDataQuery aslData, AslQueryTables aslQueryToTable) {
        AslQuery target = aslData.getBaseProvider();
        Table<?> targetTable = aslQueryToTable.getDataTable(target);
        AslStructureQuery.AslSourceRelation type = AqlSqlQueryBuilder.getTargetType(aslData.getBase());
        Table data = type.getDataTable().as(AqlSqlQueryBuilder.subqueryAlias(aslData));
        String dataFieldName = ((AslColumnField)aslData.getSelect().getFirst()).getName(true);
        Field jsonbField = AqlSqlQueryBuilder.dataAggregation(data, FieldUtils.aliasedField(targetTable, aslData, Tables.COMP_DATA.ENTITY_IDX)).as(DSL.name((String)dataFieldName));
        SelectJoinStep from = DSL.select((SelectField)jsonbField).from((TableLike)data);
        List<Field> pKeyFields = type.getPkeyFields().stream().map(field -> {
            Field f = data.field((Field)field);
            from.where(FieldUtils.aliasedField(targetTable, aslData, field).eq(f));
            return f;
        }).toList();
        return from.where(new Condition[]{FieldUtils.aliasedField(targetTable, aslData, Tables.COMP_DATA.ENTITY_IDX).le(data.field((Field)Tables.COMP_DATA.ENTITY_IDX)), FieldUtils.aliasedField(targetTable, aslData, Tables.COMP_DATA.ENTITY_IDX_CAP).gt(data.field((Field)Tables.COMP_DATA.ENTITY_IDX))}).groupBy(pKeyFields);
    }

    private static JSONObjectAggNullStep<JSONB> dataAggregation(Table<?> dataTable, Field<String> baseEntityIndex) {
        return DSL.jsonbObjectAgg((Field)DSL.substring((Field)dataTable.field((Field)Tables.COMP_DATA.ENTITY_IDX), (Field)DSL.length(baseEntityIndex).plus((Field)DSL.inline((int)1))), (Field)dataTable.field((Field)Tables.COMP_DATA.DATA));
    }

    static class AslQueryTables {
        private Map<AslQuery, Table<?>> dataTables = new HashMap();
        private Map<AslQuery, Table<?>> versionTables = new HashMap();

        private AslQueryTables() {
        }

        Table<?> getDataTable(AslQuery q) {
            return this.dataTables.get(q);
        }

        Table<?> getVersionTable(AslQuery q) {
            return this.versionTables.get(q);
        }

        public void put(AslQuery q, Table<?> dataTable, Table<?> versionTable) {
            this.dataTables.put(q, dataTable);
            this.versionTables.put(q, versionTable);
        }

        public void remove(AslStructureQuery aq) {
            this.dataTables.remove(aq);
            this.versionTables.remove(aq);
        }
    }
}

