/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl.model.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslAndQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslOrQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslPathFilterJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslEncapsulatingQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslFilteringQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;

public abstract sealed class AslQuery
permits AslDataQuery, AslEncapsulatingQuery, AslFilteringQuery, AslStructureQuery {
    protected List<AslQueryCondition> structureConditions;
    private final String alias;
    private AslQueryCondition condition;

    protected AslQuery(String alias, List<AslQueryCondition> structureConditions) {
        this.alias = alias;
        this.structureConditions = structureConditions;
    }

    public abstract Map<IdentifiedPath, List<AslPathFilterJoinCondition>> joinConditionsForFiltering();

    public abstract List<AslField> getSelect();

    public String getAlias() {
        return this.alias;
    }

    public AslQueryCondition getCondition() {
        return this.condition;
    }

    public void setCondition(AslQueryCondition condition) {
        this.condition = condition;
    }

    public AslQuery addConditionAnd(AslQueryCondition toAdd) {
        if (this.condition == null) {
            this.condition = toAdd;
        } else {
            AslQueryCondition aslQueryCondition = this.condition;
            if (aslQueryCondition instanceof AslAndQueryCondition) {
                AslAndQueryCondition and = (AslAndQueryCondition)aslQueryCondition;
                and.getOperands().add(toAdd);
            } else {
                this.condition = new AslAndQueryCondition(this.condition, toAdd);
            }
        }
        return this;
    }

    public AslQuery addConditionOr(AslQueryCondition toAdd) {
        if (this.condition == null) {
            this.condition = toAdd;
        } else {
            AslQueryCondition aslQueryCondition = this.condition;
            if (aslQueryCondition instanceof AslOrQueryCondition) {
                AslOrQueryCondition or = (AslOrQueryCondition)aslQueryCondition;
                or.getOperands().add(toAdd);
            } else {
                this.condition = new AslOrQueryCondition(this.condition, toAdd);
            }
        }
        return this;
    }

    public List<AslQueryCondition> getStructureConditions() {
        return Collections.unmodifiableList(this.structureConditions);
    }
}

