/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.pathanalysis;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ehrbase.openehr.aqlengine.pathanalysis.FoundationType;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathAnalysis;
import org.ehrbase.openehr.dbformat.StructureRmType;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPathUtil;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;

public class ANode {
    Set<String> candidateTypes;
    final Map<String, ANode> attributes = new LinkedHashMap<String, ANode>();

    public Set<NodeCategory> getCategories() {
        if (this.candidateTypes == null) {
            throw new IllegalStateException("The candidate types have not been calculated");
        }
        EnumSet<NodeCategory> result = EnumSet.noneOf(NodeCategory.class);
        this.candidateTypes.stream().map(ANode::getCategory).forEach(result::add);
        return result;
    }

    private static NodeCategory getCategory(String typeName) {
        return StructureRmType.byTypeName((String)typeName).map(t -> t.isStructureEntry() ? NodeCategory.STRUCTURE : NodeCategory.STRUCTURE_INTERMEDIATE).orElseGet(() -> FoundationType.byTypeName(typeName).map(t -> NodeCategory.FOUNDATION).orElse(NodeCategory.RM_TYPE));
    }

    public ANode(String rmType, List<AndOperatorPredicate> parentPredicates, List<AndOperatorPredicate> predicates) {
        this(rmType == null ? null : Set.of(rmType), parentPredicates, predicates);
    }

    public ANode(Set<String> rmTypes, List<AndOperatorPredicate> parentPredicates, List<AndOperatorPredicate> predicates) {
        this.candidateTypes = rmTypes == null ? null : rmTypes.stream().flatMap(PathAnalysis::resolveConcreteTypeNames).collect(Collectors.toSet());
        this.constrainByArchetype(parentPredicates);
        this.constrainByArchetype(predicates);
        this.addPredicateConstraints(parentPredicates);
        this.addPredicateConstraints(predicates);
    }

    public ANode getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public Set<String> getCandidateTypes() {
        return new HashSet<String>(this.candidateTypes);
    }

    public void addPredicateConstraints(List<AndOperatorPredicate> predicates) {
        Iterator it = Optional.ofNullable(predicates).filter(p -> p.size() == 1).map(List::getFirst).map(AndOperatorPredicate::getOperands).stream().flatMap(Collection::stream).filter(p -> !EnumSet.of(ComparisonOperatorPredicate.PredicateComparisonOperator.NEQ, ComparisonOperatorPredicate.PredicateComparisonOperator.MATCHES).contains(p.getOperator())).iterator();
        while (it.hasNext()) {
            ComparisonOperatorPredicate p2 = (ComparisonOperatorPredicate)it.next();
            PathAnalysis.appendPath(this, p2.getPath(), PathAnalysis.getCandidateTypes(p2.getValue()));
        }
    }

    public void constrainByArchetype(List<AndOperatorPredicate> predicates) {
        this.candidateTypes = ANode.constrainByArchetype(this.candidateTypes, predicates);
    }

    public static Set<String> constrainByArchetype(Set<String> candidateTypes, List<AndOperatorPredicate> predicates) {
        boolean singleAnd;
        if (predicates == null || candidateTypes != null && candidateTypes.isEmpty()) {
            return candidateTypes;
        }
        boolean bl = singleAnd = predicates.size() == 1;
        if (singleAnd) {
            return ANode.constrainByArchetype(candidateTypes, predicates.getFirst());
        }
        Set<String> constraintUnion = null;
        Iterator<AndOperatorPredicate> it = predicates.iterator();
        while (it.hasNext() || constraintUnion != null && constraintUnion.isEmpty()) {
            Set<String> candidateSet = Optional.ofNullable(candidateTypes).map(HashSet::new).orElse(null);
            if ((candidateSet = ANode.constrainByArchetype(candidateSet, it.next())) == null) continue;
            if (constraintUnion == null) {
                constraintUnion = candidateSet;
                continue;
            }
            constraintUnion.addAll(candidateSet);
        }
        if (constraintUnion == null) {
            return candidateTypes;
        }
        if (candidateTypes == null) {
            return constraintUnion;
        }
        candidateTypes.retainAll(constraintUnion);
        return candidateTypes;
    }

    public static Set<String> constrainByArchetype(Set<String> candidateTypes, AndOperatorPredicate predicates) {
        Set<String> constrained = candidateTypes;
        Iterator it = predicates.getOperands().iterator();
        while (it.hasNext() && (constrained == null || !constrained.isEmpty())) {
            String archetypeNodeId = ANode.getArchetypeNodeId((ComparisonOperatorPredicate)it.next()).orElse(null);
            if (archetypeNodeId == null) continue;
            constrained = ANode.constrainByArchetype(constrained, archetypeNodeId);
        }
        return candidateTypes;
    }

    private static Optional<String> getArchetypeNodeId(ComparisonOperatorPredicate cmpOp) {
        return Optional.of(cmpOp).filter(p -> p.getOperator() == ComparisonOperatorPredicate.PredicateComparisonOperator.EQ).filter(p -> AqlObjectPathUtil.ARCHETYPE_NODE_ID.equals((Object)p.getPath())).map(ComparisonOperatorPredicate::getValue).filter(StringPrimitive.class::isInstance).map(StringPrimitive.class::cast).map(Primitive::getValue);
    }

    static Set<String> constrainByArchetype(Set<String> candidateTypes, String archetypeNodeId) {
        return PathAnalysis.rmTypeFromArchetype(archetypeNodeId).map(PathAnalysis::resolveConcreteTypeNames).map(s -> s.collect(Collectors.toSet())).map(s -> {
            if (candidateTypes == null) {
                return s;
            }
            candidateTypes.retainAll((Collection<?>)s);
            return candidateTypes;
        }).orElse(candidateTypes);
    }

    public static enum NodeCategory {
        STRUCTURE,
        STRUCTURE_INTERMEDIATE,
        RM_TYPE,
        FOUNDATION,
        FOUNDATION_EXTENDED;

    }
}

