/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.querywrapper.where;

import java.util.List;
import java.util.function.Function;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslAndQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFalseQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslOrQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslTrueQueryCondition;
import org.ehrbase.openehr.aqlengine.querywrapper.where.ComparisonOperatorConditionWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.LogicalOperatorConditionWrapper;

public sealed interface ConditionWrapper
permits ComparisonOperatorConditionWrapper, LogicalOperatorConditionWrapper {

    public static enum ComparisonConditionOperator {
        EXISTS(AslQueryCondition.AslConditionOperator.IS_NOT_NULL),
        LIKE(AslQueryCondition.AslConditionOperator.LIKE),
        MATCHES(AslQueryCondition.AslConditionOperator.IN),
        EQ(AslQueryCondition.AslConditionOperator.EQ),
        NEQ(AslQueryCondition.AslConditionOperator.NEQ),
        GT_EQ(AslQueryCondition.AslConditionOperator.GT_EQ),
        GT(AslQueryCondition.AslConditionOperator.GT),
        LT_EQ(AslQueryCondition.AslConditionOperator.LT_EQ),
        LT(AslQueryCondition.AslConditionOperator.LT);

        private final AslQueryCondition.AslConditionOperator aslOperator;

        private ComparisonConditionOperator(AslQueryCondition.AslConditionOperator aslOperator) {
            this.aslOperator = aslOperator;
        }

        public AslQueryCondition.AslConditionOperator getAslOperator() {
            return this.aslOperator;
        }

        public ComparisonConditionOperator negate() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1, 2 -> throw new UnsupportedOperationException("No operator known to  represent negated " + String.valueOf((Object)this));
                case 3 -> NEQ;
                case 4 -> EQ;
                case 5 -> LT;
                case 6 -> LT_EQ;
                case 7 -> GT;
                case 8 -> GT_EQ;
            };
        }

        public static ComparisonConditionOperator valueOf(String name, boolean negated) {
            ComparisonConditionOperator operator = ComparisonConditionOperator.valueOf(name);
            return negated ? operator.negate() : operator;
        }
    }

    public static enum LogicalConditionOperator {
        AND(AslAndQueryCondition::new, AslTrueQueryCondition.class, AslFalseQueryCondition.class),
        OR(AslOrQueryCondition::new, AslFalseQueryCondition.class, AslTrueQueryCondition.class),
        NOT(l -> l.stream().findFirst().map(AslNotQueryCondition::new).orElse(null), Void.class, Void.class);

        private final Function<List<AslQueryCondition>, AslQueryCondition> setOperator;
        private final Class<?> noopCondition;
        private final Class<?> shortCircuitCondition;

        private LogicalConditionOperator(Function<List<AslQueryCondition>, AslQueryCondition> setOperator, Class<?> noopCondition, Class<?> shortCircuitCondition) {
            this.setOperator = setOperator;
            this.noopCondition = noopCondition;
            this.shortCircuitCondition = shortCircuitCondition;
        }

        public AslQueryCondition build(List<AslQueryCondition> params) {
            return this.setOperator.apply(params);
        }

        public boolean filterNotNoop(AslQueryCondition condition) {
            return !this.noopCondition.isInstance(condition);
        }

        public boolean filterShortCircuit(AslQueryCondition condition) {
            return this.shortCircuitCondition.isInstance(condition);
        }
    }
}

