/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl.model.query;

import com.nedap.archie.rm.archetyped.Locatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.openehr.aqlengine.asl.AslUtils;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslPathFilterJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.dbformat.RmAttributeAlias;
import org.ehrbase.openehr.dbformat.StructureRmType;
import org.ehrbase.openehr.dbformat.StructureRoot;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.jooq.Table;
import org.jooq.TableField;

public final class AslStructureQuery
extends AslQuery {
    public static final String ENTITY_ATTRIBUTE = "entity_attribute";
    private static final Set<String> NON_LOCATABLE_STRUCTURE_RM_TYPES = Arrays.stream(StructureRmType.values()).filter(StructureRmType::isStructureEntry).filter(s -> !Locatable.class.isAssignableFrom(s.type)).map(StructureRmType::getAlias).collect(Collectors.toSet());
    private final Map<IdentifiedPath, AslPathFilterJoinCondition> joinConditionsForFiltering = new HashMap<IdentifiedPath, AslPathFilterJoinCondition>();
    private final AslSourceRelation type;
    private final Collection<String> rmTypes;
    private final List<AslField> fields = new ArrayList<AslField>();
    private final String alias;
    private final boolean requiresVersionTableJoin;
    private boolean representsOriginalVersionExpression = false;

    public boolean isRequiresVersionTableJoin() {
        return this.requiresVersionTableJoin;
    }

    public boolean isRepresentsOriginalVersionExpression() {
        return this.representsOriginalVersionExpression;
    }

    public void setRepresentsOriginalVersionExpression(boolean representsOriginalVersionExpression) {
        this.representsOriginalVersionExpression = representsOriginalVersionExpression;
    }

    public AslStructureQuery(String alias, AslSourceRelation type, List<AslField> fields, Collection<String> rmTypes, Collection<String> rmTypesConstraint, String attribute, boolean requiresVersionTableJoin) {
        super(alias, new ArrayList<AslQueryCondition>());
        this.type = type;
        this.rmTypes = List.copyOf(rmTypes);
        this.requiresVersionTableJoin = requiresVersionTableJoin;
        fields.forEach(this::addField);
        this.alias = alias;
        if (type != AslSourceRelation.EHR && type != AslSourceRelation.AUDIT_DETAILS) {
            List<String> aliasedRmTypes;
            if (!rmTypes.isEmpty() && NON_LOCATABLE_STRUCTURE_RM_TYPES.containsAll(aliasedRmTypes = rmTypes.stream().map(StructureRmType::getAliasOrTypeName).toList())) {
                this.structureConditions.add(new AslFieldValueQueryCondition(AslUtils.findFieldForOwner(AslStructureColumn.ENTITY_CONCEPT, this.getSelect(), (AslQuery)this), AslQueryCondition.AslConditionOperator.IS_NULL, List.of()));
            }
            if (!rmTypesConstraint.isEmpty()) {
                aliasedRmTypes = rmTypesConstraint.stream().map(StructureRmType::getAliasOrTypeName).toList();
                this.structureConditions.add(new AslFieldValueQueryCondition<String>(AslUtils.findFieldForOwner(AslStructureColumn.RM_ENTITY, this.getSelect(), (AslQuery)this), AslQueryCondition.AslConditionOperator.IN, aliasedRmTypes));
            }
            if (StringUtils.isNotBlank((CharSequence)attribute)) {
                this.structureConditions.add(new AslFieldValueQueryCondition<String>(new AslColumnField(String.class, ENTITY_ATTRIBUTE, AslField.FieldSource.withOwner(this), false), AslQueryCondition.AslConditionOperator.EQ, List.of(RmAttributeAlias.getAlias((String)attribute))));
            }
        }
    }

    public Collection<String> getRmTypes() {
        return this.rmTypes;
    }

    private void addField(AslField aslField) {
        this.fields.add(aslField.withOwner(this));
    }

    @Override
    public Map<IdentifiedPath, List<AslPathFilterJoinCondition>> joinConditionsForFiltering() {
        return this.joinConditionsForFiltering.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> List.of((AslPathFilterJoinCondition)e.getValue())));
    }

    public void addJoinConditionForFiltering(IdentifiedPath ip, AslQueryCondition condition) {
        this.joinConditionsForFiltering.put(ip, new AslPathFilterJoinCondition((AslQuery)this, condition));
    }

    @Override
    public List<AslField> getSelect() {
        return this.fields;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public AslSourceRelation getType() {
        return this.type;
    }

    public static enum AslSourceRelation {
        EHR(StructureRoot.EHR, null, (Table<?>)Tables.EHR_),
        EHR_STATUS(StructureRoot.EHR_STATUS, (Table<?>)Tables.EHR_STATUS_VERSION, (Table<?>)Tables.EHR_STATUS_DATA),
        COMPOSITION(StructureRoot.COMPOSITION, (Table<?>)Tables.COMP_VERSION, (Table<?>)Tables.COMP_DATA),
        FOLDER(StructureRoot.FOLDER, (Table<?>)Tables.EHR_FOLDER_VERSION, (Table<?>)Tables.EHR_FOLDER_DATA),
        AUDIT_DETAILS(null, null, (Table<?>)Tables.AUDIT_DETAILS);

        private static final Map<StructureRoot, AslSourceRelation> BY_STRUCTURE_ROOT;
        private final StructureRoot structureRoot;
        private final Table<?> versionTable;
        private final Table<?> dataTable;
        private final List<TableField<?, ?>> pkeyFields;

        private AslSourceRelation(StructureRoot structureRoot, Table<?> versionTable, Table<?> dataTable) {
            this.structureRoot = structureRoot;
            this.versionTable = versionTable;
            this.dataTable = dataTable;
            this.pkeyFields = List.of(((Table)ObjectUtils.firstNonNull((Object[])new Table[]{versionTable, dataTable})).getPrimaryKey().getFieldsArray());
        }

        public StructureRoot getStructureRoot() {
            return this.structureRoot;
        }

        public Table<?> getVersionTable() {
            return this.versionTable;
        }

        public Table<?> getDataTable() {
            return this.dataTable;
        }

        public List<TableField<?, ?>> getPkeyFields() {
            return this.pkeyFields;
        }

        public static AslSourceRelation get(StructureRoot structureRoot) {
            return BY_STRUCTURE_ROOT.get(structureRoot);
        }

        static {
            BY_STRUCTURE_ROOT = new EnumMap<StructureRoot, AslSourceRelation>(StructureRoot.class);
            for (AslSourceRelation value : AslSourceRelation.values()) {
                if (value.structureRoot == null) continue;
                BY_STRUCTURE_ROOT.put(value.structureRoot, value);
            }
        }
    }
}

