/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.sql;

import java.util.Iterator;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.jooq.Field;
import org.jooq.Table;
import org.jooq.TableField;

final class FieldUtils {
    private FieldUtils() {
    }

    public static <T> Field<T> field(Table<?> sqlProvider, AslQuery aslProvider, AslQuery owner, String fieldName, Class<T> type, boolean aliased) {
        return FieldUtils.field(sqlProvider, FieldUtils.findFieldByOwnerAndName(aslProvider, owner, fieldName), type, aliased);
    }

    private static AslColumnField findFieldByOwnerAndName(AslQuery src, AslQuery owner, String columnName) {
        Iterator fieldsIt = src.getSelect().stream().filter(AslColumnField.class::isInstance).map(AslColumnField.class::cast).filter(f -> owner == f.getOwner()).filter(f -> f.getColumnName().equals(columnName)).iterator();
        if (!fieldsIt.hasNext()) {
            throw new IllegalArgumentException("field with columnName %s not present".formatted(columnName));
        }
        AslColumnField field = (AslColumnField)fieldsIt.next();
        if (fieldsIt.hasNext()) {
            throw new IllegalArgumentException("found multiple fields with columnName %s".formatted(columnName));
        }
        return field;
    }

    public static Field<?> field(Table<?> table, AslComplexExtractedColumnField aslField, String fieldName, boolean aliased) {
        return table.field(aliased ? aslField.aliasedName(fieldName) : fieldName);
    }

    public static Field<?> field(Table<?> table, AslColumnField aslField, boolean aliased) {
        return table.field(aslField.getName(aliased));
    }

    public static <T> Field<T> field(Table<?> table, AslColumnField aslField, Class<T> type, boolean aliased) {
        return table.field(aslField.getName(aliased), type);
    }

    public static <T> Field<T> aliasedField(Table<?> target, AslDataQuery aslData, TableField<?, T> fieldTemplate) {
        return FieldUtils.field(target, aslData.getBase(), aslData.getBase(), fieldTemplate.getName(), fieldTemplate.getType(), true);
    }

    public static <T> Field<T> aliasedField(Table<?> target, AslDataQuery aslData, String fieldName, Class<T> fieldType) {
        return FieldUtils.field(target, aslData.getBase(), aslData.getBase(), fieldName, fieldType, true);
    }
}

