/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.featurecheck;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import org.ehrbase.api.exception.AqlFeatureNotImplementedException;
import org.ehrbase.api.exception.IllegalAqlException;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.featurecheck.ClauseType;
import org.ehrbase.openehr.aqlengine.featurecheck.FeatureCheck;
import org.ehrbase.openehr.aqlengine.featurecheck.FeatureCheckUtils;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.AggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.ColumnExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.CountDistinctAggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.select.SelectClause;

final class SelectCheck
implements FeatureCheck {
    private final SystemService systemService;

    public SelectCheck(SystemService systemService) {
        this.systemService = systemService;
    }

    @Override
    public void ensureSupported(AqlQuery aqlQuery) {
        SelectClause select = aqlQuery.getSelect();
        select.getStatement().forEach(selectExp -> {
            ColumnExpression columnExpression = selectExp.getColumnExpression();
            Objects.requireNonNull(columnExpression);
            ColumnExpression selector0$temp = columnExpression;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentifiedPath.class, AggregateFunction.class, Primitive.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    IdentifiedPath ip = (IdentifiedPath)selector0$temp;
                    this.ensureSelectPathSupported(ip);
                    break;
                }
                case 1: {
                    AggregateFunction af = (AggregateFunction)selector0$temp;
                    this.ensureAggregateFunctionSupported(af);
                    break;
                }
                case 2: {
                    Primitive __ = (Primitive)selector0$temp;
                    break;
                }
                default: {
                    throw new AqlFeatureNotImplementedException("%s is not supported in SELECT".formatted(selectExp.getClass().getSimpleName()));
                }
            }
        });
    }

    private void ensureAggregateFunctionSupported(AggregateFunction af) {
        AggregateFunction.AggregateFunctionName func = af.getFunctionName();
        IdentifiedPath ip = af.getIdentifiedPath();
        if (ip == null) {
            if (func != AggregateFunction.AggregateFunctionName.COUNT) {
                throw new IllegalAqlException("Aggregate function %s requires an identified path argument.".formatted(func));
            }
            if (af instanceof CountDistinctAggregateFunction) {
                throw new IllegalAqlException("COUNT(DISTINCT) requires an identified path argument");
            }
        } else {
            AbstractContainmentExpression containment = ip.getRoot();
            FeatureCheckUtils.PathDetails pathWithType = FeatureCheckUtils.findSupportedIdentifiedPath(ip, true, ClauseType.SELECT, this.systemService.getSystemId());
            if (func != AggregateFunction.AggregateFunctionName.COUNT) {
                if (pathWithType.extractedColumn() != null && !EnumSet.of(AslExtractedColumn.OV_TIME_COMMITTED, AslExtractedColumn.OV_TIME_COMMITTED_DV, AslExtractedColumn.EHR_TIME_CREATED, AslExtractedColumn.EHR_TIME_CREATED_DV).contains((Object)pathWithType.extractedColumn())) {
                    throw new AqlFeatureNotImplementedException("SELECT: Aggregate function %s is not supported for path %s/%s (COUNT only)".formatted(func, containment.getIdentifier(), ip.getPath().render()));
                }
                if (EnumSet.of(AggregateFunction.AggregateFunctionName.AVG, AggregateFunction.AggregateFunctionName.SUM).contains(func)) {
                    if (EnumSet.of(AslExtractedColumn.OV_TIME_COMMITTED, AslExtractedColumn.OV_TIME_COMMITTED_DV, AslExtractedColumn.EHR_TIME_CREATED, AslExtractedColumn.EHR_TIME_CREATED_DV).contains((Object)pathWithType.extractedColumn())) {
                        throw new AqlFeatureNotImplementedException("SELECT: Aggregate function %s(%s/%s) not applicable to the given path".formatted(func, containment.getIdentifier(), ip.getPath().render()));
                    }
                    if (pathWithType.targetsDvOrdered()) {
                        throw new AqlFeatureNotImplementedException("SELECT: Aggregate function %s(%s/%s) not applicable to paths targeting subtypes of DV_ORDERED".formatted(func, containment.getIdentifier(), ip.getPath().render()));
                    }
                    if (!pathWithType.targetsPrimitive()) {
                        throw new AqlFeatureNotImplementedException("SELECT: Aggregate function %s(%s/%s) only applicable to paths targeting primitive types".formatted(func, containment.getIdentifier(), ip.getPath().render()));
                    }
                } else if (EnumSet.of(AggregateFunction.AggregateFunctionName.MAX, AggregateFunction.AggregateFunctionName.MIN).contains(func) && !pathWithType.targetsPrimitive() && !pathWithType.targetsDvOrdered()) {
                    throw new AqlFeatureNotImplementedException("SELECT: Aggregate function %s(%s/%s) only applicable to paths targeting primitive types or subtypes of DV_ORDERED".formatted(func, containment.getIdentifier(), ip.getPath().render()));
                }
            }
        }
    }

    private void ensureSelectPathSupported(IdentifiedPath ip) {
        FeatureCheckUtils.findSupportedIdentifiedPath(ip, true, ClauseType.SELECT, this.systemService.getSystemId());
    }
}

