/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.featurecheck;

import com.nedap.archie.rm.datavalues.quantity.DvOrdered;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.exception.AqlFeatureNotImplementedException;
import org.ehrbase.api.exception.IllegalAqlException;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.AslRmTypeAndConcept;
import org.ehrbase.openehr.aqlengine.featurecheck.ClauseType;
import org.ehrbase.openehr.aqlengine.pathanalysis.ANode;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathAnalysis;
import org.ehrbase.openehr.dbformat.AncestorStructureRmType;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentVersionExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.operand.NullPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.render.AqlRenderer;
import org.ehrbase.openehr.sdk.aql.util.AqlUtil;

final class FeatureCheckUtils {
    public static final ArchieRMInfoLookup RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    private static final Set<String> DV_ORDERED_TYPES = RM_INFO_LOOKUP.getTypeInfo(DvOrdered.class).getAllDescendantClasses().stream().filter(t -> !Modifier.isAbstract(t.getJavaClass().getModifiers())).map(RMTypeInfo::getRmName).collect(Collectors.toSet());
    private static final Pattern OBJECT_VERSION_ID_REGEX = Pattern.compile("([a-fA-F0-9-]{36})(::([^:]*)::([1-9]\\d*))?");
    private static final List<Pair<List<String>, Set<ClauseType>>> SUPPORTED_VERSION_PATHS = Stream.of(Pair.of((Object)"uid/value", Set.of(ClauseType.SELECT, ClauseType.WHERE, ClauseType.ORDER_BY)), Pair.of((Object)"commit_audit/time_committed", Set.of(ClauseType.SELECT, ClauseType.WHERE, ClauseType.ORDER_BY)), Pair.of((Object)"commit_audit/time_committed/value", Set.of(ClauseType.SELECT)), Pair.of((Object)"commit_audit/system_id", Set.of(ClauseType.SELECT, ClauseType.WHERE)), Pair.of((Object)"commit_audit/description", Set.of(ClauseType.SELECT)), Pair.of((Object)"commit_audit/description/value", Set.of(ClauseType.SELECT, ClauseType.WHERE, ClauseType.ORDER_BY)), Pair.of((Object)"commit_audit/change_type", Set.of(ClauseType.SELECT)), Pair.of((Object)"commit_audit/change_type/value", Set.of(ClauseType.SELECT, ClauseType.WHERE, ClauseType.ORDER_BY)), Pair.of((Object)"commit_audit/change_type/defining_code/code_string", Set.of(ClauseType.SELECT, ClauseType.WHERE, ClauseType.ORDER_BY)), Pair.of((Object)"commit_audit/change_type/defining_code/preferred_term", Set.of(ClauseType.SELECT, ClauseType.WHERE, ClauseType.ORDER_BY)), Pair.of((Object)"commit_audit/change_type/defining_code/terminology_id/value", Set.of(ClauseType.SELECT, ClauseType.WHERE)), Pair.of((Object)"contribution/id/value", Set.of(ClauseType.SELECT, ClauseType.WHERE, ClauseType.ORDER_BY))).map(p -> Pair.of(Arrays.asList(((String)p.getLeft()).split("/")), (Object)((Set)p.getRight()))).toList();

    private FeatureCheckUtils() {
    }

    public static boolean startsWith(IdentifiedPath successor, IdentifiedPath predecessor) {
        if (successor == predecessor) {
            return true;
        }
        if (successor == null || predecessor == null) {
            return false;
        }
        if (!Objects.equals(successor.getRoot(), predecessor.getRoot())) {
            return false;
        }
        if (!Objects.equals(successor.getRootPredicate(), predecessor.getRootPredicate())) {
            return false;
        }
        List successorPathNodes = Optional.of(successor).map(IdentifiedPath::getPath).map(AqlObjectPath::getPathNodes).orElse(List.of());
        List predecessorPathNodes = Optional.of(predecessor).map(IdentifiedPath::getPath).map(AqlObjectPath::getPathNodes).orElse(List.of());
        int predecessorSize = predecessorPathNodes.size();
        if (successorPathNodes.size() < predecessorSize) {
            return false;
        }
        return predecessorPathNodes.equals(successorPathNodes.subList(0, predecessorSize));
    }

    private static void ensurePathPredicateSupported(AqlObjectPath path, String nodeType, List<AndOperatorPredicate> predicate, String systemId) {
        AqlUtil.streamPredicates(predicate).forEach(p -> {
            Optional<AslExtractedColumn> extractedColumn = AslExtractedColumn.find(nodeType, p.getPath());
            if (extractedColumn.isEmpty()) {
                throw new AqlFeatureNotImplementedException("Path predicate %s in path %s contains unsupported path %s".formatted(AqlRenderer.renderPredicate((List)predicate), path, p.getPath()));
            }
            if (extractedColumn.get() == AslExtractedColumn.ARCHETYPE_NODE_ID && !EnumSet.of(ComparisonOperatorPredicate.PredicateComparisonOperator.EQ, ComparisonOperatorPredicate.PredicateComparisonOperator.NEQ).contains(p.getOperator())) {
                throw new AqlFeatureNotImplementedException("Predicates on 'archetype_node_id' only support = and !=");
            }
            FeatureCheckUtils.ensureOperandSupported(new PathDetails(extractedColumn.get(), Set.of(nodeType)), p.getValue(), systemId);
        });
    }

    public static PathDetails findSupportedIdentifiedPath(IdentifiedPath ip, boolean allowEmpty, ClauseType clauseType, String systemId) {
        AbstractContainmentExpression root;
        AqlObjectPath path = ip.getPath();
        AbstractContainmentExpression abstractContainmentExpression = root = ip.getRoot();
        Objects.requireNonNull(abstractContainmentExpression);
        AbstractContainmentExpression abstractContainmentExpression2 = abstractContainmentExpression;
        int n = 0;
        String containmentType = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ContainmentClassExpression.class, ContainmentVersionExpression.class}, (Object)abstractContainmentExpression2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ContainmentClassExpression cce = (ContainmentClassExpression)abstractContainmentExpression2;
                yield cce.getType();
            }
            case 1 -> {
                ContainmentVersionExpression __ = (ContainmentVersionExpression)abstractContainmentExpression2;
                yield "ORIGINAL_VERSION";
            }
        };
        boolean isVersionPath = "ORIGINAL_VERSION".equals(containmentType);
        if (path == null) {
            if (allowEmpty) {
                if (isVersionPath) {
                    throw new AqlFeatureNotImplementedException("selecting the full VERSION object (%s)".formatted(root.getIdentifier()));
                }
                if ("EHR".equals(containmentType)) {
                    throw new AqlFeatureNotImplementedException("selecting the full EHR object (%s)".formatted(root.getIdentifier()));
                }
                return new PathDetails(null, AncestorStructureRmType.byTypeName((String)containmentType).map(AncestorStructureRmType::getDescendants).map(s -> s.stream().map(Enum::name).collect(Collectors.toSet())).orElse(Set.of(containmentType)));
            }
            throw new AqlFeatureNotImplementedException("%s: identified path for type %s is missing".formatted(new Object[]{clauseType, containmentType}));
        }
        if ("EHR".equals(containmentType)) {
            return AslExtractedColumn.find(containmentType, path).filter(ec -> !EnumSet.of(AslExtractedColumn.EHR_TIME_CREATED, AslExtractedColumn.EHR_SYSTEM_ID_DV).contains(ec) || clauseType == ClauseType.SELECT).map(ec -> new PathDetails((AslExtractedColumn)((Object)ec), Set.of("String"))).orElseThrow(() -> new AqlFeatureNotImplementedException("%s: identified path '%s' for type %s not supported".formatted(new Object[]{clauseType, path.render(), containmentType})));
        }
        List<String> pathAttributes = path.getPathNodes().stream().map(AqlObjectPath.PathNode::getAttribute).toList();
        if (isVersionPath && SUPPORTED_VERSION_PATHS.stream().filter(p -> ((Set)p.getRight()).contains((Object)clauseType)).map(Pair::getLeft).noneMatch(p -> p.equals(pathAttributes))) {
            throw new AqlFeatureNotImplementedException("%s: VERSION path %s/%s is not supported".formatted(new Object[]{clauseType, root.getIdentifier(), path.render()}));
        }
        int level = -1;
        ANode analyzed = PathAnalysis.analyzeAqlPathTypes(containmentType, ip.getRootPredicate(), root.getPredicates(), path, null);
        if (analyzed.getCandidateTypes().isEmpty()) {
            throw new IllegalAqlException("%s is not a valid RM path".formatted(ip.render()));
        }
        Map<ANode, Map<String, PathAnalysis.AttInfo>> attributeInfos = PathAnalysis.createAttributeInfos(analyzed);
        Set<String> targetTypes = new HashSet<String>();
        Set<String> parentTargetTypes = AncestorStructureRmType.byTypeName((String)containmentType).map(AncestorStructureRmType::getDescendants).map(s -> s.stream().map(Enum::name).collect(Collectors.toSet())).orElse(Set.of(containmentType));
        List pathNodes = path.getPathNodes();
        for (int i = 0; i < pathNodes.size(); ++i) {
            AqlObjectPath.PathNode pathNode = (AqlObjectPath.PathNode)pathNodes.get(i);
            String attribute = pathAttributes.get(i);
            ANode analyzedParent = analyzed;
            analyzed = analyzed.getAttribute(attribute);
            ++level;
            targetTypes = attributeInfos.get(analyzedParent).get(attribute).targetTypes().stream().filter(t -> !isVersionPath || !attribute.equals("commit_audit") || "AUDIT_DETAILS".equals(t)).collect(Collectors.toSet());
            Set<ANode.NodeCategory> categories = analyzed.getCategories();
            if (categories.contains((Object)ANode.NodeCategory.STRUCTURE_INTERMEDIATE)) {
                throw new AqlFeatureNotImplementedException("%s: path %s contains STRUCTURE_INTERMEDIATE attribute %s".formatted(new Object[]{clauseType, path.render(), attribute}));
            }
            if (clauseType == ClauseType.WHERE && i == pathNodes.size() - 1) {
                if (targetTypes.stream().map(arg_0 -> ((ArchieRMInfoLookup)RM_INFO_LOOKUP).getTypeInfo(arg_0)).noneMatch(t -> t == null || DV_ORDERED_TYPES.contains(t.getRmName()))) {
                    throw new AqlFeatureNotImplementedException("%s: path %s only targets types that are not derived from DV_ORDERED and not primitive".formatted(new Object[]{clauseType, path.render()}));
                }
            }
            if (categories.size() != 1 || Collections.disjoint(categories, Set.of(ANode.NodeCategory.STRUCTURE))) {
                AqlObjectPath subPath = new AqlObjectPath(path.getPathNodes().stream().skip(level).toList());
                Set<String> currentParentTargetTypes = parentTargetTypes;
                Optional<AslExtractedColumn> extractedColumn = AslExtractedColumn.find(currentParentTargetTypes.iterator().next(), subPath).filter(ec -> ec.getAllowedRmTypes().containsAll(currentParentTargetTypes));
                if (extractedColumn.isEmpty()) {
                    List condition = pathNode.getPredicateOrOperands();
                    if (AqlUtil.streamPredicates((List)condition).findAny().isPresent()) {
                        throw new AqlFeatureNotImplementedException("%s: path %s contains a non-structure attribute (%s) with at least one predicate".formatted(new Object[]{clauseType, path.render(), attribute}));
                    }
                } else {
                    List nodes = subPath.getPathNodes();
                    for (int j = 1; j < nodes.size(); ++j) {
                        AqlObjectPath.PathNode node = (AqlObjectPath.PathNode)nodes.get(j);
                        analyzedParent = analyzed;
                        analyzed = analyzed.getAttribute(node.getAttribute());
                        targetTypes = attributeInfos.get(analyzedParent).get(node.getAttribute()).targetTypes();
                    }
                    return new PathDetails(extractedColumn.get(), targetTypes);
                }
            }
            targetTypes.forEach(t -> FeatureCheckUtils.ensurePathPredicateSupported(path, t, pathNode.getPredicateOrOperands(), systemId));
            parentTargetTypes = targetTypes;
        }
        return new PathDetails(null, targetTypes);
    }

    public static void ensureOperandSupported(PathDetails pathWithType, Object operand, String systemId) {
        if (!(operand instanceof Primitive)) {
            throw new AqlFeatureNotImplementedException("Only primitive operands are supported");
        }
        if (operand instanceof NullPrimitive) {
            throw new AqlFeatureNotImplementedException("NULL is not supported");
        }
        if (pathWithType.extractedColumn() == AslExtractedColumn.VO_ID) {
            String system;
            if (!(operand instanceof StringPrimitive)) {
                throw new IllegalAqlException("/uid/value comparisons require a string operand");
            }
            StringPrimitive sp = (StringPrimitive)operand;
            String value = (String)((Object)sp.getValue());
            Matcher matcher = OBJECT_VERSION_ID_REGEX.matcher(value);
            if (!matcher.matches()) {
                throw new IllegalAqlException("%s is not a valid OBJECT_VERSION_ID/UID".formatted(value));
            }
            try {
                UUID.fromString(matcher.group(1));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalAqlException("%s does not start with a valid UID".formatted(value));
            }
            if (matcher.group(2) != null && StringUtils.isNotEmpty((CharSequence)(system = matcher.group(3))) && !system.equals(systemId)) {
                throw new IllegalAqlException("CREATING_SYSTEM_ID of %s does not match this server (%s)".formatted(value, systemId));
            }
        } else if (pathWithType.extractedColumn() == AslExtractedColumn.ARCHETYPE_NODE_ID) {
            if (!(operand instanceof StringPrimitive)) {
                throw new IllegalAqlException("%s comparisons require a string operand".formatted(AslExtractedColumn.ARCHETYPE_NODE_ID.getPath().render()));
            }
            StringPrimitive sp = (StringPrimitive)operand;
            try {
                AslRmTypeAndConcept.fromArchetypeNodeId((String)((Object)sp.getValue()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalAqlException((Throwable)e);
            }
        }
    }

    record PathDetails(AslExtractedColumn extractedColumn, Set<String> targetTypes) {
        public boolean targetsDvOrdered() {
            return this.targetTypes.stream().anyMatch(DV_ORDERED_TYPES::contains);
        }

        public boolean targetsPrimitive() {
            return this.targetTypes.stream().map(arg_0 -> ((ArchieRMInfoLookup)RM_INFO_LOOKUP).getTypeInfo(arg_0)).anyMatch(Objects::isNull);
        }
    }
}

