/*
 * Decompiled with CFR 0.152.
 */
package db.migration;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class V3__terminology
extends BaseJavaMigration {
    public void migrate(Context context) throws Exception {
        try (InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("terminology.xml");){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(resourceAsStream);
            this.setTerritory(context.getConnection(), document);
            this.setLanguage(context.getConnection(), document);
            this.setConcept(context.getConnection(), document);
        }
    }

    private void setTerritory(Connection connection, Document document) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO ehr.territory(code, twoletter, threeletter, text) VALUES (?, ?, ?, ?)");){
            NodeList territory = document.getElementsByTagName("Territory");
            for (int idx = 0; idx < territory.getLength(); ++idx) {
                Node item = territory.item(idx);
                NamedNodeMap attributes = item.getAttributes();
                Integer code = Integer.valueOf(attributes.getNamedItem("NumericCode").getNodeValue());
                String two = attributes.getNamedItem("TwoLetter").getNodeValue();
                String three = attributes.getNamedItem("ThreeLetter").getNodeValue();
                String text = attributes.getNamedItem("Text").getNodeValue();
                statement.setInt(1, code);
                statement.setString(2, two);
                statement.setString(3, three);
                statement.setString(4, text);
                statement.executeUpdate();
            }
        }
    }

    private void setLanguage(Connection connection, Document document) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO ehr.language(code, description) VALUES (?, ?)");){
            NodeList language = document.getElementsByTagName("Language");
            for (int idx = 0; idx < language.getLength(); ++idx) {
                Node item = language.item(idx);
                NamedNodeMap attributes = item.getAttributes();
                String code = attributes.getNamedItem("code").getNodeValue();
                String text = attributes.getNamedItem("Description").getNodeValue();
                statement.setString(1, code);
                statement.setString(2, text);
                statement.executeUpdate();
            }
        }
    }

    private void setConcept(Connection connection, Document document) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO ehr.concept(conceptId, language, description) VALUES (?, ?, ?)");){
            NodeList concept = document.getElementsByTagName("Concept");
            for (int idx = 0; idx < concept.getLength(); ++idx) {
                Node item = concept.item(idx);
                NamedNodeMap attributes = item.getAttributes();
                Integer code = Integer.valueOf(attributes.getNamedItem("ConceptID").getNodeValue());
                String language = attributes.getNamedItem("Language").getNodeValue();
                String text = attributes.getNamedItem("Rubric").getNodeValue();
                statement.setInt(1, code);
                statement.setString(2, language);
                statement.setString(3, text);
                statement.executeUpdate();
            }
        }
    }
}

